/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class VersionCheck {
    public static void check(Node hazelcastNode, String buildDate, String version) {
        if (!hazelcastNode.getGroupProperties().VERSION_CHECK_ENABLED.getBoolean()) {
            return;
        }
        ILogger logger = hazelcastNode.getLogger(VersionCheck.class.getName());
        String urlStr = "http://www.hazelcast.com/version.jsp?version=" + version;
        try {
            Document doc = VersionCheck.fetchWebService(urlStr);
            if (doc != null) {
                org.w3c.dom.Node nodeFinal = (org.w3c.dom.Node)XPathFactory.newInstance().newXPath().evaluate("/hazelcast-version/final", doc, XPathConstants.NODE);
                String finalVersion = nodeFinal.getAttributes().getNamedItem("version").getTextContent();
                String finalDate = nodeFinal.getAttributes().getNamedItem("date").getTextContent();
                org.w3c.dom.Node nodeSnapshot = (org.w3c.dom.Node)XPathFactory.newInstance().newXPath().evaluate("/hazelcast-version/snapshot", doc, XPathConstants.NODE);
                String snapshotVersion = nodeSnapshot.getAttributes().getNamedItem("version").getTextContent();
                String snapshotDate = nodeSnapshot.getAttributes().getNamedItem("date").getTextContent();
                if (version.indexOf("SNAPSHOT") == -1) {
                    int finalOne;
                    int currentDate = Integer.parseInt(buildDate);
                    if (currentDate < (finalOne = Integer.parseInt(finalDate))) {
                        StringBuilder sb = new StringBuilder("Newer version of Hazelcast is available.\n");
                        sb.append("======================================\n");
                        sb.append("\n");
                        sb.append("You are running " + version + "\t[" + buildDate + "]\n");
                        sb.append("Newer version " + finalVersion + "\t[" + finalDate + "]\n");
                        sb.append("\n");
                        sb.append("======================================\n");
                        logger.log(Level.WARNING, sb.toString());
                    }
                } else {
                    int availableOne;
                    int currentDate = Integer.parseInt(buildDate);
                    if (currentDate < (availableOne = Integer.parseInt(snapshotDate))) {
                        StringBuilder sb = new StringBuilder("Newer version of Hazelcast snapshot is available.\n");
                        sb.append("======================================\n");
                        sb.append("\n");
                        sb.append("You are running " + version + "\t[" + buildDate + "]\n");
                        sb.append("Newer version " + snapshotVersion + "\t[" + snapshotDate + "]\n");
                        sb.append("\n");
                        sb.append("======================================\n");
                        logger.log(Level.WARNING, sb.toString());
                    }
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document fetchWebService(String urlStr) {
        InputStream in = null;
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            in = new BufferedInputStream(conn.getInputStream());
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(in);
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

