/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlConfigHelper {
    protected String xmlToJavaName(String name) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = name.toCharArray();
        boolean dash = false;
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '-') {
                this.appendToken(builder, token);
                dash = true;
                continue;
            }
            token.append(dash ? Character.toUpperCase(charArray[i]) : charArray[i]);
            dash = false;
        }
        this.appendToken(builder, token);
        return builder.toString();
    }

    protected void appendToken(StringBuilder builder, StringBuilder token) {
        String string = token.toString();
        if ("Jvm".equals(string)) {
            string = "JVM";
        }
        builder.append(string);
        token.setLength(0);
    }

    protected String getTextContent(Node node) {
        return this.getTextContent2(node);
    }

    protected String getTextContent2(Node node) {
        Node child = node.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return this.hasTextContent(child) ? child.getNodeValue() : "";
            }
            StringBuffer buf = new StringBuffer();
            this.getTextContent2(node, buf);
            return buf.toString();
        }
        return "";
    }

    protected void getTextContent2(Node node, StringBuffer buf) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.hasTextContent(child)) continue;
            this.getTextContent2(child, buf);
        }
    }

    protected String getValue(Node node) {
        return this.getTextContent(node).trim();
    }

    protected final boolean hasTextContent(Node child) {
        short nodeType = child.getNodeType();
        boolean result = nodeType != 8 && nodeType != 7;
        return result;
    }

    public final String cleanNodeName(Node node) {
        return this.cleanNodeName(node.getNodeName());
    }

    public final String cleanNodeName(String nodeName) {
        String name = nodeName;
        if (name != null) {
            name = nodeName.replaceAll("\\w+:", "").toLowerCase();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IterableNodeList
    implements Iterable<Node> {
        private final NodeList parent;
        private final int maximum;
        private final short nodeType;

        public IterableNodeList(Node node) {
            this(node.getChildNodes());
        }

        public IterableNodeList(NodeList list) {
            this(list, 0);
        }

        public IterableNodeList(Node node, short nodeType) {
            this(node.getChildNodes(), nodeType);
        }

        public IterableNodeList(NodeList parent, short nodeType) {
            this.parent = parent;
            this.nodeType = nodeType;
            this.maximum = parent.getLength();
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){
                private int index = 0;
                private Node next;

                private boolean findNext() {
                    this.next = null;
                    while (this.index < IterableNodeList.this.maximum) {
                        Node item = IterableNodeList.this.parent.item(this.index);
                        if (IterableNodeList.this.nodeType == 0 || item.getNodeType() == IterableNodeList.this.nodeType) {
                            this.next = item;
                            return true;
                        }
                        ++this.index;
                    }
                    return false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                @Override
                public Node next() {
                    if (this.findNext()) {
                        ++this.index;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

