/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ThreadDumpGenerator;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

class ThreadDumpGeneratorImpl_15
extends ThreadDumpGenerator {
    public ThreadDumpGeneratorImpl_15(ThreadMXBean bean) {
        super(bean);
    }

    protected void appendThreadInfo(ThreadInfo info, StringBuilder sb) {
        sb.append("\"" + info.getThreadName() + "\"" + " Id=" + info.getThreadId() + " " + (Object)((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
        }
        sb.append('\n');
    }
}

