/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.impl.ascii.rest.HttpCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpPostCommand;
import com.hazelcast.impl.ascii.rest.RestValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    public HttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpPostCommand command) {
        String uri = command.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/")) {
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
            String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
            String key = uri.substring(indexEnd + 1);
            byte[] data = command.getData();
            this.textCommandService.put(mapName, key, new RestValue(data, command.getContentType()), 0);
            command.setResponse(HttpCommand.RES_204);
        } else {
            command.setResponse(HttpCommand.RES_400);
        }
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpPostCommand command) {
        this.handle(command);
    }
}

