/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector.map.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.connector.map.AsyncMap;
import com.hazelcast.connector.map.impl.Hz3ImplUtil;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class AsyncMapImpl<K, V>
implements AsyncMap<K, V> {
    private final IMap<K, V> map;

    AsyncMapImpl(IMap<K, V> map) {
        this.map = map;
    }

    public CompletionStage<V> getAsync(@Nonnull K key) {
        return Hz3ImplUtil.toCompletableFuture(this.map.getAsync(key));
    }

    public CompletionStage<Void> putAllAsync(Map<? extends K, ? extends V> items) {
        ClientMapProxy targetMap = (ClientMapProxy)this.map;
        if (items.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Preconditions.checkNotNull((Object)targetMap, (String)"Null argument map is not allowed");
        ClientPartitionService partitionService = targetMap.getContext().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        HashMap<Integer, List> entryMap = new HashMap<Integer, List>(partitionCount);
        InternalSerializationService serializationService = targetMap.getContext().getSerializationService();
        for (Map.Entry<K, V> entry : items.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), (String)"Null key is not allowed");
            Preconditions.checkNotNull(entry.getValue(), (String)"Null value is not allowed");
            Data keyData = serializationService.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId(keyData);
            entryMap.computeIfAbsent(partitionId, k -> new ArrayList()).add(new AbstractMap.SimpleEntry<Data, Data>(keyData, serializationService.toData(entry.getValue())));
        }
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)targetMap.getContext().getHazelcastInstance();
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        ExecutionCallback<Object> callback = this.createPutAllCallback(entryMap.size(), (NearCache<Object, Object>)(targetMap instanceof NearCachedClientMapProxy ? ((NearCachedClientMapProxy)targetMap).getNearCache() : null), items.keySet(), entryMap.values().stream().flatMap(Collection::stream).map(Map.Entry::getKey), resultFuture);
        for (Map.Entry partitionEntries : entryMap.entrySet()) {
            Integer partitionId = (Integer)partitionEntries.getKey();
            if (((List)partitionEntries.getValue()).size() == 1) {
                Map.Entry onlyEntry = (Map.Entry)((List)partitionEntries.getValue()).get(0);
                targetMap.setAsync(onlyEntry.getKey(), onlyEntry.getValue()).andThen(callback);
                continue;
            }
            ClientMessage request = MapPutAllCodec.encodeRequest((String)targetMap.getName(), (Collection)((Collection)partitionEntries.getValue()));
            new ClientInvocation(client, request, targetMap.getName(), partitionId.intValue()).invoke().andThen(callback);
        }
        return resultFuture;
    }

    private ExecutionCallback<Object> createPutAllCallback(int participantCount, final @Nullable NearCache<Object, Object> nearCache, final @Nonnull Set<?> nonSerializedKeys, final @Nonnull Stream<Data> serializedKeys, final CompletableFuture<Void> resultFuture) {
        final AtomicInteger completionCounter = new AtomicInteger(participantCount);
        return new ExecutionCallback<Object>(){

            public void onResponse(Object response) {
                if (completionCounter.decrementAndGet() > 0) {
                    return;
                }
                if (nearCache != null) {
                    if (nearCache.isSerializeKeys()) {
                        serializedKeys.forEach(arg_0 -> ((NearCache)nearCache).invalidate(arg_0));
                    } else {
                        for (Object key : nonSerializedKeys) {
                            nearCache.invalidate(key);
                        }
                    }
                }
                resultFuture.complete(null);
            }

            public void onFailure(Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        };
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public V get(Object key) {
        return (V)this.map.get(key);
    }

    public V put(K key, V value) {
        return (V)this.map.put(key, value);
    }

    public V remove(Object key) {
        return (V)this.map.remove(key);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

