/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector.map.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapFetchEntriesCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.connector.map.Reader;
import com.hazelcast.connector.map.impl.Hz3ImplUtil;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.Data;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapReader {
    private static final int MAX_FETCH_SIZE = 16384;

    static class RemoteMapReader
    extends Reader<CompletableFuture<ClientMessage>, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientMapProxy clientMapProxy;
        private final Function<Map.Entry<byte[], byte[]>, Object> toObject;

        RemoteMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName, Function<Map.Entry<byte[], byte[]>, Object> toObject) {
            super(mapName, r -> r.tableIndex, r -> r.entries);
            this.toObject = toObject;
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
        }

        @Nonnull
        public CompletableFuture<ClientMessage> readBatch(int partitionId, int offset) {
            ClientMessage request = MapFetchEntriesCodec.encodeRequest((String)this.objectName, (int)partitionId, (int)offset, (int)16384);
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, this.objectName, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            CompletableFuture<ClientMessage> result = Hz3ImplUtil.toCompletableFuture(future);
            return result;
        }

        @Nonnull
        public MapFetchEntriesCodec.ResponseParameters toBatchResult(@Nonnull CompletableFuture<ClientMessage> future) throws ExecutionException, InterruptedException {
            return MapFetchEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> entry) {
            return this.toObject.apply(new AbstractMap.SimpleEntry<byte[], byte[]>(entry.getKey().toByteArray(), entry.getValue().toByteArray()));
        }
    }
}

