/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector;

import com.hazelcast.connector.Hz3Util;
import com.hazelcast.connector.map.Hz3MapAdapter;
import com.hazelcast.connector.map.Reader;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

final class ReadMapOrCacheP<F extends CompletableFuture, B, R>
extends AbstractProcessor {
    private final Reader<F, B, R> reader;
    private final int[] partitionIds;
    private final BooleanSupplier migrationWatcher;
    private final int[] readOffsets;
    private F[] readFutures;
    private List<R> currentBatch = Collections.emptyList();
    private int currentBatchPosition;
    private int currentPartitionIndex = -1;
    private int numCompletedPartitions;

    private ReadMapOrCacheP(@Nonnull Reader<F, B, R> reader, @Nonnull int[] partitionIds, @Nonnull BooleanSupplier migrationWatcher) {
        this.reader = reader;
        this.partitionIds = partitionIds;
        this.migrationWatcher = migrationWatcher;
        this.readOffsets = new int[partitionIds.length];
        Arrays.fill(this.readOffsets, Integer.MAX_VALUE);
    }

    public boolean complete() {
        if (this.readFutures == null) {
            this.initialRead();
        }
        while (this.emitResultSet()) {
            if (this.tryGetNextResultSet()) continue;
            return this.numCompletedPartitions == this.partitionIds.length;
        }
        return false;
    }

    private void initialRead() {
        this.readFutures = new CompletableFuture[this.partitionIds.length];
        for (int i = 0; i < this.readFutures.length; ++i) {
            this.readFutures[i] = this.reader.readBatch(this.partitionIds[i], Integer.MAX_VALUE);
        }
    }

    private boolean emitResultSet() {
        this.checkMigration();
        while (this.currentBatchPosition < this.currentBatch.size()) {
            Object result = this.reader.toObject(this.currentBatch.get(this.currentBatchPosition));
            if (result != null && !this.tryEmit(result)) {
                return false;
            }
            ++this.currentBatchPosition;
        }
        return true;
    }

    private boolean tryGetNextResultSet() {
        while (this.currentBatch.size() == this.currentBatchPosition && ++this.currentPartitionIndex < this.partitionIds.length) {
            if (this.readOffsets[this.currentPartitionIndex] < 0) {
                assert (this.readFutures[this.currentPartitionIndex] == null) : "future not null";
                continue;
            }
            F future = this.readFutures[this.currentPartitionIndex];
            if (!((CompletableFuture)future).isDone()) continue;
            B result = this.toBatchResult(future);
            int nextIndex = this.reader.toNextIndex(result);
            if (nextIndex < 0) {
                ++this.numCompletedPartitions;
            } else assert (!this.currentBatch.isEmpty()) : "empty but not terminal batch";
            this.currentBatch = this.reader.toRecordSet(result);
            this.currentBatchPosition = 0;
            this.readOffsets[this.currentPartitionIndex] = nextIndex;
            this.readFutures[this.currentPartitionIndex] = this.readOffsets[this.currentPartitionIndex] >= 0 ? this.reader.readBatch(this.partitionIds[this.currentPartitionIndex], this.readOffsets[this.currentPartitionIndex]) : null;
        }
        if (this.currentPartitionIndex == this.partitionIds.length) {
            this.currentPartitionIndex = -1;
            return false;
        }
        return true;
    }

    private B toBatchResult(F future) {
        Object result;
        try {
            result = this.reader.toBatchResult(future);
        }
        catch (ExecutionException e) {
            Throwable ex = ExceptionUtil.peel((Throwable)e);
            if (ex instanceof HazelcastSerializationException) {
                throw new JetException("Serialization error when reading the map: are the key, value, predicate and projection classes visible to IMDG? You need to use User Code Deployment, adding the classes to JetConfig isn't enough", (Throwable)e);
            }
            throw ExceptionUtil.rethrow((Throwable)ex);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return (B)result;
    }

    private void checkMigration() {
        if (this.migrationWatcher.getAsBoolean()) {
            throw new RestartableException("Partition migration detected");
        }
    }

    static class RemoteProcessorSupplier<F extends CompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String mapName;
        private final String clientXml;
        private transient Hz3MapAdapter hz3MapAdapter;
        private transient InternalSerializationService serializationService;
        private transient int totalParallelism;
        private transient int baseIndex;

        RemoteProcessorSupplier(String mapName, @Nonnull String clientXml) {
            this.mapName = mapName;
            this.clientXml = clientXml;
        }

        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.hz3MapAdapter = Hz3Util.createMapAdapter(this.clientXml);
            HazelcastInstanceImpl hzInstance = (HazelcastInstanceImpl)context.hazelcastInstance();
            this.serializationService = hzInstance.node.getCompatibilitySerializationService();
            this.totalParallelism = context.totalParallelism();
            this.baseIndex = context.memberIndex() * context.localParallelism();
        }

        public void close(Throwable error) {
            this.hz3MapAdapter.shutdown();
        }

        @Nonnull
        public List<Processor> get(int count) {
            int remotePartitionCount = this.hz3MapAdapter.getPartitionCount();
            BooleanSupplier watcherInstance = this.hz3MapAdapter.createWatcher();
            return IntStream.range(0, count).mapToObj(i -> {
                int[] partitionIds = Util.roundRobinPart((int)remotePartitionCount, (int)this.totalParallelism, (int)(this.baseIndex + i));
                return new ReadMapOrCacheP(this.hz3MapAdapter.reader(this.mapName, this.toObjectFn()), partitionIds, watcherInstance);
            }).collect(Collectors.toList());
        }

        private Function<Map.Entry<byte[], byte[]>, Object> toObjectFn() {
            return entry -> {
                HeapData keyData = new HeapData((byte[])entry.getKey());
                HeapData valueData = new HeapData((byte[])entry.getValue());
                return new LazyMapEntry((Data)keyData, (Object)valueData, this.serializationService);
            };
        }
    }
}

