/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector;

import com.hazelcast.connector.Hz3Util;
import com.hazelcast.connector.map.AsyncMap;
import com.hazelcast.connector.map.Hz3MapAdapter;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class Hz3Enrichment {
    private Hz3Enrichment() {
    }

    public static <K, V> ServiceFactory<Hz3MapAdapter, AsyncMap<K, V>> hz3MapServiceFactory(String mapName, String clientXML) {
        return ServiceFactory.withCreateContextFn((FunctionEx & Serializable)context -> Hz3Util.createMapAdapter(clientXML)).withCreateServiceFn((BiFunctionEx & Serializable)(context, hz3MapAdapter) -> {
            AsyncMap v = hz3MapAdapter.getMap(mapName);
            return v;
        }).withDestroyContextFn(Hz3MapAdapter::shutdown);
    }

    public static <K, V> ServiceFactory<Hz3MapAdapter, Map<K, V>> hz3ReplicatedMapServiceFactory(String mapName, String clientXML) {
        return ServiceFactory.withCreateContextFn((FunctionEx & Serializable)context -> Hz3Util.createMapAdapter(clientXML)).withCreateServiceFn((BiFunctionEx & Serializable)(context, hz3MapAdapter) -> {
            Map v = hz3MapAdapter.getReplicatedMap(mapName);
            return v;
        }).withDestroyContextFn(Hz3MapAdapter::shutdown);
    }

    public static <K, V, T, R> BiFunctionEx<? super AsyncMap<K, V>, ? super T, CompletableFuture<R>> mapUsingIMapAsync(@Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return (BiFunctionEx & Serializable)(kvMap, t) -> kvMap.getAsync(lookupKeyFn.apply(t)).toCompletableFuture().thenApply(e -> mapFn.apply(t, e));
    }

    public static <K, V, T, R> BiFunctionEx<? super Map<K, V>, ? super T, R> mapUsingIMap(@Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return (BiFunctionEx & Serializable)(kvMap, t) -> mapFn.apply(t, kvMap.get(lookupKeyFn.apply(t)));
    }
}

