/*
 * Decompiled with CFR 0.152.
 */
package com.hannesdorfmann.adapterdelegates4;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SparseArrayCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hannesdorfmann.adapterdelegates4.AdapterDelegate;
import java.util.Collections;
import java.util.List;

public class AdapterDelegatesManager<T> {
    static final int FALLBACK_DELEGATE_VIEW_TYPE = 0x7FFFFFFE;
    private static final List<Object> PAYLOADS_EMPTY_LIST = Collections.emptyList();
    protected SparseArrayCompat<AdapterDelegate<T>> delegates = new SparseArrayCompat();
    protected AdapterDelegate<T> fallbackDelegate;

    public AdapterDelegatesManager<T> addDelegate(@NonNull AdapterDelegate<T> delegate) {
        int viewType = this.delegates.size();
        while (this.delegates.get(viewType) != null) {
            if (++viewType != 0x7FFFFFFE) continue;
            throw new IllegalArgumentException("Oops, we are very close to Integer.MAX_VALUE. It seems that there are no more free and unused view type integers left to add another AdapterDelegate.");
        }
        return this.addDelegate(viewType, false, delegate);
    }

    public AdapterDelegatesManager<T> addDelegate(int viewType, @NonNull AdapterDelegate<T> delegate) {
        return this.addDelegate(viewType, false, delegate);
    }

    public AdapterDelegatesManager<T> addDelegate(int viewType, boolean allowReplacingDelegate, @NonNull AdapterDelegate<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("AdapterDelegate is null!");
        }
        if (viewType == 0x7FFFFFFE) {
            throw new IllegalArgumentException("The view type = 2147483646 is reserved for fallback adapter delegate (see setFallbackDelegate() ). Please use another view type.");
        }
        if (!allowReplacingDelegate && this.delegates.get(viewType) != null) {
            throw new IllegalArgumentException("An AdapterDelegate is already registered for the viewType = " + viewType + ". Already registered AdapterDelegate is " + this.delegates.get(viewType));
        }
        this.delegates.put(viewType, delegate);
        return this;
    }

    public AdapterDelegatesManager<T> removeDelegate(@NonNull AdapterDelegate<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("AdapterDelegate is null");
        }
        int indexToRemove = this.delegates.indexOfValue(delegate);
        if (indexToRemove >= 0) {
            this.delegates.removeAt(indexToRemove);
        }
        return this;
    }

    public AdapterDelegatesManager<T> removeDelegate(int viewType) {
        this.delegates.remove(viewType);
        return this;
    }

    public int getItemViewType(@NonNull T items, int position) {
        if (items == null) {
            throw new NullPointerException("Items datasource is null!");
        }
        int delegatesCount = this.delegates.size();
        for (int i = 0; i < delegatesCount; ++i) {
            AdapterDelegate delegate = (AdapterDelegate)this.delegates.valueAt(i);
            if (!delegate.isForViewType(items, position)) continue;
            return this.delegates.keyAt(i);
        }
        if (this.fallbackDelegate != null) {
            return 0x7FFFFFFE;
        }
        throw new NullPointerException("No AdapterDelegate added that matches position=" + position + " in data source");
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        AdapterDelegate<T> delegate = this.getDelegateForViewType(viewType);
        if (delegate == null) {
            throw new NullPointerException("No AdapterDelegate added for ViewType " + viewType);
        }
        RecyclerView.ViewHolder vh = delegate.onCreateViewHolder(parent);
        if (vh == null) {
            throw new NullPointerException("ViewHolder returned from AdapterDelegate " + delegate + " for ViewType =" + viewType + " is null!");
        }
        return vh;
    }

    public void onBindViewHolder(@NonNull T items, int position, @NonNull RecyclerView.ViewHolder holder, List payloads) {
        AdapterDelegate<T> delegate = this.getDelegateForViewType(holder.getItemViewType());
        if (delegate == null) {
            throw new NullPointerException("No delegate found for item at position = " + position + " for viewType = " + holder.getItemViewType());
        }
        delegate.onBindViewHolder(items, position, holder, payloads != null ? payloads : PAYLOADS_EMPTY_LIST);
    }

    public void onBindViewHolder(@NonNull T items, int position, @NonNull RecyclerView.ViewHolder holder) {
        this.onBindViewHolder(items, position, holder, PAYLOADS_EMPTY_LIST);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        AdapterDelegate<T> delegate = this.getDelegateForViewType(holder.getItemViewType());
        if (delegate == null) {
            throw new NullPointerException("No delegate found for " + holder + " for item at position = " + holder.getAdapterPosition() + " for viewType = " + holder.getItemViewType());
        }
        delegate.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        AdapterDelegate<T> delegate = this.getDelegateForViewType(holder.getItemViewType());
        if (delegate == null) {
            throw new NullPointerException("No delegate found for " + holder + " for item at position = " + holder.getAdapterPosition() + " for viewType = " + holder.getItemViewType());
        }
        return delegate.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        AdapterDelegate<T> delegate = this.getDelegateForViewType(holder.getItemViewType());
        if (delegate == null) {
            throw new NullPointerException("No delegate found for " + holder + " for item at position = " + holder.getAdapterPosition() + " for viewType = " + holder.getItemViewType());
        }
        delegate.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        AdapterDelegate<T> delegate = this.getDelegateForViewType(holder.getItemViewType());
        if (delegate == null) {
            throw new NullPointerException("No delegate found for " + holder + " for item at position = " + holder.getAdapterPosition() + " for viewType = " + holder.getItemViewType());
        }
        delegate.onViewDetachedFromWindow(holder);
    }

    public AdapterDelegatesManager<T> setFallbackDelegate(@Nullable AdapterDelegate<T> fallbackDelegate) {
        this.fallbackDelegate = fallbackDelegate;
        return this;
    }

    public int getViewType(@NonNull AdapterDelegate<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("Delegate is null");
        }
        int index = this.delegates.indexOfValue(delegate);
        if (index == -1) {
            return -1;
        }
        return this.delegates.keyAt(index);
    }

    @Nullable
    public AdapterDelegate<T> getDelegateForViewType(int viewType) {
        return (AdapterDelegate)this.delegates.get(viewType, this.fallbackDelegate);
    }

    @Nullable
    public AdapterDelegate<T> getFallbackDelegate() {
        return this.fallbackDelegate;
    }
}

