/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.utility.LexiconUtility;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class DynamicCustomDictionary {
    public BinTrie<CoreDictionary.Attribute> trie;
    public DoubleArrayTrie<CoreDictionary.Attribute> dat;
    public String[] path;
    public boolean normalization = HanLP.Config.Normalization;

    public DynamicCustomDictionary() {
        this(HanLP.Config.CustomDictionaryPath);
    }

    public DynamicCustomDictionary(String ... path) {
        this(new DoubleArrayTrie<CoreDictionary.Attribute>(), new BinTrie<CoreDictionary.Attribute>(), path);
    }

    public DynamicCustomDictionary(DoubleArrayTrie<CoreDictionary.Attribute> dat, BinTrie<CoreDictionary.Attribute> trie, String[] path) {
        this.dat = dat;
        this.trie = trie;
        if (path != null) {
            this.load(path);
        }
    }

    public boolean load(String ... path) {
        long start = System.currentTimeMillis();
        if (!DynamicCustomDictionary.loadMainDictionary(path[0], path, this.dat, true, this.normalization)) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + Arrays.toString(path) + "\u52a0\u8f7d\u5931\u8d25");
            return false;
        }
        Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + this.dat.size() + "\u4e2a\u8bcd\u6761\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        this.path = path;
        return true;
    }

    public static boolean loadMainDictionary(String mainPath, String[] path, DoubleArrayTrie<CoreDictionary.Attribute> dat, boolean isCache, boolean normalization) {
        Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + mainPath);
        if (DynamicCustomDictionary.loadDat(mainPath, dat)) {
            return true;
        }
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        LinkedHashSet<Nature> customNatureCollector = new LinkedHashSet<Nature>();
        try {
            for (String p : path) {
                Nature defaultNature = Nature.n;
                File file = new File(p);
                String fileName = file.getName();
                int cut = fileName.lastIndexOf(32);
                if (cut > 0) {
                    String nature = fileName.substring(cut + 1);
                    p = file.getParent() + File.separator + fileName.substring(0, cut);
                    try {
                        defaultNature = LexiconUtility.convertStringToNature(nature, customNatureCollector);
                    }
                    catch (Exception e) {
                        Predefine.logger.severe("\u914d\u7f6e\u6587\u4ef6\u3010" + p + "\u3011\u5199\u9519\u4e86\uff01" + e);
                        continue;
                    }
                }
                Predefine.logger.info("\u4ee5\u9ed8\u8ba4\u8bcd\u6027[" + defaultNature + "]\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8bcd\u5178" + p + "\u4e2d\u2026\u2026");
                boolean success = DynamicCustomDictionary.load(p, defaultNature, map, customNatureCollector, normalization);
                if (success) continue;
                Predefine.logger.warning("\u5931\u8d25\uff1a" + p);
            }
            if (map.size() == 0) {
                Predefine.logger.warning("\u6ca1\u6709\u52a0\u8f7d\u5230\u4efb\u4f55\u8bcd\u6761");
                map.put("\u672a##\u5b83", null);
            }
            Predefine.logger.info("\u6b63\u5728\u6784\u5efaDoubleArrayTrie\u2026\u2026");
            dat.build(map);
            if (isCache) {
                Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u8bcd\u5178\u4e3adat\u6587\u4ef6\u2026\u2026");
                LinkedList attributeList = new LinkedList();
                for (Map.Entry entry : map.entrySet()) {
                    attributeList.add(entry.getValue());
                }
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(IOUtil.newOutputStream(mainPath + ".bin")));
                if (customNatureCollector.isEmpty()) {
                    for (int i = Nature.begin.ordinal() + 1; i < Nature.values().length; ++i) {
                        customNatureCollector.add(Nature.values()[i]);
                    }
                }
                IOUtil.writeCustomNature(out, customNatureCollector);
                out.writeInt(attributeList.size());
                for (CoreDictionary.Attribute attribute : attributeList) {
                    attribute.save(out);
                }
                dat.save(out);
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        catch (Exception e) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u7f13\u5b58\u5931\u8d25\uff01\n" + TextUtility.exceptionToString(e));
        }
        return true;
    }

    public boolean loadMainDictionary(String mainPath, boolean normalization) {
        return DynamicCustomDictionary.loadMainDictionary(mainPath, this.path, this.dat, true, normalization);
    }

    public static boolean load(String path, Nature defaultNature, TreeMap<String, CoreDictionary.Attribute> map, LinkedHashSet<Nature> customNatureCollector, boolean normalization) {
        try {
            String line;
            String splitter = "\\s";
            if (path.endsWith(".csv")) {
                splitter = ",";
            } else if (path.endsWith(".tsv")) {
                splitter = "\t";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            boolean firstLine = true;
            while ((line = br.readLine()) != null) {
                CoreDictionary.Attribute attribute;
                int natureCount;
                String[] param;
                if (firstLine) {
                    line = IOUtil.removeUTF8BOM(line);
                    firstLine = false;
                }
                if ((param = line.split(splitter))[0].length() == 0) continue;
                if (normalization) {
                    param[0] = CharTable.convert(param[0]);
                }
                if ((natureCount = (param.length - 1) / 2) == 0) {
                    attribute = new CoreDictionary.Attribute(defaultNature);
                } else {
                    attribute = new CoreDictionary.Attribute(natureCount);
                    for (int i = 0; i < natureCount; ++i) {
                        attribute.nature[i] = LexiconUtility.convertStringToNature(param[1 + 2 * i], customNatureCollector);
                        attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                        attribute.totalFrequency += attribute.frequency[i];
                    }
                }
                map.put(param[0], attribute);
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        return true;
    }

    private boolean updateAttributeIfExist(String key, CoreDictionary.Attribute attribute, TreeMap<String, CoreDictionary.Attribute> map, TreeMap<Integer, CoreDictionary.Attribute> rewriteTable) {
        int wordID = CoreDictionary.getWordID(key);
        if (wordID != -1) {
            CoreDictionary.Attribute attributeExisted = CoreDictionary.get(wordID);
            attributeExisted.nature = attribute.nature;
            attributeExisted.frequency = attribute.frequency;
            attributeExisted.totalFrequency = attribute.totalFrequency;
            rewriteTable.put(wordID, attribute);
            return true;
        }
        CoreDictionary.Attribute attributeExisted = map.get(key);
        if (attributeExisted != null) {
            attributeExisted.nature = attribute.nature;
            attributeExisted.frequency = attribute.frequency;
            attributeExisted.totalFrequency = attribute.totalFrequency;
            return true;
        }
        return false;
    }

    public boolean add(String word, String natureWithFrequency) {
        if (this.contains(word)) {
            return false;
        }
        return this.insert(word, natureWithFrequency);
    }

    public boolean add(String word) {
        if (this.normalization) {
            word = CharTable.convert(word);
        }
        if (this.contains(word)) {
            return false;
        }
        return this.insert(word, null);
    }

    public boolean insert(String word, String natureWithFrequency) {
        CoreDictionary.Attribute att;
        if (word == null) {
            return false;
        }
        if (this.normalization) {
            word = CharTable.convert(word);
        }
        CoreDictionary.Attribute attribute = att = natureWithFrequency == null ? new CoreDictionary.Attribute(Nature.nz, 1) : CoreDictionary.Attribute.create(natureWithFrequency);
        if (att == null) {
            return false;
        }
        if (this.dat.set(word, att)) {
            return true;
        }
        if (this.trie == null) {
            this.trie = new BinTrie();
        }
        this.trie.put(word, att);
        return true;
    }

    public boolean insert(String word) {
        return this.insert(word, null);
    }

    public static boolean loadDat(String path, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        return DynamicCustomDictionary.loadDat(path, HanLP.Config.CustomDictionaryPath, dat);
    }

    public static boolean loadDat(String path, String[] customDicPath, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        try {
            if (HanLP.Config.CustomDictionaryAutoRefreshCache && DynamicCustomDictionary.isDicNeedUpdate(path, customDicPath)) {
                return false;
            }
            ByteArray byteArray = ByteArray.createByteArray(path + ".bin");
            if (byteArray == null) {
                return false;
            }
            int size = byteArray.nextInt();
            if (size < 0) {
                while (++size <= 0) {
                    Nature.create(byteArray.nextString());
                }
                size = byteArray.nextInt();
            }
            CoreDictionary.Attribute[] attributes = new CoreDictionary.Attribute[size];
            Nature[] natureIndexArray = Nature.values();
            for (int i = 0; i < size; ++i) {
                int currentTotalFrequency = byteArray.nextInt();
                int length = byteArray.nextInt();
                attributes[i] = new CoreDictionary.Attribute(length);
                attributes[i].totalFrequency = currentTotalFrequency;
                for (int j = 0; j < length; ++j) {
                    attributes[i].nature[j] = natureIndexArray[byteArray.nextInt()];
                    attributes[i].frequency[j] = byteArray.nextInt();
                }
            }
            if (!dat.load(byteArray, (CoreDictionary.Attribute[])attributes)) {
                return false;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6\u5931\u8d25\uff0c\u95ee\u9898\u53d1\u751f\u5728" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    public static boolean isDicNeedUpdate(String mainPath, String[] path) {
        if (HanLP.Config.IOAdapter != null && !HanLP.Config.IOAdapter.getClass().getName().contains("com.hankcs.hanlp.corpus.io.FileIOAdapter")) {
            return false;
        }
        String binPath = mainPath + ".bin";
        File binFile = new File(binPath);
        if (!binFile.exists()) {
            return true;
        }
        long lastModified = binFile.lastModified();
        for (String p : path) {
            File f = new File(p);
            String fileName = f.getName();
            int cut = fileName.lastIndexOf(32);
            if (cut > 0) {
                p = f.getParent() + File.separator + fileName.substring(0, cut);
            }
            if (!(f = new File(p)).exists() || f.lastModified() <= lastModified) continue;
            IOUtil.deleteFile(binPath);
            Predefine.logger.info("\u5df2\u6e05\u9664\u81ea\u5b9a\u4e49\u8bcd\u5178\u7f13\u5b58\u6587\u4ef6\uff01");
            return true;
        }
        return false;
    }

    public CoreDictionary.Attribute get(String key) {
        CoreDictionary.Attribute attribute;
        if (this.normalization) {
            key = CharTable.convert(key);
        }
        if ((attribute = this.dat.get(key)) != null) {
            return attribute;
        }
        if (this.trie == null) {
            return null;
        }
        return this.trie.get(key);
    }

    public void remove(String key) {
        if (this.normalization) {
            key = CharTable.convert(key);
        }
        if (this.trie == null) {
            return;
        }
        this.trie.remove(key);
    }

    public LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(String key) {
        return this.trie.commonPrefixSearchWithValue(key);
    }

    public LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(char[] chars, int begin) {
        return this.trie.commonPrefixSearchWithValue(chars, begin);
    }

    public BaseSearcher getSearcher(String text) {
        return new Searcher(text);
    }

    public String toString() {
        return "DynamicCustomDictionary{trie=" + this.trie + '}';
    }

    public boolean contains(String key) {
        if (this.dat.exactMatchSearch(key) >= 0) {
            return true;
        }
        return this.trie != null && this.trie.containsKey(key);
    }

    public BaseSearcher getSearcher(char[] charArray) {
        return new Searcher(charArray);
    }

    public BinTrie<CoreDictionary.Attribute> getTrie() {
        return this.trie;
    }

    public void parseText(char[] text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        if (this.trie != null) {
            this.trie.parseText(text, processor);
        }
        DoubleArrayTrie.Searcher searcher = this.dat.getSearcher(text, 0);
        while (searcher.next()) {
            processor.hit(searcher.begin, searcher.begin + searcher.length, (CoreDictionary.Attribute)searcher.value);
        }
    }

    public void parseText(String text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        Object searcher;
        if (this.trie != null) {
            Map.Entry entry;
            searcher = this.getSearcher(text);
            while ((entry = ((BaseSearcher)searcher).next()) != null) {
                int offset = ((BaseSearcher)searcher).getOffset();
                processor.hit(offset, offset + entry.getKey().length(), (CoreDictionary.Attribute)entry.getValue());
            }
        }
        searcher = this.dat.getSearcher(text, 0);
        while (((DoubleArrayTrie.Searcher)searcher).next()) {
            processor.hit(((DoubleArrayTrie.Searcher)searcher).begin, ((DoubleArrayTrie.Searcher)searcher).begin + ((DoubleArrayTrie.Searcher)searcher).length, (CoreDictionary.Attribute)((DoubleArrayTrie.Searcher)searcher).value);
        }
    }

    public void parseLongestText(String text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        if (this.trie != null) {
            final int[] lengthArray = new int[text.length()];
            final CoreDictionary.Attribute[] attributeArray = new CoreDictionary.Attribute[text.length()];
            char[] charArray = text.toCharArray();
            DoubleArrayTrie.Searcher searcher = this.dat.getSearcher(charArray, 0);
            while (searcher.next()) {
                lengthArray[searcher.begin] = searcher.length;
                attributeArray[searcher.begin] = (CoreDictionary.Attribute)searcher.value;
            }
            this.trie.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

                @Override
                public void hit(int begin, int end, CoreDictionary.Attribute value) {
                    int length = end - begin;
                    if (length > lengthArray[begin]) {
                        lengthArray[begin] = length;
                        attributeArray[begin] = value;
                    }
                }
            });
            int i = 0;
            while (i < charArray.length) {
                if (lengthArray[i] == 0) {
                    ++i;
                    continue;
                }
                processor.hit(i, i + lengthArray[i], attributeArray[i]);
                i += lengthArray[i];
            }
        } else {
            this.dat.parseLongestText(text, processor);
        }
    }

    public boolean reload() {
        if (this.path == null || this.path.length == 0) {
            return false;
        }
        IOUtil.deleteFile(this.path[0] + ".bin");
        return this.loadMainDictionary(this.path[0], this.normalization);
    }

    class Searcher
    extends BaseSearcher<CoreDictionary.Attribute> {
        int begin;
        private LinkedList<Map.Entry<String, CoreDictionary.Attribute>> entryList;

        protected Searcher(char[] c) {
            super(c);
            this.entryList = new LinkedList();
        }

        protected Searcher(String text) {
            super(text);
            this.entryList = new LinkedList();
        }

        @Override
        public Map.Entry<String, CoreDictionary.Attribute> next() {
            while (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = DynamicCustomDictionary.this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = DynamicCustomDictionary.this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0) {
                return null;
            }
            Map.Entry<String, CoreDictionary.Attribute> result = this.entryList.getFirst();
            this.entryList.removeFirst();
            this.offset = this.begin - 1;
            return result;
        }
    }
}

