/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg;

import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.pipe.Pipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SegmentPipeline
extends Segment
implements Pipe<String, List<Term>>,
List<Pipe<List<IWord>, List<IWord>>> {
    Pipe<String, List<IWord>> first;
    Pipe<List<IWord>, List<Term>> last;
    List<Pipe<List<IWord>, List<IWord>>> pipeList;

    private SegmentPipeline(Pipe<String, List<IWord>> first, Pipe<List<IWord>, List<Term>> last) {
        this.first = first;
        this.last = last;
        this.pipeList = new ArrayList<Pipe<List<IWord>, List<IWord>>>();
    }

    public SegmentPipeline(final Segment delegate) {
        this(new Pipe<String, List<IWord>>(){

            @Override
            public List<IWord> flow(String input) {
                LinkedList<IWord> task = new LinkedList<IWord>();
                task.add(new Word(input, null));
                return task;
            }
        }, new Pipe<List<IWord>, List<Term>>(){

            @Override
            public List<Term> flow(List<IWord> input) {
                ArrayList<Term> output = new ArrayList<Term>(input.size());
                for (IWord word : input) {
                    if (word.getLabel() == null) {
                        output.addAll(delegate.seg(word.getValue()));
                        continue;
                    }
                    output.add(new Term(word.getValue(), Nature.create(word.getLabel())));
                }
                return output;
            }
        });
        this.config = delegate.config;
    }

    @Override
    protected List<Term> segSentence(char[] sentence) {
        return this.seg(new String(sentence));
    }

    @Override
    public List<Term> seg(String text) {
        return this.flow(text);
    }

    @Override
    public List<Term> flow(String input) {
        List<IWord> i = this.first.flow(input);
        for (Pipe<List<IWord>, List<IWord>> pipe : this.pipeList) {
            i = pipe.flow(i);
        }
        return this.last.flow(i);
    }

    @Override
    public int size() {
        return this.pipeList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.pipeList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.pipeList.contains(o);
    }

    @Override
    public Iterator<Pipe<List<IWord>, List<IWord>>> iterator() {
        return this.pipeList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.pipeList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.pipeList.toArray(a);
    }

    @Override
    public boolean add(Pipe<List<IWord>, List<IWord>> pipe) {
        return this.pipeList.add(pipe);
    }

    @Override
    public boolean remove(Object o) {
        return this.pipeList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.pipeList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Pipe<List<IWord>, List<IWord>>> c) {
        return this.pipeList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Pipe<List<IWord>, List<IWord>>> c) {
        return this.pipeList.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.pipeList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.pipeList.retainAll(c);
    }

    @Override
    public void clear() {
        this.pipeList.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.pipeList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.pipeList.hashCode();
    }

    @Override
    public Pipe<List<IWord>, List<IWord>> get(int index) {
        return this.pipeList.get(index);
    }

    @Override
    public Pipe<List<IWord>, List<IWord>> set(int index, Pipe<List<IWord>, List<IWord>> element) {
        return this.pipeList.set(index, element);
    }

    @Override
    public void add(int index, Pipe<List<IWord>, List<IWord>> element) {
        this.pipeList.add(index, element);
    }

    @Override
    public Pipe<List<IWord>, List<IWord>> remove(int index) {
        return this.pipeList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.pipeList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.pipeList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Pipe<List<IWord>, List<IWord>>> listIterator() {
        return this.pipeList.listIterator();
    }

    @Override
    public ListIterator<Pipe<List<IWord>, List<IWord>>> listIterator(int index) {
        return this.pipeList.listIterator(index);
    }

    @Override
    public List<Pipe<List<IWord>, List<IWord>>> subList(int fromIndex, int toIndex) {
        return this.pipeList.subList(fromIndex, toIndex);
    }
}

