/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BaseNode;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.dictionary.other.CharType;
import com.hankcs.hanlp.seg.Config;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.SentencesUtil;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class Segment {
    protected Config config = new Config();

    protected static List<AtomNode> atomSegment(char[] charArray, int start, int end) {
        ArrayList<AtomNode> atomSegment = new ArrayList<AtomNode>();
        int pCur = start;
        StringBuilder sb = new StringBuilder();
        int[] charTypeArray = new int[end - start];
        for (int i = 0; i < charTypeArray.length; ++i) {
            char c = charArray[i + start];
            charTypeArray[i] = CharType.get(c);
            if (c == '.' && i + start < charArray.length - 1 && CharType.get(charArray[i + start + 1]) == 9) {
                charTypeArray[i] = 9;
                continue;
            }
            if (c == '.' && i + start < charArray.length - 1 && charArray[i + start + 1] >= '0' && charArray[i + start + 1] <= '9') {
                charTypeArray[i] = 5;
                continue;
            }
            if (charTypeArray[i] != 8) continue;
            charTypeArray[i] = 5;
        }
        while (pCur < end) {
            int nCurType = charTypeArray[pCur - start];
            if (nCurType == 7 || nCurType == 10 || nCurType == 6 || nCurType == 17) {
                String single = String.valueOf(charArray[pCur]);
                if (single.length() != 0) {
                    atomSegment.add(new AtomNode(single, nCurType));
                }
                ++pCur;
                continue;
            }
            if (pCur < end - 1 && (nCurType == 5 || nCurType == 9)) {
                sb.delete(0, sb.length());
                sb.append(charArray[pCur]);
                boolean reachEnd = true;
                while (pCur < end - 1) {
                    int nNextType;
                    if ((nNextType = charTypeArray[++pCur - start]) == nCurType) {
                        sb.append(charArray[pCur]);
                        continue;
                    }
                    reachEnd = false;
                    break;
                }
                atomSegment.add(new AtomNode(sb.toString(), nCurType));
                if (!reachEnd) continue;
                ++pCur;
                continue;
            }
            atomSegment.add(new AtomNode(charArray[pCur], nCurType));
            ++pCur;
        }
        return atomSegment;
    }

    protected static List<AtomNode> simpleAtomSegment(char[] charArray, int start, int end) {
        LinkedList<AtomNode> atomNodeList = new LinkedList<AtomNode>();
        atomNodeList.add(new AtomNode(new String(charArray, start, end - start), 8));
        return atomNodeList;
    }

    protected static List<AtomNode> quickAtomSegment(char[] charArray, int start, int end) {
        LinkedList<AtomNode> atomNodeList = new LinkedList<AtomNode>();
        int offsetAtom = start;
        byte preType = CharType.get(charArray[offsetAtom]);
        while (++offsetAtom < end) {
            byte curType = CharType.get(charArray[offsetAtom]);
            if (curType != preType) {
                byte nextType;
                if (preType == 9 && "\uff0c,\uff0e.".indexOf(charArray[offsetAtom]) != -1 && offsetAtom + 1 < end && (nextType = CharType.get(charArray[offsetAtom + 1])) == 9) continue;
                atomNodeList.add(new AtomNode(new String(charArray, start, offsetAtom - start), (int)preType));
                start = offsetAtom;
            }
            preType = curType;
        }
        if (offsetAtom == end) {
            atomNodeList.add(new AtomNode(new String(charArray, start, offsetAtom - start), (int)preType));
        }
        return atomNodeList;
    }

    protected static List<Vertex> combineByCustomDictionary(List<Vertex> vertexList) {
        return Segment.combineByCustomDictionary(vertexList, CustomDictionary.dat);
    }

    protected static List<Vertex> combineByCustomDictionary(List<Vertex> vertexList, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        CoreDictionary.Attribute value;
        int end;
        int to;
        int i;
        assert (vertexList.size() >= 2) : "vertexList\u81f3\u5c11\u5305\u542b \u59cb##\u59cb \u548c \u672b##\u672b";
        Vertex[] wordNet = new Vertex[vertexList.size()];
        vertexList.toArray(wordNet);
        int length = wordNet.length - 1;
        for (i = 1; i < length; ++i) {
            int state = 1;
            if ((state = dat.transition(wordNet[i].realWord, state)) <= 0) continue;
            end = to = i + 1;
            value = dat.output(state);
            while (to < length && (state = dat.transition(wordNet[to].realWord, state)) >= 0) {
                CoreDictionary.Attribute output = dat.output(state);
                if (output != null) {
                    value = output;
                    end = to + 1;
                }
                ++to;
            }
            if (value == null) continue;
            Segment.combineWords(wordNet, i, end, value);
            i = end - 1;
        }
        if (CustomDictionary.trie != null) {
            for (i = 1; i < length; ++i) {
                BaseNode state;
                if (wordNet[i] == null || (state = CustomDictionary.trie.transition(wordNet[i].realWord.toCharArray(), 0)) == null) continue;
                end = to = i + 1;
                value = (CoreDictionary.Attribute)state.getValue();
                while (to < length) {
                    if (wordNet[to] != null) {
                        if ((state = state.transition(wordNet[to].realWord.toCharArray(), 0)) == null) break;
                        if (state.getValue() != null) {
                            value = (CoreDictionary.Attribute)state.getValue();
                            end = to + 1;
                        }
                    }
                    ++to;
                }
                if (value == null) continue;
                Segment.combineWords(wordNet, i, end, value);
                i = end - 1;
            }
        }
        vertexList.clear();
        for (Vertex vertex : wordNet) {
            if (vertex == null) continue;
            vertexList.add(vertex);
        }
        return vertexList;
    }

    protected static List<Vertex> combineByCustomDictionary(List<Vertex> vertexList, WordNet wordNetAll) {
        return Segment.combineByCustomDictionary(vertexList, CustomDictionary.dat, wordNetAll);
    }

    protected static List<Vertex> combineByCustomDictionary(List<Vertex> vertexList, DoubleArrayTrie<CoreDictionary.Attribute> dat, final WordNet wordNetAll) {
        List<Vertex> outputList = Segment.combineByCustomDictionary(vertexList, dat);
        int line = 0;
        for (final Vertex vertex : outputList) {
            final int parentLength = vertex.realWord.length();
            final int currentLine = line;
            if (parentLength >= 3) {
                CustomDictionary.parseText(vertex.realWord, new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

                    @Override
                    public void hit(int begin, int end, CoreDictionary.Attribute value) {
                        if (end - begin == parentLength) {
                            return;
                        }
                        wordNetAll.add(currentLine + begin, new Vertex(vertex.realWord.substring(begin, end), value));
                    }
                });
            }
            line += parentLength;
        }
        return outputList;
    }

    private static void combineWords(Vertex[] wordNet, int start, int end, CoreDictionary.Attribute value) {
        if (start + 1 == end) {
            wordNet[start].attribute = value;
        } else {
            StringBuilder sbTerm = new StringBuilder();
            for (int j = start; j < end; ++j) {
                if (wordNet[j] == null) continue;
                String realWord = wordNet[j].realWord;
                sbTerm.append(realWord);
                wordNet[j] = null;
            }
            wordNet[start] = new Vertex(sbTerm.toString(), value);
        }
    }

    protected static List<Term> convert(List<Vertex> vertexList, boolean offsetEnabled) {
        assert (vertexList != null);
        assert (vertexList.size() >= 2) : "\u8fd9\u6761\u8def\u5f84\u4e0d\u5e94\u5f53\u77ed\u4e8e2" + vertexList.toString();
        int length = vertexList.size() - 2;
        ArrayList<Term> resultList = new ArrayList<Term>(length);
        Iterator<Vertex> iterator = vertexList.iterator();
        iterator.next();
        if (offsetEnabled) {
            int offset = 0;
            for (int i = 0; i < length; ++i) {
                Vertex vertex = iterator.next();
                Term term = Segment.convert(vertex);
                term.offset = offset;
                offset += term.length();
                resultList.add(term);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Vertex vertex = iterator.next();
                Term term = Segment.convert(vertex);
                resultList.add(term);
            }
        }
        return resultList;
    }

    static Term convert(Vertex vertex) {
        return new Term(vertex.realWord, vertex.guessNature());
    }

    protected void mergeNumberQuantifier(List<Vertex> termList, WordNet wordNetAll, Config config) {
        if (termList.size() < 4) {
            return;
        }
        StringBuilder sbQuantifier = new StringBuilder();
        ListIterator<Vertex> iterator = termList.listIterator();
        iterator.next();
        int line = 1;
        while (iterator.hasNext()) {
            Vertex pre = iterator.next();
            if (pre.hasNature(Nature.m)) {
                sbQuantifier.append(pre.realWord);
                Vertex cur = null;
                while (iterator.hasNext() && (cur = iterator.next()).hasNature(Nature.m)) {
                    sbQuantifier.append(cur.realWord);
                    iterator.remove();
                    Segment.removeFromWordNet(cur, wordNetAll, line, sbQuantifier.length());
                }
                if (cur != null) {
                    if (cur.hasNature(Nature.q) || cur.hasNature(Nature.qv) || cur.hasNature(Nature.qt)) {
                        if (config.indexMode > 0) {
                            wordNetAll.add(line, new Vertex(sbQuantifier.toString(), new CoreDictionary.Attribute(Nature.m)));
                        }
                        sbQuantifier.append(cur.realWord);
                        iterator.remove();
                        Segment.removeFromWordNet(cur, wordNetAll, line, sbQuantifier.length());
                    } else {
                        line += cur.realWord.length();
                    }
                }
                if (sbQuantifier.length() != pre.realWord.length()) {
                    for (Vertex vertex : wordNetAll.get(line + pre.realWord.length())) {
                        vertex.from = null;
                    }
                    pre.realWord = sbQuantifier.toString();
                    pre.word = "\u672a##\u6570";
                    pre.attribute = new CoreDictionary.Attribute(Nature.mq);
                    pre.wordID = CoreDictionary.M_WORD_ID;
                    sbQuantifier.setLength(0);
                }
            }
            sbQuantifier.setLength(0);
            line += pre.realWord.length();
        }
    }

    private static void removeFromWordNet(Vertex cur, WordNet wordNetAll, int line, int length) {
        LinkedList<Vertex>[] vertexes = wordNetAll.getVertexes();
        for (Vertex vertex : vertexes[line + length]) {
            if (vertex.from != cur) continue;
            vertex.from = null;
        }
        ListIterator iterator = vertexes[line + length - cur.realWord.length()].listIterator();
        while (iterator.hasNext()) {
            Vertex vertex;
            vertex = (Vertex)iterator.next();
            if (vertex != cur) continue;
            iterator.remove();
        }
    }

    public List<Term> seg(String text) {
        char[] charArray = text.toCharArray();
        if (HanLP.Config.Normalization) {
            CharTable.normalization(charArray);
        }
        if (this.config.threadNumber > 1 && charArray.length > 10000) {
            List<String> sentenceList = SentencesUtil.toSentenceList(charArray);
            String[] sentenceArray = new String[sentenceList.size()];
            sentenceList.toArray(sentenceArray);
            List[] termListArray = new List[sentenceArray.length];
            int per = sentenceArray.length / this.config.threadNumber;
            WorkThread[] threadArray = new WorkThread[this.config.threadNumber];
            for (int i = 0; i < this.config.threadNumber - 1; ++i) {
                int from = i * per;
                threadArray[i] = new WorkThread(sentenceArray, termListArray, from, from + per);
                threadArray[i].start();
            }
            threadArray[this.config.threadNumber - 1] = new WorkThread(sentenceArray, termListArray, (this.config.threadNumber - 1) * per, sentenceArray.length);
            threadArray[this.config.threadNumber - 1].start();
            try {
                for (WorkThread thread : threadArray) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                Predefine.logger.severe("\u7ebf\u7a0b\u540c\u6b65\u5f02\u5e38\uff1a" + TextUtility.exceptionToString(e));
                return Collections.emptyList();
            }
            LinkedList<Term> termList = new LinkedList<Term>();
            if (this.config.offset || this.config.indexMode > 0) {
                int sentenceOffset = 0;
                for (int i = 0; i < sentenceArray.length; ++i) {
                    for (Term term : termListArray[i]) {
                        term.offset += sentenceOffset;
                        termList.add(term);
                    }
                    sentenceOffset += sentenceArray[i].length();
                }
            } else {
                for (List list : termListArray) {
                    termList.addAll(list);
                }
            }
            return termList;
        }
        return this.segSentence(charArray);
    }

    public List<Term> seg(char[] text) {
        assert (text != null);
        if (HanLP.Config.Normalization) {
            CharTable.normalization(text);
        }
        return this.segSentence(text);
    }

    public List<List<Term>> seg2sentence(String text) {
        return this.seg2sentence(text, true);
    }

    public List<List<Term>> seg2sentence(String text, boolean shortest) {
        LinkedList<List<Term>> resultList = new LinkedList<List<Term>>();
        for (String sentence : SentencesUtil.toSentenceList(text, shortest)) {
            resultList.add(this.segSentence(sentence.toCharArray()));
        }
        return resultList;
    }

    protected abstract List<Term> segSentence(char[] var1);

    public Segment enableIndexMode(boolean enable) {
        this.config.indexMode = enable ? 2 : 0;
        return this;
    }

    public Segment enableIndexMode(int minimalLength) {
        if (minimalLength < 1) {
            throw new IllegalArgumentException("\u6700\u5c0f\u957f\u5ea6\u5e94\u5f53\u5927\u4e8e\u7b49\u4e8e1");
        }
        this.config.indexMode = minimalLength;
        return this;
    }

    public Segment enablePartOfSpeechTagging(boolean enable) {
        this.config.speechTagging = enable;
        return this;
    }

    public Segment enableNameRecognize(boolean enable) {
        this.config.nameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enablePlaceRecognize(boolean enable) {
        this.config.placeRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableOrganizationRecognize(boolean enable) {
        this.config.organizationRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableCustomDictionary(boolean enable) {
        this.config.useCustomDictionary = enable;
        return this;
    }

    public Segment enableCustomDictionaryForcing(boolean enable) {
        if (enable) {
            this.enableCustomDictionary(true);
        }
        this.config.forceCustomDictionary = enable;
        return this;
    }

    public Segment enableTranslatedNameRecognize(boolean enable) {
        this.config.translatedNameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableJapaneseNameRecognize(boolean enable) {
        this.config.japaneseNameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableOffset(boolean enable) {
        this.config.offset = enable;
        return this;
    }

    public Segment enableNumberQuantifierRecognize(boolean enable) {
        this.config.numberQuantifierRecognize = enable;
        return this;
    }

    public Segment enableAllNamedEntityRecognize(boolean enable) {
        this.config.nameRecognize = enable;
        this.config.japaneseNameRecognize = enable;
        this.config.translatedNameRecognize = enable;
        this.config.placeRecognize = enable;
        this.config.organizationRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableMultithreading(boolean enable) {
        this.config.threadNumber = enable ? Runtime.getRuntime().availableProcessors() : 1;
        return this;
    }

    public Segment enableMultithreading(int threadNumber) {
        this.config.threadNumber = threadNumber;
        return this;
    }

    class WorkThread
    extends Thread {
        String[] sentenceArray;
        List<Term>[] termListArray;
        int from;
        int to;

        public WorkThread(String[] sentenceArray, List<Term>[] termListArray, int from, int to) {
            this.sentenceArray = sentenceArray;
            this.termListArray = termListArray;
            this.from = from;
            this.to = to;
        }

        @Override
        public void run() {
            for (int i = this.from; i < this.to; ++i) {
                this.termListArray[i] = Segment.this.segSentence(this.sentenceArray[i].toCharArray());
            }
        }
    }
}

