/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.tagset;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NERTagSet
extends TagSet {
    public final String O_TAG = "O";
    public final char O_TAG_CHAR = (char)79;
    public final String B_TAG_PREFIX = "B-";
    public final char B_TAG_CHAR = (char)66;
    public final String M_TAG_PREFIX = "M-";
    public final String E_TAG_PREFIX = "E-";
    public final String S_TAG = "S";
    public final char S_TAG_CHAR = (char)83;
    public final Set<String> nerLabels = new HashSet<String>();
    public final int O = this.add("O");

    public NERTagSet() {
        super(TaskType.NER);
    }

    public static String posOf(String tag) {
        int index = tag.indexOf(45);
        if (index == -1) {
            return tag;
        }
        return tag.substring(index + 1);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        super.load(byteArray);
        this.nerLabels.clear();
        for (Map.Entry<String, Integer> entry : this) {
            String tag = entry.getKey();
            int index = tag.indexOf(45);
            if (index == -1) continue;
            this.nerLabels.add(tag.substring(index + 1));
        }
        return true;
    }
}

