/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.instance;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.feature.MutableFeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.tagset.POSTagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.util.ArrayList;
import java.util.List;

public class POSInstance
extends Instance {
    public POSInstance(String[] termArray, String[] posArray, FeatureMap featureMap) {
        this(termArray, featureMap);
        POSTagSet tagSet = (POSTagSet)featureMap.tagSet;
        this.tagArray = new int[termArray.length];
        for (int i = 0; i < termArray.length; ++i) {
            this.tagArray[i] = tagSet.add(posArray[i]);
        }
    }

    public POSInstance(String[] termArray, FeatureMap featureMap) {
        this.initFeatureMatrix(termArray, featureMap);
    }

    protected int[] extractFeature(String[] words, FeatureMap featureMap, int position) {
        boolean create = featureMap instanceof MutableFeatureMap;
        ArrayList<Integer> featVec = new ArrayList<Integer>();
        String preWord = position >= 1 ? words[position - 1] : "_B_";
        String curWord = words[position];
        String nextWord = position <= words.length - 2 ? words[position + 1] : "_E_";
        StringBuilder sbFeature = new StringBuilder();
        sbFeature.append(preWord).append('1');
        POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        sbFeature.append(curWord).append('2');
        POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        sbFeature.append(nextWord).append('3');
        POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        int length = curWord.length();
        sbFeature.append(curWord.substring(0, 1)).append('4');
        POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        if (length > 1) {
            sbFeature.append(curWord.substring(0, 2)).append('4');
            POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        }
        if (length > 2) {
            sbFeature.append(curWord.substring(0, 3)).append('4');
            POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        }
        sbFeature.append(curWord.charAt(length - 1)).append('5');
        POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        if (length > 1) {
            sbFeature.append(curWord.substring(length - 2)).append('5');
            POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        }
        if (length > 2) {
            sbFeature.append(curWord.substring(length - 3)).append('5');
            POSInstance.addFeatureThenClear(sbFeature, featVec, featureMap, create);
        }
        return POSInstance.toFeatureArray(featVec);
    }

    private void initFeatureMatrix(String[] termArray, FeatureMap featureMap) {
        this.featureMatrix = new int[termArray.length][];
        for (int i = 0; i < this.featureMatrix.length; ++i) {
            this.featureMatrix[i] = this.extractFeature(termArray, featureMap, i);
        }
    }

    public static POSInstance create(String segmentedTaggedSentence, FeatureMap featureMap) {
        return POSInstance.create(Sentence.create(segmentedTaggedSentence), featureMap);
    }

    public static POSInstance create(Sentence sentence, FeatureMap featureMap) {
        if (sentence == null || featureMap == null) {
            return null;
        }
        List<Word> wordList = Utility.toSimpleWordList(sentence);
        String[] termArray = new String[wordList.size()];
        String[] posArray = new String[wordList.size()];
        int i = 0;
        for (Word word : wordList) {
            termArray[i] = word.getValue();
            posArray[i] = word.getLabel();
            ++i;
        }
        return new POSInstance(termArray, posArray, featureMap);
    }
}

