/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.model.perceptron.PerceptionNERecognizer;
import com.hankcs.hanlp.model.perceptron.PerceptronPOSTagger;
import com.hankcs.hanlp.model.perceptron.PerceptronSegmenter;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.PosTagUtility;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import com.hankcs.hanlp.seg.CharacterBasedGenerativeModelSegment;
import com.hankcs.hanlp.seg.common.Term;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PerceptronLexicalAnalyzer
extends CharacterBasedGenerativeModelSegment {
    private final PerceptronSegmenter segmenter;
    private final PerceptronPOSTagger posTagger;
    private final PerceptionNERecognizer neRecognizer;

    public PerceptronLexicalAnalyzer(LinearModel cwsModel, LinearModel posModel, LinearModel nerModel) {
        this.segmenter = new PerceptronSegmenter(cwsModel);
        if (posModel != null) {
            this.posTagger = new PerceptronPOSTagger(posModel);
            this.config.speechTagging = true;
        } else {
            this.posTagger = null;
        }
        if (nerModel != null) {
            this.neRecognizer = new PerceptionNERecognizer(nerModel);
            this.config.ner = true;
        } else {
            this.neRecognizer = null;
        }
    }

    public PerceptronLexicalAnalyzer(String cwsModelFile, String posModelFile, String nerModelFile) throws IOException {
        this(new LinearModel(cwsModelFile), posModelFile == null ? null : new LinearModel(posModelFile), nerModelFile == null ? null : new LinearModel(nerModelFile));
    }

    public PerceptronLexicalAnalyzer(String cwsModelFile, String posModelFile) throws IOException {
        this(new LinearModel(cwsModelFile), posModelFile == null ? null : new LinearModel(posModelFile), null);
    }

    public PerceptronLexicalAnalyzer(String cwsModelFile) throws IOException {
        this(new LinearModel(cwsModelFile), null, null);
    }

    public PerceptronLexicalAnalyzer(LinearModel CWSModel) {
        this(CWSModel, null, null);
    }

    public PerceptronLexicalAnalyzer() throws IOException {
        this(HanLP.Config.PerceptronCWSModelPath, HanLP.Config.PerceptronPOSModelPath, HanLP.Config.PerceptronNERModelPath);
    }

    public Sentence analyze(String sentence) {
        ArrayList<IWord> termList;
        block7: {
            String[] wordArray;
            block5: {
                String[] posArray;
                block6: {
                    if (sentence.isEmpty()) {
                        return new Sentence(Collections.<IWord>emptyList());
                    }
                    List<String> wordList = this.segmenter.segment(sentence);
                    wordArray = new String[wordList.size()];
                    wordList.toArray(wordArray);
                    termList = new ArrayList<IWord>(wordList.size());
                    if (this.posTagger == null) break block5;
                    posArray = this.posTagger.tag(wordList);
                    if (this.neRecognizer == null) break block6;
                    String[] nerArray = this.neRecognizer.recognize(wordArray, posArray);
                    AbstractList result = new LinkedList<Word>();
                    result.add(new Word(wordArray[0], posArray[0]));
                    String prePos = posArray[0];
                    for (int i = 1; i < nerArray.length; ++i) {
                        if (nerArray[i].charAt(0) == this.neRecognizer.tagSet.B_TAG_CHAR || nerArray[i].charAt(0) == this.neRecognizer.tagSet.S_TAG_CHAR || nerArray[i].charAt(0) == this.neRecognizer.tagSet.O_TAG_CHAR) {
                            termList.add(result.size() > 1 ? new CompoundWord(result, prePos) : (IWord)result.get(0));
                            result = new ArrayList();
                        }
                        result.add((Word)new Word(wordArray[i], posArray[i]));
                        prePos = nerArray[i].charAt(0) == this.neRecognizer.tagSet.O_TAG_CHAR || nerArray[i].charAt(0) == this.neRecognizer.tagSet.S_TAG_CHAR ? posArray[i] : NERTagSet.posOf(nerArray[i]);
                    }
                    if (result.size() == 0) break block7;
                    termList.add(result.size() > 1 ? new CompoundWord(result, prePos) : (IWord)result.get(0));
                    break block7;
                }
                for (int i = 0; i < wordArray.length; ++i) {
                    termList.add(new Word(wordArray[i], posArray[i]));
                }
                break block7;
            }
            for (String word : wordArray) {
                termList.add(new Word(word, null));
            }
        }
        return new Sentence(termList);
    }

    private void segment(String text, String normalized, List<String> output) {
        this.segmenter.segment(text, normalized, output);
    }

    public void segment(String text, List<String> output) {
        String normalized = Utility.normalize(text);
        this.segment(text, normalized, output);
    }

    public List<String> segment(String sentence) {
        return this.segmenter.segment(sentence);
    }

    public String[] partOfSpeechTag(List<String> wordList) {
        if (this.posTagger == null) {
            throw new IllegalStateException("\u672a\u63d0\u4f9b\u8bcd\u6027\u6807\u6ce8\u6a21\u578b");
        }
        return this.posTagger.tag(wordList);
    }

    public String[] namedEntityRecognize(String[] wordArray, String[] posArray) {
        if (this.neRecognizer == null) {
            throw new IllegalStateException("\u672a\u63d0\u4f9b\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b");
        }
        return this.neRecognizer.recognize(wordArray, posArray);
    }

    @Override
    protected List<Term> segSentence(char[] sentence) {
        ArrayList<Term> termList;
        block7: {
            block8: {
                if (sentence.length == 0) {
                    return Collections.emptyList();
                }
                CharTable.normalization(sentence);
                String normalized = new String(sentence);
                LinkedList<String> wordList = new LinkedList<String>();
                this.segment(new String(sentence), normalized, wordList);
                termList = new ArrayList<Term>(wordList.size());
                for (String word : wordList) {
                    termList.add(new Term(word, null));
                }
                if (!this.config.speechTagging) break block7;
                if (this.posTagger == null) break block8;
                String[] wordArray = new String[wordList.size()];
                wordList.toArray(wordArray);
                String[] posArray = this.posTagger.tag(wordArray);
                Iterator iterator = termList.iterator();
                for (String pos : posArray) {
                    ((Term)iterator.next()).nature = Nature.create(pos);
                }
                if (!this.config.ner || this.neRecognizer == null) break block7;
                termList = new ArrayList(termList.size());
                String[] nerArray = this.neRecognizer.recognize(wordArray, posArray);
                StringBuilder result = new StringBuilder();
                result.append(wordArray[0]);
                String prePos = posArray[0];
                for (int i = 1; i < nerArray.length; ++i) {
                    if (nerArray[i].charAt(0) == this.neRecognizer.tagSet.B_TAG_CHAR || nerArray[i].charAt(0) == this.neRecognizer.tagSet.S_TAG_CHAR || nerArray[i].charAt(0) == this.neRecognizer.tagSet.O_TAG_CHAR) {
                        termList.add(new Term(result.toString(), Nature.create(prePos)));
                        result.setLength(0);
                    }
                    result.append(wordArray[i]);
                    prePos = nerArray[i].charAt(0) == this.neRecognizer.tagSet.O_TAG_CHAR || nerArray[i].charAt(0) == this.neRecognizer.tagSet.S_TAG_CHAR ? posArray[i] : NERTagSet.posOf(nerArray[i]);
                }
                if (result.length() == 0) break block7;
                termList.add(new Term(result.toString(), Nature.create(posArray[posArray.length - 1])));
                break block7;
            }
            for (Term term : termList) {
                CoreDictionary.Attribute attribute = CoreDictionary.get(term.word);
                if (attribute != null) {
                    term.nature = Nature.create(PosTagUtility.convert(attribute.nature[0]));
                    continue;
                }
                term.nature = Nature.n;
            }
        }
        return termList;
    }

    @Override
    protected List<Term> roughSegSentence(char[] sentence) {
        return null;
    }

    public boolean learn(String segmentedTaggedSentence) {
        Sentence sentence = Sentence.create(segmentedTaggedSentence);
        if (!this.segmenter.learn(sentence)) {
            return false;
        }
        if (this.posTagger != null && !this.posTagger.learn(sentence)) {
            return false;
        }
        return this.neRecognizer == null || this.neRecognizer.learn(sentence);
    }

    public PerceptronSegmenter getSegmenter() {
        return this.segmenter;
    }

    public PerceptronPOSTagger getPOSTagger() {
        return this.posTagger;
    }

    public PerceptionNERecognizer getNERecognizer() {
        return this.neRecognizer;
    }
}

