/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.perceptron.CWSTrainer;
import com.hankcs.hanlp.model.perceptron.NERTrainer;
import com.hankcs.hanlp.model.perceptron.POSTrainer;
import com.hankcs.hanlp.model.perceptron.PerceptronLexicalAnalyzer;
import com.hankcs.hanlp.model.perceptron.PerceptronTrainer;
import com.hankcs.hanlp.model.perceptron.cli.Args;
import com.hankcs.hanlp.model.perceptron.cli.Argument;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        Option option = new Option();
        try {
            Args.parse(option, args);
            PerceptronTrainer trainer = null;
            switch (option.task) {
                case CWS: {
                    trainer = new CWSTrainer();
                    break;
                }
                case POS: {
                    trainer = new POSTrainer();
                    break;
                }
                case NER: {
                    trainer = new NERTrainer();
                }
            }
            if (option.train) {
                trainer.train(option.reference, option.development, option.model[0], option.compressRatio, option.iter, option.thread);
            } else if (option.evaluate) {
                double[] prf = trainer.evaluate(option.gold, option.model[0]);
                System.out.printf("Performance - P:%.2f R:%.2f F:%.2f\n", prf[0], prf[1], prf[2]);
            } else {
                String line;
                PerceptronLexicalAnalyzer analyzer;
                Object[] models = option.model;
                switch (models.length) {
                    case 1: {
                        analyzer = new PerceptronLexicalAnalyzer(models[0]);
                        break;
                    }
                    case 2: {
                        analyzer = new PerceptronLexicalAnalyzer(models[0], models[1]);
                        break;
                    }
                    case 3: {
                        analyzer = new PerceptronLexicalAnalyzer(models[0], models[1], (String)models[2]);
                        break;
                    }
                    default: {
                        System.err.printf("\u6700\u591a\u652f\u6301\u8f7d\u51653\u4e2a\u6a21\u578b\uff0c\u7136\u800c\u4f20\u5165\u4e86\u591a\u4e8e3\u4e2a: %s", Arrays.toString(models));
                        return;
                    }
                }
                PrintWriter printer = option.result == null ? new PrintWriter(System.out) : new PrintWriter(new File(option.result), "utf-8");
                Scanner scanner = option.input == null ? new Scanner(System.in) : new Scanner(new File(option.input), "utf-8");
                String lineSeparator = System.getProperty("line.separator");
                while (scanner.hasNext() && (line = scanner.nextLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    Sentence sentence = analyzer.analyze(line);
                    printer.write(sentence.toString());
                    printer.write(lineSeparator);
                    if (option.result != null) continue;
                    printer.flush();
                }
                printer.close();
                scanner.close();
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage(option);
        }
        catch (IOException e) {
            System.err.println("\u53d1\u751f\u4e86IO\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u8def\u5f84");
            e.printStackTrace();
        }
    }

    private static class Option {
        @Argument(description="\u4efb\u52a1\u7c7b\u578b:CWS|POS|NER")
        TaskType task = TaskType.CWS;
        @Argument(description="\u6267\u884c\u8bad\u7ec3\u4efb\u52a1")
        boolean train;
        @Argument(description="\u6267\u884c\u9884\u6d4b\u4efb\u52a1")
        boolean test;
        @Argument(description="\u6267\u884c\u8bc4\u4f30\u4efb\u52a1")
        boolean evaluate;
        @Argument(description="\u6a21\u578b\u6587\u4ef6\u8def\u5f84")
        String[] model = new String[]{HanLP.Config.PerceptronCWSModelPath, HanLP.Config.PerceptronPOSModelPath, HanLP.Config.PerceptronNERModelPath};
        @Argument(description="\u8f93\u5165\u6587\u672c\u8def\u5f84")
        String input;
        @Argument(description="\u7ed3\u679c\u4fdd\u5b58\u8def\u5f84")
        String result;
        @Argument(description="\u6807\u51c6\u5206\u8bcd\u8bed\u6599")
        String gold;
        @Argument(description="\u8bad\u7ec3\u96c6")
        String reference;
        @Argument(description="\u5f00\u53d1\u96c6")
        String development;
        @Argument(description="\u8fed\u4ee3\u6b21\u6570")
        Integer iter = 5;
        @Argument(description="\u6a21\u578b\u538b\u7f29\u6bd4\u7387")
        Double compressRatio = 0.0;
        @Argument(description="\u7ebf\u7a0b\u6570")
        int thread = Runtime.getRuntime().availableProcessors();

        private Option() {
        }
    }
}

