/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.utility.IOUtility;
import java.io.IOException;

public abstract class InstanceConsumer {
    protected abstract Instance createInstance(Sentence var1, FeatureMap var2);

    protected double[] evaluate(String developFile, String modelFile) throws IOException {
        return this.evaluate(developFile, new LinearModel(modelFile));
    }

    protected double[] evaluate(String developFile, final LinearModel model) throws IOException {
        final int[] stat = new int[2];
        IOUtility.loadInstance(developFile, new InstanceHandler(){

            @Override
            public boolean process(Sentence termArray) {
                Instance instance = InstanceConsumer.this.createInstance(termArray, model.featureMap);
                IOUtility.evaluate(instance, model, stat);
                return false;
            }
        });
        return new double[]{(double)stat[1] / (double)stat[0] * 100.0};
    }
}

