/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.model.perceptron.PerceptronSegmenter;
import com.hankcs.hanlp.model.perceptron.PerceptronTrainer;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.CWSInstance;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.CWSTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.io.IOException;
import java.util.List;

public class CWSTrainer
extends PerceptronTrainer {
    @Override
    protected TagSet createTagSet() {
        return new CWSTagSet();
    }

    @Override
    protected Instance createInstance(Sentence sentence, FeatureMap mutableFeatureMap) {
        List<Word> wordList = Utility.toSimpleWordList(sentence);
        String[] termArray = Utility.toWordArray(wordList);
        CWSInstance instance = new CWSInstance(termArray, mutableFeatureMap);
        return instance;
    }

    @Override
    public double[] evaluate(String developFile, LinearModel model) throws IOException {
        PerceptronSegmenter segmenter = new PerceptronSegmenter(model);
        double[] prf = Utility.prf(Utility.evaluateCWS(developFile, segmenter));
        return prf;
    }
}

