/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.Utils;
import com.hankcs.hanlp.mining.word2vec.VectorsReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public final class KMeansClustering {
    static final Charset ENCODING = Charset.forName("UTF-8");
    private final VectorsReader reader;
    private final int clcn;
    private final String outFile;

    public KMeansClustering(VectorsReader reader, int k, String outFile) {
        this.reader = reader;
        this.clcn = k;
        this.outFile = outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clustering() throws IOException {
        int vocabSize = this.reader.getNumWords();
        int layer1Size = this.reader.getSize();
        FileOutputStream os = null;
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        try {
            int i;
            os = new FileOutputStream(this.outFile);
            w = new OutputStreamWriter((OutputStream)os, ENCODING);
            pw = new PrintWriter(w);
            System.err.printf("now computing K-means clustering (K=%d)\n", this.clcn);
            int MAX_ITER = 10;
            int[] centcn = new int[this.clcn];
            int[] cl = new int[vocabSize];
            int centSize = this.clcn * layer1Size;
            double[] cent = new double[centSize];
            for (int i2 = 0; i2 < vocabSize; ++i2) {
                cl[i2] = i2 % this.clcn;
            }
            for (int it = 0; it < 10; ++it) {
                int k;
                int j;
                for (j = 0; j < centSize; ++j) {
                    cent[j] = 0.0;
                }
                for (j = 0; j < this.clcn; ++j) {
                    centcn[j] = 1;
                }
                for (k = 0; k < vocabSize; ++k) {
                    for (int l = 0; l < layer1Size; ++l) {
                        int n = layer1Size * cl[k] + l;
                        cent[n] = cent[n] + (double)this.reader.getMatrixElement(k, l);
                    }
                    int n = cl[k];
                    centcn[n] = centcn[n] + 1;
                }
                for (j = 0; j < this.clcn; ++j) {
                    int k2;
                    double closev = 0.0;
                    for (k2 = 0; k2 < layer1Size; ++k2) {
                        int n = layer1Size * j + k2;
                        cent[n] = cent[n] / (double)centcn[j];
                        closev += cent[layer1Size * j + k2] * cent[layer1Size * j + k2];
                    }
                    closev = Math.sqrt(closev);
                    for (k2 = 0; k2 < layer1Size; ++k2) {
                        int n = layer1Size * j + k2;
                        cent[n] = cent[n] / closev;
                    }
                }
                for (k = 0; k < vocabSize; ++k) {
                    double closev = -10.0;
                    int closeid = 0;
                    for (int l = 0; l < this.clcn; ++l) {
                        double x = 0.0;
                        for (int j2 = 0; j2 < layer1Size; ++j2) {
                            x += cent[layer1Size * l + j2] * (double)this.reader.getMatrixElement(k, j2);
                        }
                        if (!(x > closev)) continue;
                        closev = x;
                        closeid = l;
                    }
                    cl[k] = closeid;
                }
            }
            System.err.printf("now saving the result of K-means clustering to the file %s\n", this.outFile);
            List[] cluster = new List[this.clcn];
            for (i = 0; i < cluster.length; ++i) {
                cluster[i] = new LinkedList();
            }
            for (i = 0; i < vocabSize; ++i) {
                cluster[cl[i]].add(this.reader.getWord(i));
            }
            for (i = 0; i < cluster.length; ++i) {
                for (String word : cluster[i]) {
                    pw.printf("%s\t%d\n", word, i);
                }
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(pw);
            Utils.closeQuietly(w);
            Utils.closeQuietly(os);
            throw throwable;
        }
        Utils.closeQuietly(pw);
        Utils.closeQuietly(w);
        Utils.closeQuietly(os);
    }
}

