/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.document.sentence;

import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.document.sentence.word.WordFactory;
import com.hankcs.hanlp.utility.Predefine;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sentence
implements Serializable,
Iterable<IWord> {
    public List<IWord> wordList;

    public Sentence(List<IWord> wordList) {
        this.wordList = wordList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size() * 4);
        int i = 1;
        for (IWord word : this.wordList) {
            sb.append(word);
            if (i != this.wordList.size()) {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public static Sentence create(String param) {
        Pattern pattern = Pattern.compile("(\\[(([^\\s]+/[0-9a-zA-Z]+)\\s+)+?([^\\s]+/[0-9a-zA-Z]+)]/?[0-9a-zA-Z]+)|([^\\s]+/[0-9a-zA-Z]+)");
        Matcher matcher = pattern.matcher(param);
        LinkedList<IWord> wordList = new LinkedList<IWord>();
        while (matcher.find()) {
            String single = matcher.group();
            IWord word = WordFactory.create(single);
            if (word == null) {
                Predefine.logger.warning("\u5728\u7528" + single + "\u6784\u9020\u5355\u8bcd\u65f6\u5931\u8d25");
                return null;
            }
            wordList.add(word);
        }
        if (wordList.isEmpty()) {
            for (String w : param.split("\\s+")) {
                wordList.add(new Word(w, null));
            }
        }
        return new Sentence(wordList);
    }

    public int size() {
        return this.wordList.size();
    }

    public int length() {
        int length = 0;
        for (IWord word : this) {
            length += word.getValue().length();
        }
        return length;
    }

    public String text() {
        StringBuilder sb = new StringBuilder(this.size() * 3);
        for (IWord word : this) {
            sb.append(word.getValue());
        }
        return sb.toString();
    }

    @Override
    public Iterator<IWord> iterator() {
        return this.wordList.iterator();
    }
}

