/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.datrie;

import com.hankcs.hanlp.collection.trie.datrie.CharacterMapping;
import com.hankcs.hanlp.collection.trie.datrie.IntArrayList;
import com.hankcs.hanlp.collection.trie.datrie.Utf8CharacterMapping;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.utility.Predefine;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MutableDoubleArrayTrieInteger
implements Serializable,
Iterable<KeyValuePair>,
ICacheAble {
    private static final long serialVersionUID = 5586394930559218802L;
    private static final int LEAF_BIT = 0x40000000;
    private static final int[] EMPTY_WALK_STATE = new int[]{-1, -1};
    CharacterMapping charMap;
    private static final char UNUSED_CHAR = '\u0000';
    private static final int UNUSED_CHAR_VALUE = 0;
    private IntArrayList check;
    private IntArrayList base;
    private int size;

    public MutableDoubleArrayTrieInteger(Map<String, Integer> stringIntegerMap) {
        this(stringIntegerMap.entrySet());
    }

    public MutableDoubleArrayTrieInteger(Set<Map.Entry<String, Integer>> entrySet) {
        this();
        for (Map.Entry<String, Integer> entry : entrySet) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void setExponentialExpanding(boolean exponentialExpanding) {
        this.check.setExponentialExpanding(exponentialExpanding);
        this.base.setExponentialExpanding(exponentialExpanding);
    }

    public void setExponentialExpandFactor(double exponentialExpandFactor) {
        this.check.setExponentialExpandFactor(exponentialExpandFactor);
        this.base.setExponentialExpandFactor(exponentialExpandFactor);
    }

    public void setLinearExpandFactor(int linearExpandFactor) {
        this.check.setLinearExpandFactor(linearExpandFactor);
        this.base.setLinearExpandFactor(linearExpandFactor);
    }

    public MutableDoubleArrayTrieInteger() {
        this(new Utf8CharacterMapping());
    }

    public MutableDoubleArrayTrieInteger(CharacterMapping charMap) {
        this.charMap = charMap;
        this.clear();
    }

    public void clear() {
        this.base = new IntArrayList(this.charMap.getInitSize());
        this.check = new IntArrayList(this.charMap.getInitSize());
        this.base.append(0);
        this.check.append(0);
        this.base.append(1);
        this.check.append(0);
        this.expandArray(this.charMap.getInitSize());
    }

    public int getCheckArraySize() {
        return this.check.size();
    }

    public int getFreeSize() {
        int count = 0;
        int chk = this.check.get(0);
        while (chk != 0) {
            ++count;
            chk = this.check.get(-chk);
        }
        return count;
    }

    private boolean isLeafValue(int value) {
        return value > 0 && (value & 0x40000000) != 0;
    }

    private int setLeafValue(int value) {
        return value | 0x40000000;
    }

    private int getLeafValue(int value) {
        return value ^ 0x40000000;
    }

    public int getBaseArraySize() {
        return this.base.size();
    }

    private int getBase(int index) {
        return this.base.get(index);
    }

    private int getCheck(int index) {
        return this.check.get(index);
    }

    private void setBase(int index, int value) {
        this.base.set(index, value);
    }

    private void setCheck(int index, int value) {
        this.check.set(index, value);
    }

    protected boolean isEmpty(int index) {
        return this.getCheck(index) <= 0;
    }

    private int getNextFreeBase(int nextChar) {
        int index = -this.getCheck(0);
        while (index != 0) {
            if (index > nextChar + 1) {
                return index - nextChar;
            }
            index = -this.getCheck(index);
        }
        int oldSize = this.getBaseArraySize();
        this.expandArray(oldSize + this.base.getLinearExpandFactor());
        return oldSize;
    }

    private void addFreeLink(int index) {
        this.check.set(index, this.check.get(-this.base.get(0)));
        this.check.set(-this.base.get(0), -index);
        this.base.set(index, this.base.get(0));
        this.base.set(0, -index);
    }

    private void deleteFreeLink(int index) {
        this.base.set(-this.check.get(index), this.base.get(index));
        this.check.set(-this.base.get(index), this.check.get(index));
    }

    private void expandArray(int maxSize) {
        int curSize = this.getBaseArraySize();
        if (curSize > maxSize) {
            return;
        }
        if (maxSize >= 0x40000000) {
            throw new RuntimeException("Double Array Trie size exceeds absolute threshold");
        }
        for (int i = curSize; i <= maxSize; ++i) {
            this.base.append(0);
            this.check.append(0);
            this.addFreeLink(i);
        }
    }

    public boolean insert(String key, int value, boolean overwrite) {
        if (null == key || key.length() == 0 || key.indexOf(0) != -1) {
            return false;
        }
        if (value < 0 || (value & 0x40000000) != 0) {
            return false;
        }
        value = this.setLeafValue(value);
        int[] ids = this.charMap.toIdList(key + '\u0000');
        int fromState = 1;
        int toState = 1;
        int index = 0;
        while (index < ids.length) {
            int c = ids[index];
            toState = this.getBase(fromState) + c;
            this.expandArray(toState);
            if (this.isEmpty(toState)) {
                this.deleteFreeLink(toState);
                this.setCheck(toState, fromState);
                if (index == ids.length - 1) {
                    ++this.size;
                    this.setBase(toState, value);
                } else {
                    int nextChar = ids[index + 1];
                    this.setBase(toState, this.getNextFreeBase(nextChar));
                }
            } else if (this.getCheck(toState) != fromState) {
                this.solveConflict(fromState, c);
                continue;
            }
            fromState = toState;
            ++index;
        }
        if (overwrite) {
            this.setBase(toState, value);
        }
        return true;
    }

    private int searchFreeBase(SortedSet<Integer> children) {
        int minChild = children.first();
        int maxChild = children.last();
        int current = 0;
        while (this.getCheck(current) != 0) {
            if (current > minChild + 1) {
                int base = current - minChild;
                boolean ok = true;
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    int to = base + (Integer)it.next();
                    if (to >= this.getBaseArraySize()) {
                        ok = false;
                        break;
                    }
                    if (this.isEmpty(to)) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    return base;
                }
            }
            current = -this.getCheck(current);
        }
        int oldSize = this.getBaseArraySize();
        this.expandArray(oldSize + maxChild);
        return oldSize;
    }

    private void solveConflict(int parent, int newChild) {
        int next;
        TreeSet<Integer> children = new TreeSet<Integer>();
        children.add(newChild);
        int charsetSize = this.charMap.getCharsetSize();
        for (int c = 0; c < charsetSize && (next = this.getBase(parent) + c) < this.getBaseArraySize(); ++c) {
            if (this.getCheck(next) != parent) continue;
            children.add(c);
        }
        int newBase = this.searchFreeBase(children);
        children.remove(newChild);
        for (Integer c : children) {
            int child = newBase + c;
            this.deleteFreeLink(child);
            this.setCheck(child, parent);
            int childBase = this.getBase(this.getBase(parent) + c);
            this.setBase(child, childBase);
            if (!this.isLeafValue(childBase)) {
                int to;
                for (int d = 0; d < charsetSize && (to = childBase + d) < this.getBaseArraySize(); ++d) {
                    if (this.getCheck(to) != this.getBase(parent) + c) continue;
                    this.setCheck(to, child);
                }
            }
            this.addFreeLink(this.getBase(parent) + c);
        }
        this.setBase(parent, newBase);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean insert(String key, int value) {
        return this.insert(key, value, true);
    }

    public boolean add(String key, int value) {
        return this.insert(key, value, false);
    }

    public boolean add(String key) {
        return this.add(key, this.size);
    }

    public List<String> prefixMatch(String prefix) {
        int curState = 1;
        IntArrayList bytes = new IntArrayList(prefix.length() * 4);
        for (int i = 0; i < prefix.length(); ++i) {
            char codePoint = prefix.charAt(i);
            if (curState < 1) {
                return Collections.emptyList();
            }
            if (curState != 1 && this.isEmpty(curState)) {
                return Collections.emptyList();
            }
            int[] ids = this.charMap.toIdList(codePoint);
            if (ids.length == 0) {
                return Collections.emptyList();
            }
            for (int j = 0; j < ids.length; ++j) {
                int c = ids[j];
                if (this.getBase(curState) + c >= this.getBaseArraySize() || this.getCheck(this.getBase(curState) + c) != curState) {
                    return Collections.emptyList();
                }
                bytes.append(c);
                curState = this.getBase(curState) + c;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        this.recursiveAddSubTree(curState, result, bytes);
        return result;
    }

    private void recursiveAddSubTree(int curState, List<String> result, IntArrayList bytes) {
        if (this.getCheck(this.getBase(curState) + 0) == curState) {
            byte[] array = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                array[i] = (byte)bytes.get(i);
            }
            result.add(new String(array, Utf8CharacterMapping.UTF_8));
        }
        int base = this.getBase(curState);
        for (int c = 0; c < this.charMap.getCharsetSize(); ++c) {
            if (c == 0) continue;
            int check = this.getCheck(base + c);
            if (base + c >= this.getBaseArraySize() || check != curState) continue;
            bytes.append(c);
            this.recursiveAddSubTree(base + c, result, bytes);
            bytes.removeLast();
        }
    }

    public int[] findLongest(CharSequence query, int start) {
        int[] res;
        if (query == null || start >= query.length()) {
            return new int[]{0, -1};
        }
        int state = 1;
        int maxLength = 0;
        int lastVal = -1;
        for (int i = start; i < query.length() && (res = this.transferValues(state, query.charAt(i)))[0] != -1; ++i) {
            state = res[0];
            if (res[1] == -1) continue;
            maxLength = i - start + 1;
            lastVal = res[1];
        }
        return new int[]{maxLength, lastVal};
    }

    public int[] findWithSupplementary(String query, int start) {
        if (query == null || start >= query.length()) {
            return new int[]{0, -1};
        }
        int curState = 1;
        int maxLength = 0;
        int lastVal = -1;
        int charCount = 1;
        for (int i = start; i < query.length(); i += charCount) {
            int codePoint = query.codePointAt(i);
            charCount = Character.charCount(codePoint);
            int[] res = this.transferValues(curState, codePoint);
            if (res[0] == -1) break;
            curState = res[0];
            if (res[1] == -1) continue;
            maxLength = i - start + 1;
            lastVal = res[1];
        }
        return new int[]{maxLength, lastVal};
    }

    public List<int[]> findAllWithSupplementary(String query, int start) {
        ArrayList<int[]> ret = new ArrayList<int[]>(5);
        if (query == null || start >= query.length()) {
            return ret;
        }
        int curState = 1;
        int charCount = 1;
        for (int i = start; i < query.length(); i += charCount) {
            int codePoint = query.codePointAt(i);
            charCount = Character.charCount(codePoint);
            int[] res = this.transferValues(curState, codePoint);
            if (res[0] == -1) break;
            curState = res[0];
            if (res[1] == -1) continue;
            ret.add(new int[]{i - start + 1, res[1]});
        }
        return ret;
    }

    public List<int[]> commonPrefixSearch(String query, int start) {
        int[] res;
        ArrayList<int[]> ret = new ArrayList<int[]>(5);
        if (query == null || start >= query.length()) {
            return ret;
        }
        int curState = 1;
        for (int i = start; i < query.length() && (res = this.transferValues(curState, query.charAt(i)))[0] != -1; ++i) {
            curState = res[0];
            if (res[1] == -1) continue;
            ret.add(new int[]{i - start + 1, res[1]});
        }
        return ret;
    }

    public int[] transferValues(int state, int codePoint) {
        if (state < 1) {
            return EMPTY_WALK_STATE;
        }
        if (state != 1 && this.isEmpty(state)) {
            return EMPTY_WALK_STATE;
        }
        int[] ids = this.charMap.toIdList(codePoint);
        if (ids.length == 0) {
            return EMPTY_WALK_STATE;
        }
        for (int i = 0; i < ids.length; ++i) {
            int c = ids[i];
            if (this.getBase(state) + c >= this.getBaseArraySize() || this.getCheck(this.getBase(state) + c) != state) {
                return EMPTY_WALK_STATE;
            }
            state = this.getBase(state) + c;
        }
        if (this.getCheck(this.getBase(state) + 0) == state) {
            int value = this.getLeafValue(this.getBase(this.getBase(state) + 0));
            return new int[]{state, value};
        }
        return new int[]{state, -1};
    }

    public int transfer(int state, int codePoint) {
        if (state < 1) {
            return -1;
        }
        if (state != 1 && this.isEmpty(state)) {
            return -1;
        }
        int[] ids = this.charMap.toIdList(codePoint);
        if (ids.length == 0) {
            return -1;
        }
        return this.transfer(state, ids);
    }

    private int transfer(int state, int[] ids) {
        for (int c : ids) {
            if (this.getBase(state) + c >= this.getBaseArraySize() || this.getCheck(this.getBase(state) + c) != state) {
                return -1;
            }
            state = this.getBase(state) + c;
        }
        return state;
    }

    public int stateValue(int state) {
        int leaf = this.getBase(state) + 0;
        if (this.getCheck(leaf) == state) {
            return this.getLeafValue(this.getBase(leaf));
        }
        return -1;
    }

    public void loseWeight() {
        this.base.loseWeight();
        this.check.loseWeight();
    }

    public void decreaseValues(int from) {
        for (int state = 1; state < this.getBaseArraySize(); ++state) {
            int value;
            int leaf = this.getBase(state) + 0;
            if (1 >= leaf || leaf >= this.getCheckArraySize() || this.getCheck(leaf) != state || (value = this.getLeafValue(this.getBase(leaf))) < from) continue;
            this.setBase(leaf, this.setLeafValue(--value));
        }
    }

    public int get(String key, int start) {
        assert (key != null);
        assert (0 <= start && start <= key.length());
        int state = 1;
        int[] ids = this.charMap.toIdList(key.substring(start));
        if ((state = this.transfer(state, ids)) < 0) {
            return -1;
        }
        return this.stateValue(state);
    }

    public int get(String key) {
        return this.get(key, 0);
    }

    public boolean set(String key, int value) {
        return this.insert(key, value, true);
    }

    public boolean put(String key, int value) {
        return this.insert(key, value, true);
    }

    public int remove(String key) {
        return this.delete(key);
    }

    public int delete(String key) {
        int i;
        if (key == null) {
            return -1;
        }
        int curState = 1;
        int[] ids = this.charMap.toIdList(key);
        int[] path = new int[ids.length + 1];
        for (i = 0; i < ids.length; ++i) {
            int c = ids[i];
            if (this.getBase(curState) + c >= this.getBaseArraySize() || this.getCheck(this.getBase(curState) + c) != curState) break;
            path[i] = curState = this.getBase(curState) + c;
        }
        int ret = -1;
        if (i == ids.length && this.getCheck(this.getBase(curState) + 0) == curState) {
            --this.size;
            ret = this.getLeafValue(this.getBase(this.getBase(curState) + 0));
            path[path.length - 1] = this.getBase(curState) + 0;
            for (int j = path.length - 1; j >= 0; --j) {
                boolean isLeaf = true;
                int state = path[j];
                for (int k = 0; k < this.charMap.getCharsetSize() && !this.isLeafValue(this.getBase(state)); ++k) {
                    if (this.getBase(state) + k >= this.getBaseArraySize() || this.getCheck(this.getBase(state) + k) != state) continue;
                    isLeaf = false;
                    break;
                }
                if (!isLeaf) break;
                this.addFreeLink(state);
            }
        }
        return ret;
    }

    public int getEmptySize() {
        int size = 0;
        for (int i = 0; i < this.getBaseArraySize(); ++i) {
            if (!this.isEmpty(i)) continue;
            ++size;
        }
        return size;
    }

    public int getMaximumValue() {
        return 0x3FFFFFFF;
    }

    public Set<Map.Entry<String, Integer>> entrySet() {
        return new Set<Map.Entry<String, Integer>>(){

            @Override
            public int size() {
                return MutableDoubleArrayTrieInteger.this.size;
            }

            @Override
            public boolean isEmpty() {
                return MutableDoubleArrayTrieInteger.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<String, Integer>> iterator() {
                return new Iterator<Map.Entry<String, Integer>>(){
                    KeyValuePair iterator;
                    {
                        this.iterator = MutableDoubleArrayTrieInteger.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Map.Entry<String, Integer> next() {
                        this.iterator.next();
                        return new AbstractMap.SimpleEntry<String, Integer>(this.iterator.key, this.iterator.value);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Map.Entry<String, Integer> stringIntegerEntry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<String, Integer>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public KeyValuePair iterator() {
        return new KeyValuePair();
    }

    public boolean containsKey(String key) {
        return this.get(key) != -1;
    }

    public Set<String> keySet() {
        return new Set<String>(){

            @Override
            public int size() {
                return MutableDoubleArrayTrieInteger.this.size;
            }

            @Override
            public boolean isEmpty() {
                return MutableDoubleArrayTrieInteger.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return MutableDoubleArrayTrieInteger.this.containsKey((String)o);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    KeyValuePair iterator;
                    {
                        this.iterator = MutableDoubleArrayTrieInteger.this.iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return this.iterator.next().key;
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        if (!(this.charMap instanceof Utf8CharacterMapping)) {
            Predefine.logger.warning("\u5c06\u6765\u9700\u8981\u5728\u6784\u9020\u7684\u65f6\u5019\u4f20\u5165 " + this.charMap.getClass());
        }
        out.writeInt(this.size);
        this.base.save(out);
        this.check.save(out);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.size = byteArray.nextInt();
        if (!this.base.load(byteArray)) {
            return false;
        }
        return this.check.load(byteArray);
    }

    public class KeyValuePair
    implements Iterator<KeyValuePair> {
        private IntArrayList path = new IntArrayList(20);
        private int index;
        private int value = -1;
        private String key = null;
        private int currentBase;

        public KeyValuePair() {
            this.path.append(1);
            int from = 1;
            int b = MutableDoubleArrayTrieInteger.this.base.get(from);
            if (MutableDoubleArrayTrieInteger.this.size > 0) {
                block0: while (true) {
                    int i = 0;
                    while (true) {
                        if (i >= MutableDoubleArrayTrieInteger.this.charMap.getCharsetSize()) continue block0;
                        int c = MutableDoubleArrayTrieInteger.this.check.get(b + i);
                        if (c == from) {
                            this.path.append(i);
                            from = b + i;
                            this.path.append(from);
                            b = MutableDoubleArrayTrieInteger.this.base.get(from);
                            if (MutableDoubleArrayTrieInteger.this.getCheck(b + 0) == from) {
                                this.value = MutableDoubleArrayTrieInteger.this.getLeafValue(MutableDoubleArrayTrieInteger.this.getBase(b + 0));
                                int[] ids = new int[this.path.size() / 2];
                                int k = 0;
                                for (int j = 1; j < this.path.size(); j += 2) {
                                    ids[k] = this.path.get(j);
                                    ++k;
                                }
                                this.key = MutableDoubleArrayTrieInteger.this.charMap.toString(ids);
                                this.path.append(0);
                                this.currentBase = b;
                                return;
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }

        public String key() {
            return this.key;
        }

        public int value() {
            return this.value;
        }

        public int setValue(int v) {
            int value = MutableDoubleArrayTrieInteger.this.getLeafValue(v);
            MutableDoubleArrayTrieInteger.this.setBase(this.currentBase + 0, value);
            this.value = v;
            return v;
        }

        @Override
        public boolean hasNext() {
            return this.index < MutableDoubleArrayTrieInteger.this.size;
        }

        @Override
        public KeyValuePair next() {
            if (this.index >= MutableDoubleArrayTrieInteger.this.size) {
                throw new NoSuchElementException();
            }
            if (this.index != 0) {
                while (this.path.size() > 0) {
                    int charPoint = this.path.pop();
                    int base = this.path.getLast();
                    int n = this.getNext(base, charPoint);
                    if (n != -1) break;
                    this.path.removeLast();
                }
            }
            ++this.index;
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int getNext(int parent, int charPoint) {
            int startChar = charPoint + 1;
            int baseParent = MutableDoubleArrayTrieInteger.this.getBase(parent);
            int from = parent;
            for (int i = startChar; i < MutableDoubleArrayTrieInteger.this.charMap.getCharsetSize(); ++i) {
                int to = baseParent + i;
                if (MutableDoubleArrayTrieInteger.this.check.size() <= to || MutableDoubleArrayTrieInteger.this.check.get(to) != from) continue;
                this.path.append(i);
                from = to;
                this.path.append(from);
                baseParent = MutableDoubleArrayTrieInteger.this.base.get(from);
                if (MutableDoubleArrayTrieInteger.this.getCheck(baseParent + 0) == from) {
                    this.value = MutableDoubleArrayTrieInteger.this.getLeafValue(MutableDoubleArrayTrieInteger.this.getBase(baseParent + 0));
                    int[] ids = new int[this.path.size() / 2];
                    int k = 0;
                    for (int j = 1; j < this.path.size(); j += 2) {
                        ids[k] = this.path.get(j);
                        ++k;
                    }
                    this.key = MutableDoubleArrayTrieInteger.this.charMap.toString(ids);
                    this.path.append(0);
                    this.currentBase = baseParent;
                    return from;
                }
                return this.getNext(from, 0);
            }
            return -1;
        }

        public String toString() {
            return this.key + '=' + this.value;
        }
    }
}

