/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Dijkstra;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.recognition.nr.JapanesePersonRecognition;
import com.hankcs.hanlp.recognition.nr.PersonRecognition;
import com.hankcs.hanlp.recognition.nr.TranslatedPersonRecognition;
import com.hankcs.hanlp.recognition.ns.PlaceRecognition;
import com.hankcs.hanlp.recognition.nt.OrganizationRecognition;
import com.hankcs.hanlp.seg.Dijkstra.Path.State;
import com.hankcs.hanlp.seg.WordBasedGenerativeModelSegment;
import com.hankcs.hanlp.seg.common.EdgeFrom;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public class DijkstraSegment
extends WordBasedGenerativeModelSegment {
    @Override
    public List<Term> segSentence(char[] sentence) {
        WordNet wordNetOptimum = new WordNet(sentence);
        WordNet wordNetAll = new WordNet(wordNetOptimum.charArray);
        this.GenerateWordNet(wordNetAll);
        Graph graph = DijkstraSegment.GenerateBiGraph(wordNetAll);
        if (HanLP.Config.DEBUG) {
            System.out.printf("\u7c97\u5206\u8bcd\u56fe\uff1a%s\n", graph.printByTo());
        }
        List<Vertex> vertexList = DijkstraSegment.dijkstra(graph);
        if (this.config.useCustomDictionary) {
            if (this.config.indexMode > 0) {
                DijkstraSegment.combineByCustomDictionary(vertexList, wordNetAll);
            } else {
                DijkstraSegment.combineByCustomDictionary(vertexList);
            }
        }
        if (HanLP.Config.DEBUG) {
            System.out.println("\u7c97\u5206\u7ed3\u679c" + DijkstraSegment.convert(vertexList, false));
        }
        if (this.config.numberQuantifierRecognize) {
            this.mergeNumberQuantifier(vertexList, wordNetAll, this.config);
        }
        if (this.config.ner) {
            wordNetOptimum.addAll(vertexList);
            int preSize = wordNetOptimum.size();
            if (this.config.nameRecognize) {
                PersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.translatedNameRecognize) {
                TranslatedPersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.japaneseNameRecognize) {
                JapanesePersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.placeRecognize) {
                PlaceRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.organizationRecognize) {
                graph = DijkstraSegment.GenerateBiGraph(wordNetOptimum);
                vertexList = DijkstraSegment.dijkstra(graph);
                wordNetOptimum.clear();
                wordNetOptimum.addAll(vertexList);
                preSize = wordNetOptimum.size();
                OrganizationRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (wordNetOptimum.size() != preSize) {
                graph = DijkstraSegment.GenerateBiGraph(wordNetOptimum);
                vertexList = DijkstraSegment.dijkstra(graph);
                if (HanLP.Config.DEBUG) {
                    System.out.printf("\u7ec6\u5206\u8bcd\u7f51\uff1a\n%s\n", wordNetOptimum);
                    System.out.printf("\u7ec6\u5206\u8bcd\u56fe\uff1a%s\n", graph.printByTo());
                }
            }
        }
        if (this.config.indexMode > 0) {
            return this.decorateResultForIndexMode(vertexList, wordNetAll);
        }
        if (this.config.speechTagging) {
            DijkstraSegment.speechTagging(vertexList);
        }
        return DijkstraSegment.convert(vertexList, this.config.offset);
    }

    private static List<Vertex> dijkstra(Graph graph) {
        LinkedList<Vertex> resultList = new LinkedList<Vertex>();
        Vertex[] vertexes = graph.getVertexes();
        List<EdgeFrom>[] edgesTo = graph.getEdgesTo();
        double[] d = new double[vertexes.length];
        Arrays.fill(d, Double.MAX_VALUE);
        d[d.length - 1] = 0.0;
        int[] path = new int[vertexes.length];
        Arrays.fill(path, -1);
        PriorityQueue<State> que = new PriorityQueue<State>();
        que.add(new State(0.0, vertexes.length - 1));
        while (!que.isEmpty()) {
            State p = (State)que.poll();
            if (d[p.vertex] < p.cost) continue;
            for (EdgeFrom edgeFrom : edgesTo[p.vertex]) {
                if (!(d[edgeFrom.from] > d[p.vertex] + edgeFrom.weight)) continue;
                d[edgeFrom.from] = d[p.vertex] + edgeFrom.weight;
                que.add(new State(d[edgeFrom.from], edgeFrom.from));
                path[edgeFrom.from] = p.vertex;
            }
        }
        int t = 0;
        while (t != -1) {
            resultList.add(vertexes[t]);
            t = path[t];
        }
        return resultList;
    }
}

