/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.corpus.io.ByteArrayStream;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ByteArrayFileStream
extends ByteArrayStream {
    private FileChannel fileChannel;

    public ByteArrayFileStream(byte[] bytes, int bufferSize, FileChannel fileChannel) {
        super(bytes, bufferSize);
        this.fileChannel = fileChannel;
    }

    public static ByteArrayFileStream createByteArrayFileStream(String path) {
        try {
            FileInputStream fileInputStream = new FileInputStream(path);
            return ByteArrayFileStream.createByteArrayFileStream(fileInputStream);
        }
        catch (Exception e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
            return null;
        }
    }

    public static ByteArrayFileStream createByteArrayFileStream(FileInputStream fileInputStream) throws IOException {
        long size;
        int bufferSize;
        ByteBuffer byteBuffer;
        FileChannel channel = fileInputStream.getChannel();
        if ((long)channel.read(byteBuffer = ByteBuffer.allocate(bufferSize = (int)Math.min(0x100000L, size = channel.size()))) == size) {
            channel.close();
            channel = null;
        }
        byteBuffer.flip();
        byte[] bytes = byteBuffer.array();
        return new ByteArrayFileStream(bytes, bufferSize, channel);
    }

    @Override
    public boolean hasMore() {
        return this.offset < this.bufferSize || this.fileChannel != null;
    }

    @Override
    protected void ensureAvailableBytes(int size) {
        if (this.offset + size > this.bufferSize) {
            try {
                int availableBytes = (int)(this.fileChannel.size() - this.fileChannel.position());
                ByteBuffer byteBuffer = ByteBuffer.allocate(Math.min(availableBytes, this.offset));
                int readBytes = this.fileChannel.read(byteBuffer);
                if (readBytes == availableBytes) {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                assert (readBytes > 0) : "\u5df2\u5230\u8fbe\u6587\u4ef6\u5c3e\u90e8\uff01";
                byteBuffer.flip();
                byte[] bytes = byteBuffer.array();
                System.arraycopy(this.bytes, this.offset, this.bytes, this.offset - readBytes, this.bufferSize - this.offset);
                System.arraycopy(bytes, 0, this.bytes, this.bufferSize - readBytes, readBytes);
                this.offset -= readBytes;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
        }
    }
}

