/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model;

import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.model.crf.CRFModel;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.Table;
import java.util.LinkedList;

public final class CRFSegmentModel
extends CRFModel {
    private int idM;
    private int idE;
    private int idS;

    private CRFSegmentModel() {
    }

    public CRFSegmentModel(ITrie<FeatureFunction> featureFunctionTrie) {
        super(featureFunctionTrie);
    }

    private void initTagSet() {
        this.idM = this.getTagId("M");
        this.idE = this.getTagId("E");
        this.idS = this.getTagId("S");
    }

    @Override
    public boolean load(ByteArray byteArray) {
        boolean result = super.load(byteArray);
        if (result) {
            this.initTagSet();
        }
        return result;
    }

    @Override
    protected void onLoadTxtFinished() {
        super.onLoadTxtFinished();
        this.initTagSet();
    }

    @Override
    public void tag(Table table) {
        int size = table.size();
        if (size == 1) {
            table.setLast(0, "S");
            return;
        }
        double[][] net = new double[size][4];
        for (int i = 0; i < size; ++i) {
            LinkedList<double[]> scoreList = this.computeScoreList(table, i);
            for (int tag = 0; tag < 4; ++tag) {
                net[i][tag] = CRFSegmentModel.computeScore(scoreList, tag);
            }
        }
        net[0][this.idM] = -1000.0;
        net[0][this.idE] = -1000.0;
        int[][] from = new int[size][4];
        for (int i = 1; i < size; ++i) {
            for (int now = 0; now < 4; ++now) {
                double maxScore = -1.0E10;
                for (int pre = 0; pre < 4; ++pre) {
                    double score = net[i - 1][pre] + this.matrix[pre][now] + net[i][now];
                    if (!(score > maxScore)) continue;
                    maxScore = score;
                    from[i][now] = pre;
                }
                net[i][now] = maxScore;
            }
        }
        int maxTag = net[size - 1][this.idS] > net[size - 1][this.idE] ? this.idS : this.idE;
        table.setLast(size - 1, this.id2tag[maxTag]);
        maxTag = from[size - 1][maxTag];
        for (int i = size - 2; i > 0; --i) {
            table.setLast(i, this.id2tag[maxTag]);
            maxTag = from[i][maxTag];
        }
        table.setLast(0, this.id2tag[maxTag]);
    }
}

