/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.nr;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NR;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.TransformMatrixDictionary;
import com.hankcs.hanlp.dictionary.nr.NRConstant;
import com.hankcs.hanlp.dictionary.nr.NRDictionary;
import com.hankcs.hanlp.dictionary.nr.NRPattern;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

public class PersonDictionary {
    public static NRDictionary dictionary;
    public static TransformMatrixDictionary<NR> transformMatrixDictionary;
    public static AhoCorasickDoubleArrayTrie<NRPattern> trie;
    public static final CoreDictionary.Attribute ATTRIBUTE;

    public static void parsePattern(List<NR> nrList, List<Vertex> vertexList, final WordNet wordNetOptimum, final WordNet wordNetAll) {
        ListIterator<Vertex> listIterator = vertexList.listIterator();
        StringBuilder sbPattern = new StringBuilder(nrList.size());
        NR preNR = NR.A;
        boolean backUp = false;
        int index = 0;
        block4: for (NR nr : nrList) {
            ++index;
            Vertex current = listIterator.next();
            switch (nr) {
                case U: {
                    if (!backUp) {
                        vertexList = new ArrayList<Vertex>(vertexList);
                        listIterator = vertexList.listIterator(index);
                        backUp = true;
                    }
                    sbPattern.append(NR.K.toString());
                    sbPattern.append(NR.B.toString());
                    preNR = NR.B;
                    listIterator.previous();
                    String nowK = current.realWord.substring(0, current.realWord.length() - 1);
                    String nowB = current.realWord.substring(current.realWord.length() - 1);
                    listIterator.set(new Vertex(nowK));
                    listIterator.next();
                    listIterator.add(new Vertex(nowB));
                    continue block4;
                }
                case V: {
                    if (!backUp) {
                        vertexList = new ArrayList<Vertex>(vertexList);
                        listIterator = vertexList.listIterator(index);
                        backUp = true;
                    }
                    if (preNR == NR.B) {
                        sbPattern.append(NR.E.toString());
                    } else {
                        sbPattern.append(NR.D.toString());
                    }
                    sbPattern.append(NR.L.toString());
                    listIterator.previous();
                    String nowED = current.realWord.substring(current.realWord.length() - 1);
                    String nowL = current.realWord.substring(0, current.realWord.length() - 1);
                    listIterator.set(new Vertex(nowED));
                    listIterator.add(new Vertex(nowL));
                    listIterator.next();
                    continue block4;
                }
            }
            sbPattern.append(nr.toString());
            preNR = nr;
        }
        String pattern = sbPattern.toString();
        final Vertex[] wordArray = vertexList.toArray(new Vertex[0]);
        final int[] offsetArray = new int[wordArray.length];
        offsetArray[0] = 0;
        for (int i = 1; i < wordArray.length; ++i) {
            offsetArray[i] = offsetArray[i - 1] + wordArray[i - 1].realWord.length();
        }
        trie.parseText(pattern, new AhoCorasickDoubleArrayTrie.IHit<NRPattern>(){

            @Override
            public void hit(int begin, int end, NRPattern value) {
                StringBuilder sbName = new StringBuilder();
                for (int i = begin; i < end; ++i) {
                    sbName.append(wordArray[i].realWord);
                }
                String name = sbName.toString();
                switch (value) {
                    case BCD: {
                        if (name.charAt(0) != name.charAt(2)) break;
                        return;
                    }
                }
                if (PersonDictionary.isBadCase(name)) {
                    return;
                }
                if (HanLP.Config.DEBUG) {
                    System.out.printf("\u8bc6\u522b\u51fa\u4eba\u540d\uff1a%s %s\n", new Object[]{name, value});
                }
                int offset = offsetArray[begin];
                wordNetOptimum.insert(offset, new Vertex("\u672a##\u4eba", name, ATTRIBUTE, NRConstant.WORD_ID), wordNetAll);
            }
        });
    }

    static boolean isBadCase(String name) {
        EnumItem nrEnumItem = (EnumItem)dictionary.get(name);
        if (nrEnumItem == null) {
            return false;
        }
        return nrEnumItem.containsLabel(NR.A);
    }

    static {
        ATTRIBUTE = new CoreDictionary.Attribute(Nature.nr, 100);
        long start = System.currentTimeMillis();
        dictionary = new NRDictionary();
        if (!dictionary.load(HanLP.Config.PersonDictionaryPath)) {
            Predefine.logger.severe("\u4eba\u540d\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25\uff1a" + HanLP.Config.PersonDictionaryPath);
            System.exit(-1);
        }
        transformMatrixDictionary = new TransformMatrixDictionary<NR>(NR.class);
        transformMatrixDictionary.load(HanLP.Config.PersonDictionaryTrPath);
        trie = new AhoCorasickDoubleArrayTrie();
        TreeMap<String, NRPattern> map = new TreeMap<String, NRPattern>();
        for (NRPattern pattern : NRPattern.values()) {
            map.put(pattern.toString(), pattern);
        }
        trie.build(map);
        Predefine.logger.info(HanLP.Config.PersonDictionaryPath + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

