/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.utility.LexiconUtility;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class CustomDictionary {
    public static BinTrie<CoreDictionary.Attribute> trie;
    public static DoubleArrayTrie<CoreDictionary.Attribute> dat;
    public static final String[] path;

    private static boolean loadMainDictionary(String mainPath) {
        Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + mainPath);
        if (CustomDictionary.loadDat(mainPath)) {
            return true;
        }
        dat = new DoubleArrayTrie();
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        LinkedHashSet<Nature> customNatureCollector = new LinkedHashSet<Nature>();
        try {
            for (String p : path) {
                Nature defaultNature = Nature.n;
                int cut = p.indexOf(32);
                if (cut > 0) {
                    String nature = p.substring(cut + 1);
                    p = p.substring(0, cut);
                    try {
                        defaultNature = LexiconUtility.convertStringToNature(nature, customNatureCollector);
                    }
                    catch (Exception e) {
                        Predefine.logger.severe("\u914d\u7f6e\u6587\u4ef6\u3010" + p + "\u3011\u5199\u9519\u4e86\uff01" + e);
                        continue;
                    }
                }
                Predefine.logger.info("\u4ee5\u9ed8\u8ba4\u8bcd\u6027[" + (Object)((Object)defaultNature) + "]\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8bcd\u5178" + p + "\u4e2d\u2026\u2026");
                boolean success = CustomDictionary.load(p, defaultNature, map, customNatureCollector);
                if (success) continue;
                Predefine.logger.warning("\u5931\u8d25\uff1a" + p);
            }
            if (map.size() == 0) {
                Predefine.logger.warning("\u6ca1\u6709\u52a0\u8f7d\u5230\u4efb\u4f55\u8bcd\u6761");
                map.put("\u672a##\u5b83", null);
            }
            Predefine.logger.info("\u6b63\u5728\u6784\u5efaDoubleArrayTrie\u2026\u2026");
            dat.build(map);
            Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u8bcd\u5178\u4e3adat\u6587\u4ef6\u2026\u2026");
            LinkedList attributeList = new LinkedList();
            for (Map.Entry entry : map.entrySet()) {
                attributeList.add(entry.getValue());
            }
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(mainPath + ".bin"));
            IOUtil.writeCustomNature(out, customNatureCollector);
            out.writeInt(attributeList.size());
            for (CoreDictionary.Attribute attribute : attributeList) {
                attribute.save(out);
            }
            dat.save(out);
            out.close();
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        catch (Exception e) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u7f13\u5b58\u5931\u8d25\uff01\n" + TextUtility.exceptionToString(e));
        }
        return true;
    }

    public static boolean load(String path, Nature defaultNature, TreeMap<String, CoreDictionary.Attribute> map, LinkedHashSet<Nature> customNatureCollector) {
        try {
            String line;
            String splitter = "\\s";
            if (path.endsWith(".csv")) {
                splitter = ",";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                CoreDictionary.Attribute attribute;
                int natureCount;
                String[] param = line.split(splitter);
                if (param[0].length() == 0) continue;
                if (HanLP.Config.Normalization) {
                    param[0] = CharTable.convert(param[0]);
                }
                if ((natureCount = (param.length - 1) / 2) == 0) {
                    attribute = new CoreDictionary.Attribute(defaultNature);
                } else {
                    attribute = new CoreDictionary.Attribute(natureCount);
                    for (int i = 0; i < natureCount; ++i) {
                        attribute.nature[i] = LexiconUtility.convertStringToNature(param[1 + 2 * i], customNatureCollector);
                        attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                        attribute.totalFrequency += attribute.frequency[i];
                    }
                }
                map.put(param[0], attribute);
            }
            br.close();
        }
        catch (Exception e) {
            if (!path.startsWith(".")) {
                Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            }
            return false;
        }
        return true;
    }

    private static boolean updateAttributeIfExist(String key, CoreDictionary.Attribute attribute, TreeMap<String, CoreDictionary.Attribute> map, TreeMap<Integer, CoreDictionary.Attribute> rewriteTable) {
        int wordID = CoreDictionary.getWordID(key);
        if (wordID != -1) {
            CoreDictionary.Attribute attributeExisted = CoreDictionary.get(wordID);
            attributeExisted.nature = attribute.nature;
            attributeExisted.frequency = attribute.frequency;
            attributeExisted.totalFrequency = attribute.totalFrequency;
            rewriteTable.put(wordID, attribute);
            return true;
        }
        CoreDictionary.Attribute attributeExisted = map.get(key);
        if (attributeExisted != null) {
            attributeExisted.nature = attribute.nature;
            attributeExisted.frequency = attribute.frequency;
            attributeExisted.totalFrequency = attribute.totalFrequency;
            return true;
        }
        return false;
    }

    public static boolean add(String word, String natureWithFrequency) {
        if (CustomDictionary.contains(word)) {
            return false;
        }
        return CustomDictionary.insert(word, natureWithFrequency);
    }

    public static boolean add(String word) {
        if (HanLP.Config.Normalization) {
            word = CharTable.convert(word);
        }
        if (CustomDictionary.contains(word)) {
            return false;
        }
        return CustomDictionary.insert(word, null);
    }

    public static boolean insert(String word, String natureWithFrequency) {
        CoreDictionary.Attribute att;
        if (word == null) {
            return false;
        }
        if (HanLP.Config.Normalization) {
            word = CharTable.convert(word);
        }
        CoreDictionary.Attribute attribute = att = natureWithFrequency == null ? new CoreDictionary.Attribute(Nature.nz, 1) : CoreDictionary.Attribute.create(natureWithFrequency);
        if (att == null) {
            return false;
        }
        if (dat != null && dat.set(word, att)) {
            return true;
        }
        if (trie == null) {
            trie = new BinTrie();
        }
        trie.put(word, att);
        return true;
    }

    public static boolean insert(String word) {
        return CustomDictionary.insert(word, null);
    }

    static boolean loadDat(String path) {
        try {
            ByteArray byteArray = ByteArray.createByteArray(path + ".bin");
            if (byteArray == null) {
                return false;
            }
            int size = byteArray.nextInt();
            if (size < 0) {
                while (++size <= 0) {
                    Nature.create(byteArray.nextString());
                }
                size = byteArray.nextInt();
            }
            CoreDictionary.Attribute[] attributes = new CoreDictionary.Attribute[size];
            Nature[] natureIndexArray = Nature.values();
            for (int i = 0; i < size; ++i) {
                int currentTotalFrequency = byteArray.nextInt();
                int length = byteArray.nextInt();
                attributes[i] = new CoreDictionary.Attribute(length);
                attributes[i].totalFrequency = currentTotalFrequency;
                for (int j = 0; j < length; ++j) {
                    attributes[i].nature[j] = natureIndexArray[byteArray.nextInt()];
                    attributes[i].frequency[j] = byteArray.nextInt();
                }
            }
            if (!dat.load(byteArray, (CoreDictionary.Attribute[])attributes)) {
                return false;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6\u5931\u8d25\uff0c\u95ee\u9898\u53d1\u751f\u5728" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    public static CoreDictionary.Attribute get(String key) {
        CoreDictionary.Attribute attribute;
        if (HanLP.Config.Normalization) {
            key = CharTable.convert(key);
        }
        CoreDictionary.Attribute attribute2 = attribute = dat == null ? null : dat.get(key);
        if (attribute != null) {
            return attribute;
        }
        if (trie == null) {
            return null;
        }
        return trie.get(key);
    }

    public static void remove(String key) {
        if (HanLP.Config.Normalization) {
            key = CharTable.convert(key);
        }
        if (trie == null) {
            return;
        }
        trie.remove(key);
    }

    public static LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(String key) {
        return trie.commonPrefixSearchWithValue(key);
    }

    public static LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(char[] chars, int begin) {
        return trie.commonPrefixSearchWithValue(chars, begin);
    }

    public static BaseSearcher getSearcher(String text) {
        return new Searcher(text);
    }

    public String toString() {
        return "CustomDictionary{trie=" + trie + '}';
    }

    public static boolean contains(String key) {
        if (dat != null && dat.exactMatchSearch(key) >= 0) {
            return true;
        }
        return trie != null && trie.containsKey(key);
    }

    public static BaseSearcher getSearcher(char[] charArray) {
        return new Searcher(charArray);
    }

    public static BinTrie<CoreDictionary.Attribute> getTrie() {
        return trie;
    }

    public static void parseText(char[] text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        Object searcher;
        if (trie != null) {
            Map.Entry entry;
            searcher = CustomDictionary.getSearcher(text);
            while ((entry = ((BaseSearcher)searcher).next()) != null) {
                int offset = ((BaseSearcher)searcher).getOffset();
                processor.hit(offset, offset + entry.getKey().length(), (CoreDictionary.Attribute)entry.getValue());
            }
        }
        searcher = dat.getSearcher(text, 0);
        while (((DoubleArrayTrie.Searcher)searcher).next()) {
            processor.hit(((DoubleArrayTrie.Searcher)searcher).begin, ((DoubleArrayTrie.Searcher)searcher).begin + ((DoubleArrayTrie.Searcher)searcher).length, (CoreDictionary.Attribute)((DoubleArrayTrie.Searcher)searcher).value);
        }
    }

    public static void parseText(String text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        Object searcher;
        if (trie != null) {
            Map.Entry entry;
            searcher = CustomDictionary.getSearcher(text);
            while ((entry = ((BaseSearcher)searcher).next()) != null) {
                int offset = ((BaseSearcher)searcher).getOffset();
                processor.hit(offset, offset + entry.getKey().length(), (CoreDictionary.Attribute)entry.getValue());
            }
        }
        searcher = dat.getSearcher(text, 0);
        while (((DoubleArrayTrie.Searcher)searcher).next()) {
            processor.hit(((DoubleArrayTrie.Searcher)searcher).begin, ((DoubleArrayTrie.Searcher)searcher).begin + ((DoubleArrayTrie.Searcher)searcher).length, (CoreDictionary.Attribute)((DoubleArrayTrie.Searcher)searcher).value);
        }
    }

    static {
        dat = new DoubleArrayTrie();
        path = HanLP.Config.CustomDictionaryPath;
        long start = System.currentTimeMillis();
        if (!CustomDictionary.loadMainDictionary(path[0])) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + Arrays.toString(path) + "\u52a0\u8f7d\u5931\u8d25");
        } else {
            Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + dat.size() + "\u4e2a\u8bcd\u6761\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        }
    }

    static class Searcher
    extends BaseSearcher<CoreDictionary.Attribute> {
        int begin;
        private LinkedList<Map.Entry<String, CoreDictionary.Attribute>> entryList = new LinkedList();

        protected Searcher(char[] c) {
            super(c);
        }

        protected Searcher(String text) {
            super(text);
        }

        @Override
        public Map.Entry<String, CoreDictionary.Attribute> next() {
            while (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0) {
                return null;
            }
            Map.Entry<String, CoreDictionary.Attribute> result = this.entryList.getFirst();
            this.entryList.removeFirst();
            this.offset = this.begin - 1;
            return result;
        }
    }
}

