/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algorithm;

import com.hankcs.hanlp.algorithm.EditDistance;
import com.hankcs.hanlp.corpus.synonym.Synonym;
import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionary;
import java.util.List;

public class VectorDistance {
    public static long compute(long[] arrayA, long[] arrayB) {
        int m = arrayA.length;
        int n = arrayB.length;
        if (m == 0 || n == 0) {
            return 1L;
        }
        long total = 0L;
        for (long va : arrayA) {
            long min_distance = Long.MAX_VALUE;
            for (long vb : arrayB) {
                min_distance = Math.min(min_distance, Math.abs(va - vb));
            }
            total += min_distance;
        }
        return total / (long)m;
    }

    public static double compute(List<CommonSynonymDictionary.SynonymItem> synonymItemListA, List<CommonSynonymDictionary.SynonymItem> synonymItemListB) {
        double total = 0.0;
        for (CommonSynonymDictionary.SynonymItem itemA : synonymItemListA) {
            long min_distance = Long.MAX_VALUE;
            for (CommonSynonymDictionary.SynonymItem itemB : synonymItemListB) {
                long distance = itemA.type != Synonym.Type.UNDEFINED && itemB.type != Synonym.Type.UNDEFINED ? Math.abs(itemA.entry.id - itemB.entry.id) : (long)(EditDistance.ed(itemA.entry.realWord, itemB.entry.realWord) * 1000000);
                min_distance = Math.min(min_distance, distance);
            }
            total += (double)min_distance;
        }
        return total;
    }
}

