/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.NShort.Path;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.utility.Predefine;

public class AtomNode {
    public String sWord;
    public int nPOS;

    public AtomNode(String sWord, int nPOS) {
        this.sWord = sWord;
        this.nPOS = nPOS;
    }

    public AtomNode(char c, int nPOS) {
        this.sWord = String.valueOf(c);
        this.nPOS = nPOS;
    }

    public Nature getNature() {
        Nature nature = Nature.nz;
        switch (this.nPOS) {
            case 7: {
                break;
            }
            case 9: 
            case 10: {
                nature = Nature.m;
                this.sWord = "\u672a##\u6570";
                break;
            }
            case 6: {
                nature = Nature.w;
                break;
            }
            case 8: {
                nature = Nature.nx;
                this.sWord = "\u672a##\u4e32";
                break;
            }
            case 5: {
                if (Predefine.PATTERN_FLOAT_NUMBER.matcher(this.sWord).matches()) {
                    nature = Nature.m;
                    this.sWord = "\u672a##\u6570";
                    break;
                }
                nature = Nature.nx;
                this.sWord = "\u672a##\u4e32";
                break;
            }
        }
        return nature;
    }

    public String toString() {
        return "AtomNode{word='" + this.sWord + '\'' + ", nature=" + this.nPOS + '}';
    }

    public static Vertex convert(String word, int type) {
        String name = word;
        Nature nature = Nature.n;
        int dValue = 1;
        switch (type) {
            case 7: {
                break;
            }
            case 9: 
            case 10: {
                nature = Nature.m;
                word = "\u672a##\u6570";
                break;
            }
            case 6: {
                nature = Nature.w;
                break;
            }
            case 8: {
                nature = Nature.nx;
                word = "\u672a##\u4e32";
                break;
            }
            case 5: {
                nature = Nature.nx;
                word = "\u672a##\u4e32";
                break;
            }
        }
        return new Vertex(word, name, new CoreDictionary.Attribute(nature, dValue));
    }
}

