/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.EditDistance;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import java.util.ArrayList;
import java.util.List;

public class CoreSynonymDictionary {
    static CommonSynonymDictionary dictionary;

    public static CommonSynonymDictionary.SynonymItem get(String key) {
        return dictionary.get(key);
    }

    public static String rewriteQuickly(String text) {
        return dictionary.rewriteQuickly(text);
    }

    public static String rewrite(String text) {
        return dictionary.rewrite(text);
    }

    public static long distance(CommonSynonymDictionary.SynonymItem itemA, CommonSynonymDictionary.SynonymItem itemB) {
        return itemA.distance(itemB);
    }

    public static long distance(String A, String B) {
        CommonSynonymDictionary.SynonymItem itemA = CoreSynonymDictionary.get(A);
        CommonSynonymDictionary.SynonymItem itemB = CoreSynonymDictionary.get(B);
        if (itemA == null || itemB == null) {
            return Long.MAX_VALUE;
        }
        return CoreSynonymDictionary.distance(itemA, itemB);
    }

    public static double similarity(String A, String B) {
        long distance = CoreSynonymDictionary.distance(A, B);
        if (distance > dictionary.getMaxSynonymItemIdDistance()) {
            return 0.0;
        }
        return (double)(dictionary.getMaxSynonymItemIdDistance() - distance) / (double)dictionary.getMaxSynonymItemIdDistance();
    }

    public static List<CommonSynonymDictionary.SynonymItem> convert(List<Term> sentence, boolean withUndefinedItem) {
        ArrayList<CommonSynonymDictionary.SynonymItem> synonymItemList = new ArrayList<CommonSynonymDictionary.SynonymItem>(sentence.size());
        for (Term term : sentence) {
            CommonSynonymDictionary.SynonymItem item = CoreSynonymDictionary.get(term.word);
            if (item == null) {
                if (!withUndefinedItem) continue;
                item = CommonSynonymDictionary.SynonymItem.createUndefined(term.word);
                synonymItemList.add(item);
                continue;
            }
            synonymItemList.add(item);
        }
        return synonymItemList;
    }

    public static long[] getLexemeArray(List<CommonSynonymDictionary.SynonymItem> synonymItemList) {
        long[] array = new long[synonymItemList.size()];
        int i = 0;
        for (CommonSynonymDictionary.SynonymItem item : synonymItemList) {
            array[i++] = item.entry.id;
        }
        return array;
    }

    public long distance(List<CommonSynonymDictionary.SynonymItem> synonymItemListA, List<CommonSynonymDictionary.SynonymItem> synonymItemListB) {
        return EditDistance.compute(synonymItemListA, synonymItemListB);
    }

    public long distance(long[] arrayA, long[] arrayB) {
        return EditDistance.compute(arrayA, arrayB);
    }

    static {
        try {
            long start = System.currentTimeMillis();
            dictionary = CommonSynonymDictionary.create(IOUtil.newInputStream(HanLP.Config.CoreSynonymDictionaryDictionaryPath));
            Predefine.logger.info("\u8f7d\u5165\u6838\u5fc3\u540c\u4e49\u8bcd\u8bcd\u5178\u6210\u529f\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            System.err.println("\u8f7d\u5165\u6838\u5fc3\u540c\u4e49\u8bcd\u8bcd\u5178\u5931\u8d25" + e);
            System.exit(-1);
        }
    }
}

