/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.common;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.dependency.CoNll.PosTagCompiler;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.seg.common.Term;

public class Node {
    public static final Node NULL = new Node(new Term(CoNLLWord.NULL.NAME, Nature.n), -1);
    public String word;
    public String compiledWord;
    public String label;
    public int id;

    public Node(Term term, int id) {
        this.id = id;
        switch (term.nature) {
            case bg: {
                this.label = "b";
                break;
            }
            case mg: {
                this.label = "Mg";
                break;
            }
            case nx: {
                this.label = "x";
                break;
            }
            case qg: {
                this.label = "q";
                break;
            }
            case ud: {
                this.label = "u";
                break;
            }
            case uj: {
                this.label = "u";
                break;
            }
            case uz: {
                this.label = "uzhe";
                break;
            }
            case ug: {
                this.label = "uguo";
                break;
            }
            case ul: {
                this.label = "ulian";
                break;
            }
            case uv: {
                this.label = "u";
                break;
            }
            case yg: {
                this.label = "y";
                break;
            }
            case zg: {
                this.label = "z";
                break;
            }
            case ntc: 
            case ntcf: 
            case ntcb: 
            case ntch: 
            case nto: 
            case ntu: 
            case nts: 
            case nth: {
                this.label = "nt";
                break;
            }
            case nh: 
            case nhm: 
            case nhd: {
                this.label = "nz";
                break;
            }
            case nn: {
                this.label = "n";
                break;
            }
            case nnt: {
                this.label = "n";
                break;
            }
            case nnd: {
                this.label = "n";
                break;
            }
            case nf: {
                this.label = "n";
                break;
            }
            case ni: 
            case nit: 
            case nic: {
                this.label = "nt";
                break;
            }
            case nis: {
                this.label = "n";
                break;
            }
            case nm: {
                this.label = "n";
                break;
            }
            case nmc: {
                this.label = "nz";
                break;
            }
            case nb: {
                this.label = "nz";
                break;
            }
            case nba: {
                this.label = "nz";
                break;
            }
            case nbc: 
            case nbp: 
            case nz: {
                this.label = "nz";
                break;
            }
            case g: {
                this.label = "nz";
                break;
            }
            case gm: 
            case gp: 
            case gc: 
            case gb: 
            case gbc: 
            case gg: 
            case gi: {
                this.label = "nz";
                break;
            }
            case j: {
                this.label = "nz";
                break;
            }
            case i: {
                this.label = "nz";
                break;
            }
            case l: {
                this.label = "nz";
                break;
            }
            case rg: 
            case Rg: {
                this.label = "Rg";
                break;
            }
            case udh: {
                this.label = "u";
                break;
            }
            case e: {
                this.label = "y";
                break;
            }
            case xx: {
                this.label = "x";
                break;
            }
            case xu: {
                this.label = "x";
                break;
            }
            case w: 
            case wkz: 
            case wky: 
            case wyz: 
            case wyy: 
            case wj: 
            case ww: 
            case wt: 
            case wd: 
            case wf: 
            case wn: 
            case wm: 
            case ws: 
            case wp: 
            case wb: 
            case wh: {
                this.label = "x";
                break;
            }
            case begin: {
                this.label = "root";
                break;
            }
            default: {
                this.label = term.nature.toString();
            }
        }
        this.word = term.word;
        this.compiledWord = PosTagCompiler.compile(this.label, this.word);
    }

    public String toString() {
        return this.word + "/" + this.label;
    }

    static {
        Node.NULL.label = "null";
    }
}

