/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.recognition.nr;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.Viterbi;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NR;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.nr.PersonDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PersonRecognition {
    public static boolean Recognition(List<Vertex> pWordSegResult, WordNet wordNetOptimum, WordNet wordNetAll) {
        List<EnumItem<NR>> roleTagList = PersonRecognition.roleTag(pWordSegResult);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            for (EnumItem<NR> nrEnumItem : roleTagList) {
                sbLog.append('[');
                sbLog.append(iterator.next().realWord);
                sbLog.append(' ');
                sbLog.append(nrEnumItem);
                sbLog.append(']');
            }
            System.out.printf("\u4eba\u540d\u89d2\u8272\u89c2\u5bdf\uff1a%s\n", sbLog.toString());
        }
        List<NR> nrList = PersonRecognition.viterbiExCompute(roleTagList);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            sbLog.append('[');
            for (NR nr : nrList) {
                sbLog.append(iterator.next().realWord);
                sbLog.append('/');
                sbLog.append((Object)nr);
                sbLog.append(" ,");
            }
            if (sbLog.length() > 1) {
                sbLog.delete(sbLog.length() - 2, sbLog.length());
            }
            sbLog.append(']');
            System.out.printf("\u4eba\u540d\u89d2\u8272\u6807\u6ce8\uff1a%s\n", sbLog.toString());
        }
        PersonDictionary.parsePattern(nrList, pWordSegResult, wordNetOptimum, wordNetAll);
        return true;
    }

    public static List<EnumItem<NR>> roleTag(List<Vertex> pWordSegResult) {
        LinkedList<EnumItem<NR>> tagList = new LinkedList<EnumItem<NR>>();
        for (Vertex vertex : pWordSegResult) {
            if (Nature.nr == vertex.getNature() && vertex.getAttribute().totalFrequency <= 1000 && vertex.realWord.length() == 2) {
                tagList.add(new EnumItem((Enum[])new NR[]{NR.X, NR.G}));
                continue;
            }
            EnumItem<NR> nrEnumItem = (EnumItem<NR>)PersonDictionary.dictionary.get(vertex.realWord);
            if (nrEnumItem == null) {
                nrEnumItem = new EnumItem<NR>(NR.A, PersonDictionary.transformMatrixDictionary.getTotalFrequency(NR.A));
            }
            tagList.add(nrEnumItem);
        }
        return tagList;
    }

    public static List<NR> viterbiCompute(List<EnumItem<NR>> roleTagList) {
        int[] result;
        LinkedList<NR> resultList = new LinkedList<NR>();
        int[] observations = new int[roleTagList.size()];
        for (int i = 0; i < observations.length; ++i) {
            observations[i] = i;
        }
        double[][] emission_probability = new double[PersonDictionary.transformMatrixDictionary.ordinaryMax][observations.length];
        for (int i = 0; i < emission_probability.length; ++i) {
            for (int j = 0; j < emission_probability[i].length; ++j) {
                emission_probability[i][j] = 1.0E8;
            }
        }
        for (int s : PersonDictionary.transformMatrixDictionary.states) {
            Iterator<EnumItem<NR>> iterator = roleTagList.iterator();
            for (int o : observations) {
                NR sNR = NR.values()[s];
                EnumItem<NR> item = iterator.next();
                double frequency = item.getFrequency(sNR);
                emission_probability[s][o] = frequency == 0.0 ? 1.0E8 : -Math.log(frequency / (double)PersonDictionary.transformMatrixDictionary.getTotalFrequency(sNR));
            }
        }
        for (int r : result = Viterbi.compute(observations, PersonDictionary.transformMatrixDictionary.states, PersonDictionary.transformMatrixDictionary.start_probability, PersonDictionary.transformMatrixDictionary.transititon_probability, emission_probability)) {
            resultList.add(NR.values()[r]);
        }
        return resultList;
    }

    public static List<NR> viterbiExCompute(List<EnumItem<NR>> roleTagList) {
        return Viterbi.computeEnumSimply(roleTagList, PersonDictionary.transformMatrixDictionary);
    }
}

