/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.nt;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.Emit;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.Trie;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NT;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.TransformMatrixDictionary;
import com.hankcs.hanlp.dictionary.nt.NTDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Collection;
import java.util.List;

public class OrganizationDictionary {
    public static NTDictionary dictionary;
    public static TransformMatrixDictionary<NT> transformMatrixDictionary;
    public static Trie trie;
    static final int WORD_ID;
    static final CoreDictionary.Attribute ATTRIBUTE;

    public static void parsePattern(List<NT> ntList, List<Vertex> vertexList, WordNet wordNetOptimum, WordNet wordNetAll) {
        StringBuilder sbPattern = new StringBuilder(ntList.size());
        for (NT nt : ntList) {
            sbPattern.append(nt.toString());
        }
        String pattern = sbPattern.toString();
        Collection<Emit> emitCollection = trie.parseText(pattern);
        Vertex[] wordArray = vertexList.toArray(new Vertex[0]);
        for (Emit emit : emitCollection) {
            String keyword = emit.getKeyword();
            int start = emit.getStart();
            int end = emit.getEnd();
            StringBuilder sbName = new StringBuilder();
            for (int i = start; i <= end; ++i) {
                sbName.append(wordArray[i].realWord);
            }
            String name = sbName.toString();
            if (OrganizationDictionary.isBadCase(name)) continue;
            if (HanLP.Config.DEBUG) {
                System.out.printf("\u8bc6\u522b\u51fa\u673a\u6784\u540d\uff1a%s %s\n", name, keyword);
            }
            int offset = 0;
            for (int i = 0; i < start; ++i) {
                offset += wordArray[i].realWord.length();
            }
            wordNetOptimum.insert(offset, new Vertex("\u672a##\u56e2", name, ATTRIBUTE, WORD_ID), wordNetAll);
        }
    }

    static boolean isBadCase(String name) {
        EnumItem nrEnumItem = (EnumItem)dictionary.get(name);
        if (nrEnumItem == null) {
            return false;
        }
        return nrEnumItem.containsLabel(NT.Z);
    }

    static {
        WORD_ID = CoreDictionary.getWordID("\u672a##\u56e2");
        ATTRIBUTE = CoreDictionary.get(WORD_ID);
        long start = System.currentTimeMillis();
        dictionary = new NTDictionary();
        dictionary.load(HanLP.Config.OrganizationDictionaryPath);
        Predefine.logger.info(HanLP.Config.OrganizationDictionaryPath + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        transformMatrixDictionary = new TransformMatrixDictionary<NT>(NT.class);
        transformMatrixDictionary.load(HanLP.Config.OrganizationDictionaryTrPath);
        trie = new Trie().removeOverlaps();
        trie.addKeyword("CCCCCCCCD");
        trie.addKeyword("CCCCCCCD");
        trie.addKeyword("CCCCCCD");
        trie.addKeyword("CCCCCCGD");
        trie.addKeyword("CCCCCCICCCCD");
        trie.addKeyword("CCCCCCPD");
        trie.addKeyword("CCCCCD");
        trie.addKeyword("CCCCCDD");
        trie.addKeyword("CCCCCGCCD");
        trie.addKeyword("CCCCCICCCCCD");
        trie.addKeyword("CCCCCPCCD");
        trie.addKeyword("CCCCCWDWD");
        trie.addKeyword("CCCCD");
        trie.addKeyword("CCCCDCCD");
        trie.addKeyword("CCCCDCD");
        trie.addKeyword("CCCCDD");
        trie.addKeyword("CCCCID");
        trie.addKeyword("CCCCPCD");
        trie.addKeyword("CCCD");
        trie.addKeyword("CCCDCCCD");
        trie.addKeyword("CCCDCCD");
        trie.addKeyword("CCCDCD");
        trie.addKeyword("CCCDD");
        trie.addKeyword("CCCDICFPD");
        trie.addKeyword("CCCFCFFCD");
        trie.addKeyword("CCCGD");
        trie.addKeyword("CCCGID");
        trie.addKeyword("CCCGJCD");
        trie.addKeyword("CCCID");
        trie.addKeyword("CCCJCCD");
        trie.addKeyword("CCCJD");
        trie.addKeyword("CCCLGCD");
        trie.addKeyword("CCCMD");
        trie.addKeyword("CCCPCCCD");
        trie.addKeyword("CCCPCCD");
        trie.addKeyword("CCCPCD");
        trie.addKeyword("CCCPD");
        trie.addKeyword("CCD");
        trie.addKeyword("CCDCCCCCCD");
        trie.addKeyword("CCDCCCCD");
        trie.addKeyword("CCDCCCD");
        trie.addKeyword("CCDCCCDD");
        trie.addKeyword("CCDCCD");
        trie.addKeyword("CCDCD");
        trie.addKeyword("CCDCDD");
        trie.addKeyword("CCDCGCD");
        trie.addKeyword("CCDCGCDID");
        trie.addKeyword("CCDCGCDPD");
        trie.addKeyword("CCDCGGDD");
        trie.addKeyword("CCDCID");
        trie.addKeyword("CCDCJCCD");
        trie.addKeyword("CCDCJCCDD");
        trie.addKeyword("CCDD");
        trie.addKeyword("CCDDD");
        trie.addKeyword("CCDFIDGD");
        trie.addKeyword("CCDGCCD");
        trie.addKeyword("CCDICD");
        trie.addKeyword("CCDID");
        trie.addKeyword("CCDJCD");
        trie.addKeyword("CCDPCD");
        trie.addKeyword("CCDPJD");
        trie.addKeyword("CCFCCD");
        trie.addKeyword("CCFD");
        trie.addKeyword("CCGCCCD");
        trie.addKeyword("CCGCCD");
        trie.addKeyword("CCGCD");
        trie.addKeyword("CCGCDCD");
        trie.addKeyword("CCGCDCMD");
        trie.addKeyword("CCGD");
        trie.addKeyword("CCGGCD");
        trie.addKeyword("CCGID");
        trie.addKeyword("CCGIDD");
        trie.addKeyword("CCGJD");
        trie.addKeyword("CCGWGWD");
        trie.addKeyword("CCICCD");
        trie.addKeyword("CCICD");
        trie.addKeyword("CCICIFD");
        trie.addKeyword("CCICJPD");
        trie.addKeyword("CCID");
        trie.addKeyword("CCIDCD");
        trie.addKeyword("CCIDD");
        trie.addKeyword("CCIID");
        trie.addKeyword("CCJCCCD");
        trie.addKeyword("CCJCCD");
        trie.addKeyword("CCJCD");
        trie.addKeyword("CCJCFD");
        trie.addKeyword("CCJD");
        trie.addKeyword("CCJID");
        trie.addKeyword("CCJJMJD");
        trie.addKeyword("CCKID");
        trie.addKeyword("CCLD");
        trie.addKeyword("CCMD");
        trie.addKeyword("CCMMPDCD");
        trie.addKeyword("CCPCCD");
        trie.addKeyword("CCPCD");
        trie.addKeyword("CCPD");
        trie.addKeyword("CCPDCD");
        trie.addKeyword("CCPPD");
        trie.addKeyword("CCWCWD");
        trie.addKeyword("CCWGWCCD");
        trie.addKeyword("CCWGWD");
        trie.addKeyword("CD");
        trie.addKeyword("CDCCCCCCD");
        trie.addKeyword("CDCCCCD");
        trie.addKeyword("CDCCCD");
        trie.addKeyword("CDCCD");
        trie.addKeyword("CDCCDD");
        trie.addKeyword("CDCCJD");
        trie.addKeyword("CDCD");
        trie.addKeyword("CDCDD");
        trie.addKeyword("CDCGD");
        trie.addKeyword("CDCGPCCD");
        trie.addKeyword("CDCJD");
        trie.addKeyword("CDCLD");
        trie.addKeyword("CDCWIWD");
        trie.addKeyword("CDD");
        trie.addKeyword("CDDCCD");
        trie.addKeyword("CDDCCDD");
        trie.addKeyword("CDDCD");
        trie.addKeyword("CDDD");
        trie.addKeyword("CDFD");
        trie.addKeyword("CDFPCCD");
        trie.addKeyword("CDGCD");
        trie.addKeyword("CDGCICD");
        trie.addKeyword("CDGD");
        trie.addKeyword("CDICD");
        trie.addKeyword("CDID");
        trie.addKeyword("CDILLCCD");
        trie.addKeyword("CDJCCD");
        trie.addKeyword("CDJCD");
        trie.addKeyword("CDJD");
        trie.addKeyword("CDJLD");
        trie.addKeyword("CDLGCD");
        trie.addKeyword("CDLJD");
        trie.addKeyword("CDMCD");
        trie.addKeyword("CDPCCCCD");
        trie.addKeyword("CDPCCD");
        trie.addKeyword("CDPD");
        trie.addKeyword("CDPPD");
        trie.addKeyword("CFCCD");
        trie.addKeyword("CFCPD");
        trie.addKeyword("CFD");
        trie.addKeyword("CFPD");
        trie.addKeyword("CGCCCD");
        trie.addKeyword("CGCCD");
        trie.addKeyword("CGCD");
        trie.addKeyword("CGCDCD");
        trie.addKeyword("CGCDD");
        trie.addKeyword("CGD");
        trie.addKeyword("CGDCD");
        trie.addKeyword("CGDD");
        trie.addKeyword("CGDDCCD");
        trie.addKeyword("CGDDD");
        trie.addKeyword("CGDDID");
        trie.addKeyword("CGDJD");
        trie.addKeyword("CGDMD");
        trie.addKeyword("CGFD");
        trie.addKeyword("CGGCCCD");
        trie.addKeyword("CGGCCD");
        trie.addKeyword("CGGCD");
        trie.addKeyword("CGGD");
        trie.addKeyword("CGGGD");
        trie.addKeyword("CGGGDD");
        trie.addKeyword("CGGICD");
        trie.addKeyword("CGGJD");
        trie.addKeyword("CGICD");
        trie.addKeyword("CGID");
        trie.addKeyword("CGIJD");
        trie.addKeyword("CGJD");
        trie.addKeyword("CGMD");
        trie.addKeyword("CGPJD");
        trie.addKeyword("CICCCCD");
        trie.addKeyword("CICCD");
        trie.addKeyword("CICD");
        trie.addKeyword("CICDCD");
        trie.addKeyword("CICDD");
        trie.addKeyword("CICWGWD");
        trie.addKeyword("CID");
        trie.addKeyword("CIDD");
        trie.addKeyword("CIGCD");
        trie.addKeyword("CIGD");
        trie.addKeyword("CIID");
        trie.addKeyword("CILCD");
        trie.addKeyword("CIMD");
        trie.addKeyword("CJCCCCCD");
        trie.addKeyword("CJCCCD");
        trie.addKeyword("CJCCCDD");
        trie.addKeyword("CJCCD");
        trie.addKeyword("CJCCMD");
        trie.addKeyword("CJCD");
        trie.addKeyword("CJCDD");
        trie.addKeyword("CJCGCCD");
        trie.addKeyword("CJCGPJD");
        trie.addKeyword("CJCMD");
        trie.addKeyword("CJCPCCCD");
        trie.addKeyword("CJCPD");
        trie.addKeyword("CJD");
        trie.addKeyword("CJDCCCCD");
        trie.addKeyword("CJDCCJD");
        trie.addKeyword("CJDCD");
        trie.addKeyword("CJDD");
        trie.addKeyword("CJDFD");
        trie.addKeyword("CJDPD");
        trie.addKeyword("CJFCD");
        trie.addKeyword("CJFD");
        trie.addKeyword("CJGD");
        trie.addKeyword("CJGLD");
        trie.addKeyword("CJGPCJD");
        trie.addKeyword("CJID");
        trie.addKeyword("CJJCCD");
        trie.addKeyword("CJJD");
        trie.addKeyword("CJJJD");
        trie.addKeyword("CJJLD");
        trie.addKeyword("CJKD");
        trie.addKeyword("CJLCCD");
        trie.addKeyword("CJMCD");
        trie.addKeyword("CJMD");
        trie.addKeyword("CJPD");
        trie.addKeyword("CJWCCWCGJD");
        trie.addKeyword("CJWD");
        trie.addKeyword("CJWPMWCGD");
        trie.addKeyword("CKCD");
        trie.addKeyword("CKD");
        trie.addKeyword("CKJCDCD");
        trie.addKeyword("CKJPD");
        trie.addKeyword("CLCCCD");
        trie.addKeyword("CLCCD");
        trie.addKeyword("CLCCGCD");
        trie.addKeyword("CLCD");
        trie.addKeyword("CLD");
        trie.addKeyword("CLDFD");
        trie.addKeyword("CLID");
        trie.addKeyword("CLPCD");
        trie.addKeyword("CMCD");
        trie.addKeyword("CMCDD");
        trie.addKeyword("CMCGD");
        trie.addKeyword("CMD");
        trie.addKeyword("CMDCD");
        trie.addKeyword("CMDD");
        trie.addKeyword("CMMD");
        trie.addKeyword("CMMDCCD");
        trie.addKeyword("CMPD");
        trie.addKeyword("CPCCCCCCCD");
        trie.addKeyword("CPCCCCD");
        trie.addKeyword("CPCCCD");
        trie.addKeyword("CPCCD");
        trie.addKeyword("CPCD");
        trie.addKeyword("CPCDD");
        trie.addKeyword("CPCPD");
        trie.addKeyword("CPD");
        trie.addKeyword("CPDCCD");
        trie.addKeyword("CPDCD");
        trie.addKeyword("CPDD");
        trie.addKeyword("CPDGD");
        trie.addKeyword("CPDWGWD");
        trie.addKeyword("CPGCD");
        trie.addKeyword("CPGD");
        trie.addKeyword("CPID");
        trie.addKeyword("CPJCD");
        trie.addKeyword("CPJD");
        trie.addKeyword("CPJPD");
        trie.addKeyword("CPMD");
        trie.addKeyword("CPPD");
        trie.addKeyword("CWCD");
        trie.addKeyword("CWCGWCCD");
        trie.addKeyword("CWCWD");
        trie.addKeyword("CWDWDD");
        trie.addKeyword("CWGWCCD");
        trie.addKeyword("CWGWCD");
        trie.addKeyword("CWPWD");
        trie.addKeyword("DCCCCCD");
        trie.addKeyword("DCCCCD");
        trie.addKeyword("DCCCCDCCD");
        trie.addKeyword("DCCCD");
        trie.addKeyword("DCCD");
        trie.addKeyword("DCD");
        trie.addKeyword("DCDD");
        trie.addKeyword("DCGCD");
        trie.addKeyword("DCJD");
        trie.addKeyword("DCPD");
        trie.addKeyword("DD");
        trie.addKeyword("DDCCD");
        trie.addKeyword("DDCD");
        trie.addKeyword("DDD");
        trie.addKeyword("DDICCD");
        trie.addKeyword("DFD");
        trie.addKeyword("DGCCD");
        trie.addKeyword("DGCD");
        trie.addKeyword("DGDCD");
        trie.addKeyword("DGDD");
        trie.addKeyword("DGDPD");
        trie.addKeyword("DGGD");
        trie.addKeyword("DICCCD");
        trie.addKeyword("DICD");
        trie.addKeyword("DID");
        trie.addKeyword("DIICD");
        trie.addKeyword("DJCCD");
        trie.addKeyword("DJCD");
        trie.addKeyword("DJD");
        trie.addKeyword("DLCCD");
        trie.addKeyword("DLCD");
        trie.addKeyword("DLD");
        trie.addKeyword("DMCD");
        trie.addKeyword("DMD");
        trie.addKeyword("DMMCD");
        trie.addKeyword("DPD");
        trie.addKeyword("DPMMCCD");
        trie.addKeyword("FCCCCCD");
        trie.addKeyword("FCCCCD");
        trie.addKeyword("FCCCD");
        trie.addKeyword("FCCCPCD");
        trie.addKeyword("FCCD");
        trie.addKeyword("FCCGD");
        trie.addKeyword("FCCID");
        trie.addKeyword("FCCPD");
        trie.addKeyword("FCCWGWD");
        trie.addKeyword("FCD");
        trie.addKeyword("FCDCD");
        trie.addKeyword("FCDD");
        trie.addKeyword("FCDFD");
        trie.addKeyword("FCFCD");
        trie.addKeyword("FCFPD");
        trie.addKeyword("FCGCCD");
        trie.addKeyword("FCGCD");
        trie.addKeyword("FCGD");
        trie.addKeyword("FCID");
        trie.addKeyword("FCIJJD");
        trie.addKeyword("FCJCD");
        trie.addKeyword("FCJD");
        trie.addKeyword("FCPD");
        trie.addKeyword("FCPGCD");
        trie.addKeyword("FCWGWD");
        trie.addKeyword("FD");
        trie.addKeyword("FDCD");
        trie.addKeyword("FDD");
        trie.addKeyword("FDFD");
        trie.addKeyword("FDGCCD");
        trie.addKeyword("FDID");
        trie.addKeyword("FDLCD");
        trie.addKeyword("FFCCD");
        trie.addKeyword("FFCD");
        trie.addKeyword("FFCKFCCD");
        trie.addKeyword("FFCLLD");
        trie.addKeyword("FFD");
        trie.addKeyword("FFFD");
        trie.addKeyword("FFGCCD");
        trie.addKeyword("FFGD");
        trie.addKeyword("FFJCD");
        trie.addKeyword("FFJD");
        trie.addKeyword("FFJPCD");
        trie.addKeyword("FFPD");
        trie.addKeyword("FGCCD");
        trie.addKeyword("FGCD");
        trie.addKeyword("FGCGCGCJCD");
        trie.addKeyword("FGD");
        trie.addKeyword("FGDD");
        trie.addKeyword("FGFD");
        trie.addKeyword("FGJCCD");
        trie.addKeyword("FICCD");
        trie.addKeyword("FICD");
        trie.addKeyword("FICDD");
        trie.addKeyword("FICGD");
        trie.addKeyword("FICID");
        trie.addKeyword("FID");
        trie.addKeyword("FIDCD");
        trie.addKeyword("FIDD");
        trie.addKeyword("FIFPD");
        trie.addKeyword("FIID");
        trie.addKeyword("FIJCD");
        trie.addKeyword("FIJD");
        trie.addKeyword("FJCCD");
        trie.addKeyword("FJCD");
        trie.addKeyword("FJCDD");
        trie.addKeyword("FJD");
        trie.addKeyword("FJDCD");
        trie.addKeyword("FJDD");
        trie.addKeyword("FJGD");
        trie.addKeyword("FJJCCD");
        trie.addKeyword("FJJCD");
        trie.addKeyword("FJJCLCD");
        trie.addKeyword("FJJD");
        trie.addKeyword("FJJJCCD");
        trie.addKeyword("FJJJD");
        trie.addKeyword("FJJJICCD");
        trie.addKeyword("FJJLJLCD");
        trie.addKeyword("FJPJD");
        trie.addKeyword("FKCD");
        trie.addKeyword("FKCJD");
        trie.addKeyword("FLD");
        trie.addKeyword("FLPCD");
        trie.addKeyword("FPCCCD");
        trie.addKeyword("FPCD");
        trie.addKeyword("FPD");
        trie.addKeyword("FPFD");
        trie.addKeyword("FPFDD");
        trie.addKeyword("FPID");
        trie.addKeyword("FPJCCD");
        trie.addKeyword("FPJCD");
        trie.addKeyword("FPPCD");
        trie.addKeyword("FPPD");
        trie.addKeyword("FPPDLD");
        trie.addKeyword("FWCCCWCD");
        trie.addKeyword("FWCCCWD");
        trie.addKeyword("FWDWD");
        trie.addKeyword("FWFD");
        trie.addKeyword("FWFWCCCWD");
        trie.addKeyword("FWGJCD");
        trie.addKeyword("FWGWCD");
        trie.addKeyword("GCCCCCCCD");
        trie.addKeyword("GCCCCCCD");
        trie.addKeyword("GCCCCCD");
        trie.addKeyword("GCCCCCDCD");
        trie.addKeyword("GCCCCCDD");
        trie.addKeyword("GCCCCD");
        trie.addKeyword("GCCCCDCCD");
        trie.addKeyword("GCCCCDD");
        trie.addKeyword("GCCCCGD");
        trie.addKeyword("GCCCCJD");
        trie.addKeyword("GCCCCPD");
        trie.addKeyword("GCCCCWDWD");
        trie.addKeyword("GCCCD");
        trie.addKeyword("GCCCDCCCD");
        trie.addKeyword("GCCCDCCCDD");
        trie.addKeyword("GCCCDCCD");
        trie.addKeyword("GCCCDCD");
        trie.addKeyword("GCCCDD");
        trie.addKeyword("GCCCDDJD");
        trie.addKeyword("GCCCDID");
        trie.addKeyword("GCCCDMCD");
        trie.addKeyword("GCCCDPD");
        trie.addKeyword("GCCCDWGCDWD");
        trie.addKeyword("GCCCFCD");
        trie.addKeyword("GCCCGD");
        trie.addKeyword("GCCCICD");
        trie.addKeyword("GCCCID");
        trie.addKeyword("GCCCJCD");
        trie.addKeyword("GCCCJD");
        trie.addKeyword("GCCCJGD");
        trie.addKeyword("GCCCLD");
        trie.addKeyword("GCCCMD");
        trie.addKeyword("GCCCPCCD");
        trie.addKeyword("GCCCWDWD");
        trie.addKeyword("GCCD");
        trie.addKeyword("GCCDCCCCD");
        trie.addKeyword("GCCDCCCD");
        trie.addKeyword("GCCDCCCDCD");
        trie.addKeyword("GCCDCCD");
        trie.addKeyword("GCCDCD");
        trie.addKeyword("GCCDCID");
        trie.addKeyword("GCCDCJCD");
        trie.addKeyword("GCCDCPCD");
        trie.addKeyword("GCCDD");
        trie.addKeyword("GCCDDCCCD");
        trie.addKeyword("GCCDDCCD");
        trie.addKeyword("GCCDDD");
        trie.addKeyword("GCCDFD");
        trie.addKeyword("GCCDGCCD");
        trie.addKeyword("GCCDGD");
        trie.addKeyword("GCCDGGDCD");
        trie.addKeyword("GCCDID");
        trie.addKeyword("GCCDJCD");
        trie.addKeyword("GCCDJD");
        trie.addKeyword("GCCDLDD");
        trie.addKeyword("GCCDLJCD");
        trie.addKeyword("GCCDMJD");
        trie.addKeyword("GCCDMJMMCD");
        trie.addKeyword("GCCDMJMMD");
        trie.addKeyword("GCCDMMD");
        trie.addKeyword("GCCDPD");
        trie.addKeyword("GCCFCD");
        trie.addKeyword("GCCFDD");
        trie.addKeyword("GCCFJPD");
        trie.addKeyword("GCCFPD");
        trie.addKeyword("GCCGCCCD");
        trie.addKeyword("GCCGCCD");
        trie.addKeyword("GCCGCD");
        trie.addKeyword("GCCGCDD");
        trie.addKeyword("GCCGD");
        trie.addKeyword("GCCGGCGD");
        trie.addKeyword("GCCGGDD");
        trie.addKeyword("GCCICCDCCD");
        trie.addKeyword("GCCICD");
        trie.addKeyword("GCCID");
        trie.addKeyword("GCCIDD");
        trie.addKeyword("GCCJCCCD");
        trie.addKeyword("GCCJCCCID");
        trie.addKeyword("GCCJCCD");
        trie.addKeyword("GCCJCD");
        trie.addKeyword("GCCJCJD");
        trie.addKeyword("GCCJD");
        trie.addKeyword("GCCJICD");
        trie.addKeyword("GCCJID");
        trie.addKeyword("GCCJPCD");
        trie.addKeyword("GCCJPD");
        trie.addKeyword("GCCKD");
        trie.addKeyword("GCCLCCD");
        trie.addKeyword("GCCLCD");
        trie.addKeyword("GCCLCGCD");
        trie.addKeyword("GCCLD");
        trie.addKeyword("GCCMCD");
        trie.addKeyword("GCCMD");
        trie.addKeyword("GCCMPD");
        trie.addKeyword("GCCPCCCCD");
        trie.addKeyword("GCCPCCCID");
        trie.addKeyword("GCCPCCD");
        trie.addKeyword("GCCPCD");
        trie.addKeyword("GCCPD");
        trie.addKeyword("GCCPDD");
        trie.addKeyword("GCCPFWCJD");
        trie.addKeyword("GCCPJD");
        trie.addKeyword("GCCWCCWCD");
        trie.addKeyword("GCCWCDWCD");
        trie.addKeyword("GCCWDWCCD");
        trie.addKeyword("GCCWDWD");
        trie.addKeyword("GCD");
        trie.addKeyword("GCDCCCCD");
        trie.addKeyword("GCDCCCCPD");
        trie.addKeyword("GCDCCCD");
        trie.addKeyword("GCDCCD");
        trie.addKeyword("GCDCCDCD");
        trie.addKeyword("GCDCCDD");
        trie.addKeyword("GCDCCDID");
        trie.addKeyword("GCDCCJCD");
        trie.addKeyword("GCDCCJD");
        trie.addKeyword("GCDCD");
        trie.addKeyword("GCDCDD");
        trie.addKeyword("GCDCDICD");
        trie.addKeyword("GCDCGCD");
        trie.addKeyword("GCDCGD");
        trie.addKeyword("GCDCGMCD");
        trie.addKeyword("GCDCID");
        trie.addKeyword("GCDCJCD");
        trie.addKeyword("GCDCJD");
        trie.addKeyword("GCDCLDD");
        trie.addKeyword("GCDCMCD");
        trie.addKeyword("GCDCMD");
        trie.addKeyword("GCDCMDCD");
        trie.addKeyword("GCDCMDD");
        trie.addKeyword("GCDCMDID");
        trie.addKeyword("GCDCPD");
        trie.addKeyword("GCDD");
        trie.addKeyword("GCDDCD");
        trie.addKeyword("GCDDD");
        trie.addKeyword("GCDDMCD");
        trie.addKeyword("GCDFD");
        trie.addKeyword("GCDFGCD");
        trie.addKeyword("GCDFWFD");
        trie.addKeyword("GCDGCCCCCD");
        trie.addKeyword("GCDGCCD");
        trie.addKeyword("GCDGCD");
        trie.addKeyword("GCDGD");
        trie.addKeyword("GCDGDD");
        trie.addKeyword("GCDGGD");
        trie.addKeyword("GCDGLCCD");
        trie.addKeyword("GCDGLJPCD");
        trie.addKeyword("GCDICCCCD");
        trie.addKeyword("GCDICCD");
        trie.addKeyword("GCDICD");
        trie.addKeyword("GCDID");
        trie.addKeyword("GCDIDD");
        trie.addKeyword("GCDJCCD");
        trie.addKeyword("GCDJCD");
        trie.addKeyword("GCDJCDGPD");
        trie.addKeyword("GCDJD");
        trie.addKeyword("GCDJJD");
        trie.addKeyword("GCDKCDCD");
        trie.addKeyword("GCDLCCCD");
        trie.addKeyword("GCDLD");
        trie.addKeyword("GCDLGCCCCD");
        trie.addKeyword("GCDLGCD");
        trie.addKeyword("GCDLPD");
        trie.addKeyword("GCDMCD");
        trie.addKeyword("GCDMCDD");
        trie.addKeyword("GCDMD");
        trie.addKeyword("GCDMDD");
        trie.addKeyword("GCDMJD");
        trie.addKeyword("GCDPCD");
        trie.addKeyword("GCDPD");
        trie.addKeyword("GCDWFWD");
        trie.addKeyword("GCDWGWCD");
        trie.addKeyword("GCDWGWD");
        trie.addKeyword("GCFCCD");
        trie.addKeyword("GCFCCJFGDD");
        trie.addKeyword("GCFCD");
        trie.addKeyword("GCFD");
        trie.addKeyword("GCFDD");
        trie.addKeyword("GCFFD");
        trie.addKeyword("GCFID");
        trie.addKeyword("GCFJCCD");
        trie.addKeyword("GCFPCD");
        trie.addKeyword("GCFPD");
        trie.addKeyword("GCFWGCCD");
        trie.addKeyword("GCFWGCCDD");
        trie.addKeyword("GCFWGJCD");
        trie.addKeyword("GCGCCCD");
        trie.addKeyword("GCGCCD");
        trie.addKeyword("GCGCD");
        trie.addKeyword("GCGCID");
        trie.addKeyword("GCGCLD");
        trie.addKeyword("GCGCPPCCD");
        trie.addKeyword("GCGD");
        trie.addKeyword("GCGDD");
        trie.addKeyword("GCGGCD");
        trie.addKeyword("GCGGCGD");
        trie.addKeyword("GCGGD");
        trie.addKeyword("GCGICD");
        trie.addKeyword("GCGID");
        trie.addKeyword("GCGJCCD");
        trie.addKeyword("GCGPCCD");
        trie.addKeyword("GCICCCCD");
        trie.addKeyword("GCICCCD");
        trie.addKeyword("GCICCD");
        trie.addKeyword("GCICD");
        trie.addKeyword("GCICDD");
        trie.addKeyword("GCID");
        trie.addKeyword("GCIDD");
        trie.addKeyword("GCIDID");
        trie.addKeyword("GCIFCCD");
        trie.addKeyword("GCIID");
        trie.addKeyword("GCIJCD");
        trie.addKeyword("GCIJD");
        trie.addKeyword("GCIJICD");
        trie.addKeyword("GCIPCD");
        trie.addKeyword("GCIPD");
        trie.addKeyword("GCIWGIIWD");
        trie.addKeyword("GCJCCCCD");
        trie.addKeyword("GCJCCCD");
        trie.addKeyword("GCJCCD");
        trie.addKeyword("GCJCD");
        trie.addKeyword("GCJCGD");
        trie.addKeyword("GCJCID");
        trie.addKeyword("GCJCIID");
        trie.addKeyword("GCJCPD");
        trie.addKeyword("GCJD");
        trie.addKeyword("GCJDCCD");
        trie.addKeyword("GCJDCD");
        trie.addKeyword("GCJDD");
        trie.addKeyword("GCJDID");
        trie.addKeyword("GCJFD");
        trie.addKeyword("GCJGD");
        trie.addKeyword("GCJICD");
        trie.addKeyword("GCJID");
        trie.addKeyword("GCJJCCD");
        trie.addKeyword("GCJJCD");
        trie.addKeyword("GCJJD");
        trie.addKeyword("GCJJGD");
        trie.addKeyword("GCJKCD");
        trie.addKeyword("GCJLCCD");
        trie.addKeyword("GCJMD");
        trie.addKeyword("GCJPCCGJLFD");
        trie.addKeyword("GCJPD");
        trie.addKeyword("GCJWCCJCD");
        trie.addKeyword("GCKCCD");
        trie.addKeyword("GCKD");
        trie.addKeyword("GCLCCCD");
        trie.addKeyword("GCLCCD");
        trie.addKeyword("GCLCD");
        trie.addKeyword("GCLD");
        trie.addKeyword("GCLDD");
        trie.addKeyword("GCLGGCD");
        trie.addKeyword("GCMCCD");
        trie.addKeyword("GCMCD");
        trie.addKeyword("GCMD");
        trie.addKeyword("GCMDD");
        trie.addKeyword("GCMPCD");
        trie.addKeyword("GCMPMD");
        trie.addKeyword("GCPCCCCD");
        trie.addKeyword("GCPCCCD");
        trie.addKeyword("GCPCCD");
        trie.addKeyword("GCPCCDD");
        trie.addKeyword("GCPCD");
        trie.addKeyword("GCPCDD");
        trie.addKeyword("GCPCKCD");
        trie.addKeyword("GCPD");
        trie.addKeyword("GCPDCCD");
        trie.addKeyword("GCPDD");
        trie.addKeyword("GCPFD");
        trie.addKeyword("GCPICCCD");
        trie.addKeyword("GCPJCCD");
        trie.addKeyword("GCPJCD");
        trie.addKeyword("GCPJD");
        trie.addKeyword("GCPJDCD");
        trie.addKeyword("GCPJJCD");
        trie.addKeyword("GCPJJDD");
        trie.addKeyword("GCPJPD");
        trie.addKeyword("GCPPCCD");
        trie.addKeyword("GCPPD");
        trie.addKeyword("GCPPPD");
        trie.addKeyword("GCWCWCJD");
        trie.addKeyword("GCWCWD");
        trie.addKeyword("GCWDWCDD");
        trie.addKeyword("GCWDWD");
        trie.addKeyword("GCWGWDD");
        trie.addKeyword("GD");
        trie.addKeyword("GDCCCCCCD");
        trie.addKeyword("GDCCCCCD");
        trie.addKeyword("GDCCCCD");
        trie.addKeyword("GDCCCCPD");
        trie.addKeyword("GDCCCD");
        trie.addKeyword("GDCCCDD");
        trie.addKeyword("GDCCCGCCD");
        trie.addKeyword("GDCCCJCD");
        trie.addKeyword("GDCCCJD");
        trie.addKeyword("GDCCCJDCD");
        trie.addKeyword("GDCCD");
        trie.addKeyword("GDCCDCD");
        trie.addKeyword("GDCCDCDD");
        trie.addKeyword("GDCCDD");
        trie.addKeyword("GDCCID");
        trie.addKeyword("GDCCJD");
        trie.addKeyword("GDCCPCD");
        trie.addKeyword("GDCD");
        trie.addKeyword("GDCDCCD");
        trie.addKeyword("GDCDCD");
        trie.addKeyword("GDCDD");
        trie.addKeyword("GDCDICD");
        trie.addKeyword("GDCDPD");
        trie.addKeyword("GDCFD");
        trie.addKeyword("GDCGCCD");
        trie.addKeyword("GDCGD");
        trie.addKeyword("GDCGPPCCD");
        trie.addKeyword("GDCID");
        trie.addKeyword("GDCIDD");
        trie.addKeyword("GDCJCCD");
        trie.addKeyword("GDCJD");
        trie.addKeyword("GDCLD");
        trie.addKeyword("GDCMD");
        trie.addKeyword("GDCPD");
        trie.addKeyword("GDCPID");
        trie.addKeyword("GDCPJD");
        trie.addKeyword("GDD");
        trie.addKeyword("GDDCCCCD");
        trie.addKeyword("GDDCCCD");
        trie.addKeyword("GDDCCD");
        trie.addKeyword("GDDCD");
        trie.addKeyword("GDDCDD");
        trie.addKeyword("GDDCFD");
        trie.addKeyword("GDDCFDCD");
        trie.addKeyword("GDDCMD");
        trie.addKeyword("GDDD");
        trie.addKeyword("GDDDCD");
        trie.addKeyword("GDDID");
        trie.addKeyword("GDDPPD");
        trie.addKeyword("GDDPPLD");
        trie.addKeyword("GDFCCD");
        trie.addKeyword("GDFCD");
        trie.addKeyword("GDFD");
        trie.addKeyword("GDFFD");
        trie.addKeyword("GDFGD");
        trie.addKeyword("GDGCCCD");
        trie.addKeyword("GDGCCD");
        trie.addKeyword("GDGCD");
        trie.addKeyword("GDGD");
        trie.addKeyword("GDGDCD");
        trie.addKeyword("GDGDD");
        trie.addKeyword("GDGDFID");
        trie.addKeyword("GDGJCCD");
        trie.addKeyword("GDGMD");
        trie.addKeyword("GDICCD");
        trie.addKeyword("GDICD");
        trie.addKeyword("GDID");
        trie.addKeyword("GDIDCD");
        trie.addKeyword("GDIDD");
        trie.addKeyword("GDIGCD");
        trie.addKeyword("GDIID");
        trie.addKeyword("GDIPCD");
        trie.addKeyword("GDJCCCD");
        trie.addKeyword("GDJCCD");
        trie.addKeyword("GDJCD");
        trie.addKeyword("GDJD");
        trie.addKeyword("GDJICD");
        trie.addKeyword("GDJJD");
        trie.addKeyword("GDJJJD");
        trie.addKeyword("GDJPCD");
        trie.addKeyword("GDJPDD");
        trie.addKeyword("GDLCCCCCD");
        trie.addKeyword("GDLCID");
        trie.addKeyword("GDLD");
        trie.addKeyword("GDLJD");
        trie.addKeyword("GDLJDD");
        trie.addKeyword("GDMCD");
        trie.addKeyword("GDMD");
        trie.addKeyword("GDMDCD");
        trie.addKeyword("GDMDD");
        trie.addKeyword("GDMJD");
        trie.addKeyword("GDMJMMD");
        trie.addKeyword("GDMPD");
        trie.addKeyword("GDPCCCCCD");
        trie.addKeyword("GDPCCD");
        trie.addKeyword("GDPCD");
        trie.addKeyword("GDPD");
        trie.addKeyword("GDPGCD");
        trie.addKeyword("GDPID");
        trie.addKeyword("GDPJCD");
        trie.addKeyword("GDPJD");
        trie.addKeyword("GDPPD");
        trie.addKeyword("GDPPJD");
        trie.addKeyword("GDWDWCCD");
        trie.addKeyword("GDWDWCCDD");
        trie.addKeyword("GDWDWD");
        trie.addKeyword("GDWFWD");
        trie.addKeyword("GDWGWD");
        trie.addKeyword("GFCCCCCD");
        trie.addKeyword("GFCCCCD");
        trie.addKeyword("GFCCCCJD");
        trie.addKeyword("GFCCCD");
        trie.addKeyword("GFCCCID");
        trie.addKeyword("GFCCD");
        trie.addKeyword("GFCCDD");
        trie.addKeyword("GFCCFCD");
        trie.addKeyword("GFCCPD");
        trie.addKeyword("GFCCPGD");
        trie.addKeyword("GFCD");
        trie.addKeyword("GFCDCD");
        trie.addKeyword("GFCDD");
        trie.addKeyword("GFCID");
        trie.addKeyword("GFCJCD");
        trie.addKeyword("GFCJD");
        trie.addKeyword("GFCPCCD");
        trie.addKeyword("GFCPCD");
        trie.addKeyword("GFCPD");
        trie.addKeyword("GFCPJD");
        trie.addKeyword("GFCPJPD");
        trie.addKeyword("GFD");
        trie.addKeyword("GFDCCCD");
        trie.addKeyword("GFDCD");
        trie.addKeyword("GFDD");
        trie.addKeyword("GFFCCD");
        trie.addKeyword("GFFCD");
        trie.addKeyword("GFFD");
        trie.addKeyword("GFFPCGCD");
        trie.addKeyword("GFGCD");
        trie.addKeyword("GFGCID");
        trie.addKeyword("GFGD");
        trie.addKeyword("GFGJCD");
        trie.addKeyword("GFICCD");
        trie.addKeyword("GFICD");
        trie.addKeyword("GFID");
        trie.addKeyword("GFIICD");
        trie.addKeyword("GFJCCCD");
        trie.addKeyword("GFJCCD");
        trie.addKeyword("GFJCD");
        trie.addKeyword("GFJCDCD");
        trie.addKeyword("GFJD");
        trie.addKeyword("GFJJCCD");
        trie.addKeyword("GFJJD");
        trie.addKeyword("GFJJJCCD");
        trie.addKeyword("GFJJLJCLCD");
        trie.addKeyword("GFLD");
        trie.addKeyword("GFLPD");
        trie.addKeyword("GFMCD");
        trie.addKeyword("GFPCD");
        trie.addKeyword("GFPD");
        trie.addKeyword("GFPJCD");
        trie.addKeyword("GFPJD");
        trie.addKeyword("GFPJPD");
        trie.addKeyword("GFPPCCCD");
        trie.addKeyword("GFPPD");
        trie.addKeyword("GFWCJCPCCCWCCD");
        trie.addKeyword("GFWGWCD");
        trie.addKeyword("GGCCCCCD");
        trie.addKeyword("GGCCCCD");
        trie.addKeyword("GGCCCD");
        trie.addKeyword("GGCCCICD");
        trie.addKeyword("GGCCCID");
        trie.addKeyword("GGCCCWDWD");
        trie.addKeyword("GGCCD");
        trie.addKeyword("GGCCDCD");
        trie.addKeyword("GGCCDD");
        trie.addKeyword("GGCCGCD");
        trie.addKeyword("GGCCGD");
        trie.addKeyword("GGCCGJD");
        trie.addKeyword("GGCCJCD");
        trie.addKeyword("GGCCJD");
        trie.addKeyword("GGCD");
        trie.addKeyword("GGCDCCCCCD");
        trie.addKeyword("GGCDCCD");
        trie.addKeyword("GGCDCD");
        trie.addKeyword("GGCDD");
        trie.addKeyword("GGCDJD");
        trie.addKeyword("GGCFCCFCPD");
        trie.addKeyword("GGCFD");
        trie.addKeyword("GGCFJD");
        trie.addKeyword("GGCGCCCD");
        trie.addKeyword("GGCGCD");
        trie.addKeyword("GGCGD");
        trie.addKeyword("GGCGGD");
        trie.addKeyword("GGCICLCD");
        trie.addKeyword("GGCID");
        trie.addKeyword("GGCIJCD");
        trie.addKeyword("GGCJCCD");
        trie.addKeyword("GGCJCD");
        trie.addKeyword("GGCJD");
        trie.addKeyword("GGCJDDCD");
        trie.addKeyword("GGCJJCCD");
        trie.addKeyword("GGCJJD");
        trie.addKeyword("GGCJPCICCCD");
        trie.addKeyword("GGCJPD");
        trie.addKeyword("GGCLCD");
        trie.addKeyword("GGCLD");
        trie.addKeyword("GGCMD");
        trie.addKeyword("GGCPCCD");
        trie.addKeyword("GGCPCD");
        trie.addKeyword("GGCPD");
        trie.addKeyword("GGD");
        trie.addKeyword("GGDCCCD");
        trie.addKeyword("GGDCCD");
        trie.addKeyword("GGDCD");
        trie.addKeyword("GGDD");
        trie.addKeyword("GGDDCCD");
        trie.addKeyword("GGDDCD");
        trie.addKeyword("GGDDD");
        trie.addKeyword("GGDFCD");
        trie.addKeyword("GGDFD");
        trie.addKeyword("GGDGD");
        trie.addKeyword("GGDID");
        trie.addKeyword("GGDJCD");
        trie.addKeyword("GGDJD");
        trie.addKeyword("GGDJJD");
        trie.addKeyword("GGDPPJD");
        trie.addKeyword("GGFCCCD");
        trie.addKeyword("GGFCCD");
        trie.addKeyword("GGFCD");
        trie.addKeyword("GGFD");
        trie.addKeyword("GGFDD");
        trie.addKeyword("GGFFCD");
        trie.addKeyword("GGFFD");
        trie.addKeyword("GGFFDCD");
        trie.addKeyword("GGFFDD");
        trie.addKeyword("GGFGD");
        trie.addKeyword("GGFJCCD");
        trie.addKeyword("GGFJD");
        trie.addKeyword("GGFJDD");
        trie.addKeyword("GGFJJD");
        trie.addKeyword("GGFLD");
        trie.addKeyword("GGFPCFPCD");
        trie.addKeyword("GGGCCCCD");
        trie.addKeyword("GGGCCCD");
        trie.addKeyword("GGGCCD");
        trie.addKeyword("GGGCD");
        trie.addKeyword("GGGCDD");
        trie.addKeyword("GGGCGCD");
        trie.addKeyword("GGGCGD");
        trie.addKeyword("GGGCID");
        trie.addKeyword("GGGCJD");
        trie.addKeyword("GGGD");
        trie.addKeyword("GGGDCD");
        trie.addKeyword("GGGDD");
        trie.addKeyword("GGGFD");
        trie.addKeyword("GGGGCD");
        trie.addKeyword("GGGGD");
        trie.addKeyword("GGGGFJD");
        trie.addKeyword("GGGGICD");
        trie.addKeyword("GGGGJD");
        trie.addKeyword("GGGGJPD");
        trie.addKeyword("GGGGLD");
        trie.addKeyword("GGGGPCD");
        trie.addKeyword("GGGGPPD");
        trie.addKeyword("GGGICD");
        trie.addKeyword("GGGID");
        trie.addKeyword("GGGIDID");
        trie.addKeyword("GGGIGCJD");
        trie.addKeyword("GGGIJD");
        trie.addKeyword("GGGJCD");
        trie.addKeyword("GGGJD");
        trie.addKeyword("GGGJJCJD");
        trie.addKeyword("GGGJJD");
        trie.addKeyword("GGGJPCCD");
        trie.addKeyword("GGGLD");
        trie.addKeyword("GGGMD");
        trie.addKeyword("GGGPJD");
        trie.addKeyword("GGGWICWD");
        trie.addKeyword("GGICCCCD");
        trie.addKeyword("GGICCCD");
        trie.addKeyword("GGICCD");
        trie.addKeyword("GGICCGD");
        trie.addKeyword("GGICCLD");
        trie.addKeyword("GGICCPCCD");
        trie.addKeyword("GGICD");
        trie.addKeyword("GGICGCCCD");
        trie.addKeyword("GGICID");
        trie.addKeyword("GGICJD");
        trie.addKeyword("GGID");
        trie.addKeyword("GGIDCD");
        trie.addKeyword("GGIDD");
        trie.addKeyword("GGIFD");
        trie.addKeyword("GGIFJCD");
        trie.addKeyword("GGIFPD");
        trie.addKeyword("GGIGCCD");
        trie.addKeyword("GGIGD");
        trie.addKeyword("GGIICD");
        trie.addKeyword("GGIID");
        trie.addKeyword("GGIIPID");
        trie.addKeyword("GGIJCCD");
        trie.addKeyword("GGIJD");
        trie.addKeyword("GGIPCD");
        trie.addKeyword("GGIPD");
        trie.addKeyword("GGIPDD");
        trie.addKeyword("GGJCCCD");
        trie.addKeyword("GGJCCD");
        trie.addKeyword("GGJCCPCJCCD");
        trie.addKeyword("GGJCD");
        trie.addKeyword("GGJCWDWD");
        trie.addKeyword("GGJD");
        trie.addKeyword("GGJGCCCD");
        trie.addKeyword("GGJGCCD");
        trie.addKeyword("GGJGD");
        trie.addKeyword("GGJJD");
        trie.addKeyword("GGJJPCD");
        trie.addKeyword("GGJLD");
        trie.addKeyword("GGJPD");
        trie.addKeyword("GGJPDD");
        trie.addKeyword("GGKD");
        trie.addKeyword("GGKGD");
        trie.addKeyword("GGLCCCD");
        trie.addKeyword("GGLCD");
        trie.addKeyword("GGLCDD");
        trie.addKeyword("GGLCJD");
        trie.addKeyword("GGLCPD");
        trie.addKeyword("GGLD");
        trie.addKeyword("GGLFD");
        trie.addKeyword("GGLID");
        trie.addKeyword("GGLJD");
        trie.addKeyword("GGLLFD");
        trie.addKeyword("GGLPD");
        trie.addKeyword("GGMCD");
        trie.addKeyword("GGMCDD");
        trie.addKeyword("GGMD");
        trie.addKeyword("GGMJCD");
        trie.addKeyword("GGMLD");
        trie.addKeyword("GGMPCCD");
        trie.addKeyword("GGPCCCD");
        trie.addKeyword("GGPCCD");
        trie.addKeyword("GGPCD");
        trie.addKeyword("GGPCJCD");
        trie.addKeyword("GGPD");
        trie.addKeyword("GGPFD");
        trie.addKeyword("GGPICD");
        trie.addKeyword("GGPJCCCCD");
        trie.addKeyword("GGPJCD");
        trie.addKeyword("GGPJCDD");
        trie.addKeyword("GGPJD");
        trie.addKeyword("GGPLD");
        trie.addKeyword("GGPPCCD");
        trie.addKeyword("GGPPCD");
        trie.addKeyword("GGPPD");
        trie.addKeyword("GGPPJJD");
        trie.addKeyword("GGPPPCD");
        trie.addKeyword("GGWPCGWPJD");
        trie.addKeyword("GICCCCCCD");
        trie.addKeyword("GICCCCCD");
        trie.addKeyword("GICCCCD");
        trie.addKeyword("GICCCD");
        trie.addKeyword("GICCCDD");
        trie.addKeyword("GICCCJCD");
        trie.addKeyword("GICCD");
        trie.addKeyword("GICCDD");
        trie.addKeyword("GICCJD");
        trie.addKeyword("GICCLDD");
        trie.addKeyword("GICCPD");
        trie.addKeyword("GICD");
        trie.addKeyword("GICDCCCCD");
        trie.addKeyword("GICDCCD");
        trie.addKeyword("GICDCD");
        trie.addKeyword("GICDD");
        trie.addKeyword("GICDLPD");
        trie.addKeyword("GICDWCCWD");
        trie.addKeyword("GICGCCCCD");
        trie.addKeyword("GICGCCD");
        trie.addKeyword("GICGCJICD");
        trie.addKeyword("GICGD");
        trie.addKeyword("GICGGD");
        trie.addKeyword("GICGMMD");
        trie.addKeyword("GICGPCJD");
        trie.addKeyword("GICICCD");
        trie.addKeyword("GICICD");
        trie.addKeyword("GICID");
        trie.addKeyword("GICIGD");
        trie.addKeyword("GICIID");
        trie.addKeyword("GICJCCD");
        trie.addKeyword("GICJCD");
        trie.addKeyword("GICJD");
        trie.addKeyword("GICPCCCCD");
        trie.addKeyword("GICPD");
        trie.addKeyword("GICPICD");
        trie.addKeyword("GICPJD");
        trie.addKeyword("GID");
        trie.addKeyword("GIDCCCJCD");
        trie.addKeyword("GIDCCD");
        trie.addKeyword("GIDCD");
        trie.addKeyword("GIDD");
        trie.addKeyword("GIDDD");
        trie.addKeyword("GIDICCD");
        trie.addKeyword("GIDID");
        trie.addKeyword("GIDLPCD");
        trie.addKeyword("GIFCCD");
        trie.addKeyword("GIFD");
        trie.addKeyword("GIFICD");
        trie.addKeyword("GIFWFD");
        trie.addKeyword("GIGCCD");
        trie.addKeyword("GIGCD");
        trie.addKeyword("GIGCGCD");
        trie.addKeyword("GIGCJD");
        trie.addKeyword("GIGCPD");
        trie.addKeyword("GIGD");
        trie.addKeyword("GIGGD");
        trie.addKeyword("GIGICD");
        trie.addKeyword("GIGID");
        trie.addKeyword("GIGJPCD");
        trie.addKeyword("GIICCCCD");
        trie.addKeyword("GIICCD");
        trie.addKeyword("GIICD");
        trie.addKeyword("GIID");
        trie.addKeyword("GIIGD");
        trie.addKeyword("GIIID");
        trie.addKeyword("GIIJCCCD");
        trie.addKeyword("GIIJCD");
        trie.addKeyword("GIJCCCCCD");
        trie.addKeyword("GIJCCCCD");
        trie.addKeyword("GIJCCCD");
        trie.addKeyword("GIJCCD");
        trie.addKeyword("GIJCD");
        trie.addKeyword("GIJCPD");
        trie.addKeyword("GIJD");
        trie.addKeyword("GIJDD");
        trie.addKeyword("GIJID");
        trie.addKeyword("GIJJCCD");
        trie.addKeyword("GIJJCD");
        trie.addKeyword("GIJLD");
        trie.addKeyword("GIJPD");
        trie.addKeyword("GIJPDCD");
        trie.addKeyword("GIKD");
        trie.addKeyword("GILCCCCDD");
        trie.addKeyword("GILCCD");
        trie.addKeyword("GILCD");
        trie.addKeyword("GILD");
        trie.addKeyword("GILID");
        trie.addKeyword("GILPMD");
        trie.addKeyword("GIMCCD");
        trie.addKeyword("GIMCD");
        trie.addKeyword("GIMD");
        trie.addKeyword("GIMJCD");
        trie.addKeyword("GIMJD");
        trie.addKeyword("GIMPCCD");
        trie.addKeyword("GIPCCCCD");
        trie.addKeyword("GIPCCCD");
        trie.addKeyword("GIPCCD");
        trie.addKeyword("GIPCD");
        trie.addKeyword("GIPCMD");
        trie.addKeyword("GIPD");
        trie.addKeyword("GIPDCD");
        trie.addKeyword("GIPDD");
        trie.addKeyword("GIPICD");
        trie.addKeyword("GIPJCCD");
        trie.addKeyword("GIPJCD");
        trie.addKeyword("GIPPCD");
        trie.addKeyword("GIPPD");
        trie.addKeyword("GIWDCCWCD");
        trie.addKeyword("GIWDWD");
        trie.addKeyword("GIWGWCD");
        trie.addKeyword("GJCCCCCD");
        trie.addKeyword("GJCCCCD");
        trie.addKeyword("GJCCCD");
        trie.addKeyword("GJCCCDCDCD");
        trie.addKeyword("GJCCCDD");
        trie.addKeyword("GJCCD");
        trie.addKeyword("GJCCDCD");
        trie.addKeyword("GJCCDD");
        trie.addKeyword("GJCCFD");
        trie.addKeyword("GJCCGJPD");
        trie.addKeyword("GJCCICCD");
        trie.addKeyword("GJCCJCD");
        trie.addKeyword("GJCCJD");
        trie.addKeyword("GJCD");
        trie.addKeyword("GJCDCCD");
        trie.addKeyword("GJCDCJCCD");
        trie.addKeyword("GJCDD");
        trie.addKeyword("GJCDJCD");
        trie.addKeyword("GJCDPD");
        trie.addKeyword("GJCGCD");
        trie.addKeyword("GJCGD");
        trie.addKeyword("GJCGPJCCD");
        trie.addKeyword("GJCICCCD");
        trie.addKeyword("GJCICD");
        trie.addKeyword("GJCID");
        trie.addKeyword("GJCJCCD");
        trie.addKeyword("GJCJCD");
        trie.addKeyword("GJCJD");
        trie.addKeyword("GJCJJCCCCD");
        trie.addKeyword("GJCJJCD");
        trie.addKeyword("GJCJPD");
        trie.addKeyword("GJCJPPCD");
        trie.addKeyword("GJCLD");
        trie.addKeyword("GJCLJCCCD");
        trie.addKeyword("GJCMD");
        trie.addKeyword("GJCPD");
        trie.addKeyword("GJCPJD");
        trie.addKeyword("GJCPPD");
        trie.addKeyword("GJD");
        trie.addKeyword("GJDCCCD");
        trie.addKeyword("GJDCCD");
        trie.addKeyword("GJDCD");
        trie.addKeyword("GJDD");
        trie.addKeyword("GJDICD");
        trie.addKeyword("GJDID");
        trie.addKeyword("GJDLCD");
        trie.addKeyword("GJDPCD");
        trie.addKeyword("GJFCCD");
        trie.addKeyword("GJFCD");
        trie.addKeyword("GJFD");
        trie.addKeyword("GJFFD");
        trie.addKeyword("GJFGD");
        trie.addKeyword("GJFICD");
        trie.addKeyword("GJGCD");
        trie.addKeyword("GJGD");
        trie.addKeyword("GJGPCD");
        trie.addKeyword("GJICCCD");
        trie.addKeyword("GJICCD");
        trie.addKeyword("GJICD");
        trie.addKeyword("GJID");
        trie.addKeyword("GJIID");
        trie.addKeyword("GJJCCCD");
        trie.addKeyword("GJJCCD");
        trie.addKeyword("GJJCCDD");
        trie.addKeyword("GJJCD");
        trie.addKeyword("GJJCJCCCD");
        trie.addKeyword("GJJCJCCD");
        trie.addKeyword("GJJCPCD");
        trie.addKeyword("GJJD");
        trie.addKeyword("GJJDCD");
        trie.addKeyword("GJJDD");
        trie.addKeyword("GJJFCCD");
        trie.addKeyword("GJJFD");
        trie.addKeyword("GJJGD");
        trie.addKeyword("GJJJCD");
        trie.addKeyword("GJJJD");
        trie.addKeyword("GJJJICD");
        trie.addKeyword("GJJJJCCD");
        trie.addKeyword("GJJJJD");
        trie.addKeyword("GJJPCCCD");
        trie.addKeyword("GJJPCCD");
        trie.addKeyword("GJJPCID");
        trie.addKeyword("GJJPPD");
        trie.addKeyword("GJLCCCCD");
        trie.addKeyword("GJLCD");
        trie.addKeyword("GJLCDD");
        trie.addKeyword("GJLD");
        trie.addKeyword("GJMCCD");
        trie.addKeyword("GJMD");
        trie.addKeyword("GJPCCCCD");
        trie.addKeyword("GJPCCCD");
        trie.addKeyword("GJPCCD");
        trie.addKeyword("GJPCD");
        trie.addKeyword("GJPCDD");
        trie.addKeyword("GJPCJCD");
        trie.addKeyword("GJPCLCD");
        trie.addKeyword("GJPCMD");
        trie.addKeyword("GJPD");
        trie.addKeyword("GJPDD");
        trie.addKeyword("GJPGCCD");
        trie.addKeyword("GJPGD");
        trie.addKeyword("GJPICCD");
        trie.addKeyword("GJPICD");
        trie.addKeyword("GJPICDD");
        trie.addKeyword("GJPJCCD");
        trie.addKeyword("GJPJD");
        trie.addKeyword("GJPJPD");
        trie.addKeyword("GJPLCD");
        trie.addKeyword("GJPPJD");
        trie.addKeyword("GKCCCD");
        trie.addKeyword("GKCCD");
        trie.addKeyword("GKCCPD");
        trie.addKeyword("GKCD");
        trie.addKeyword("GKCDCD");
        trie.addKeyword("GKCDD");
        trie.addKeyword("GKCDJCD");
        trie.addKeyword("GKCJCD");
        trie.addKeyword("GKCMD");
        trie.addKeyword("GKD");
        trie.addKeyword("GKDD");
        trie.addKeyword("GKJJD");
        trie.addKeyword("GLCCCCCCD");
        trie.addKeyword("GLCCCCD");
        trie.addKeyword("GLCCCD");
        trie.addKeyword("GLCCD");
        trie.addKeyword("GLCCDD");
        trie.addKeyword("GLCCJCCCD");
        trie.addKeyword("GLCCJCCD");
        trie.addKeyword("GLCD");
        trie.addKeyword("GLCDD");
        trie.addKeyword("GLCDGCCD");
        trie.addKeyword("GLCGCJCD");
        trie.addKeyword("GLCGD");
        trie.addKeyword("GLCGDD");
        trie.addKeyword("GLCJD");
        trie.addKeyword("GLCJJCCCCCD");
        trie.addKeyword("GLCLD");
        trie.addKeyword("GLCMD");
        trie.addKeyword("GLCPCCD");
        trie.addKeyword("GLCPD");
        trie.addKeyword("GLD");
        trie.addKeyword("GLDCD");
        trie.addKeyword("GLDCMD");
        trie.addKeyword("GLDCMDCD");
        trie.addKeyword("GLDCMDD");
        trie.addKeyword("GLDD");
        trie.addKeyword("GLDDCKCD");
        trie.addKeyword("GLFCD");
        trie.addKeyword("GLFCFD");
        trie.addKeyword("GLFGCD");
        trie.addKeyword("GLGCD");
        trie.addKeyword("GLGD");
        trie.addKeyword("GLGPJD");
        trie.addKeyword("GLICCD");
        trie.addKeyword("GLICD");
        trie.addKeyword("GLID");
        trie.addKeyword("GLJCCCD");
        trie.addKeyword("GLJCCD");
        trie.addKeyword("GLJCD");
        trie.addKeyword("GLJCICCD");
        trie.addKeyword("GLJD");
        trie.addKeyword("GLJFCD");
        trie.addKeyword("GLJGD");
        trie.addKeyword("GLJICCD");
        trie.addKeyword("GLJID");
        trie.addKeyword("GLJJD");
        trie.addKeyword("GLJPCCD");
        trie.addKeyword("GLJPCICD");
        trie.addKeyword("GLJPJCCD");
        trie.addKeyword("GLJWGWCD");
        trie.addKeyword("GLLCCCD");
        trie.addKeyword("GLLCID");
        trie.addKeyword("GLPCCCD");
        trie.addKeyword("GLPCCD");
        trie.addKeyword("GLPCD");
        trie.addKeyword("GLPCDD");
        trie.addKeyword("GLPCPCCD");
        trie.addKeyword("GLPD");
        trie.addKeyword("GLPDD");
        trie.addKeyword("GLPGCD");
        trie.addKeyword("GLPJD");
        trie.addKeyword("GLPLJCCCD");
        trie.addKeyword("GLPLJCD");
        trie.addKeyword("GLPPCCCCD");
        trie.addKeyword("GLPPCCD");
        trie.addKeyword("GLPPCD");
        trie.addKeyword("GMCCCCD");
        trie.addKeyword("GMCCCD");
        trie.addKeyword("GMCCD");
        trie.addKeyword("GMCCID");
        trie.addKeyword("GMCD");
        trie.addKeyword("GMCDCCCD");
        trie.addKeyword("GMCDCCD");
        trie.addKeyword("GMCDCD");
        trie.addKeyword("GMCDD");
        trie.addKeyword("GMCDMCD");
        trie.addKeyword("GMCGD");
        trie.addKeyword("GMCJCD");
        trie.addKeyword("GMCMD");
        trie.addKeyword("GMCMJD");
        trie.addKeyword("GMD");
        trie.addKeyword("GMDCD");
        trie.addKeyword("GMDD");
        trie.addKeyword("GMDICD");
        trie.addKeyword("GMDID");
        trie.addKeyword("GMGJCD");
        trie.addKeyword("GMGJJD");
        trie.addKeyword("GMICD");
        trie.addKeyword("GMID");
        trie.addKeyword("GMIPJCCD");
        trie.addKeyword("GMJCCD");
        trie.addKeyword("GMJCD");
        trie.addKeyword("GMJD");
        trie.addKeyword("GMJDD");
        trie.addKeyword("GMJICCCD");
        trie.addKeyword("GMJMJFCD");
        trie.addKeyword("GMJPCD");
        trie.addKeyword("GMJPLCCD");
        trie.addKeyword("GMLD");
        trie.addKeyword("GMLDCD");
        trie.addKeyword("GMLGCD");
        trie.addKeyword("GMLID");
        trie.addKeyword("GMLLD");
        trie.addKeyword("GMMCCCD");
        trie.addKeyword("GMMD");
        trie.addKeyword("GMMGD");
        trie.addKeyword("GMMLCCD");
        trie.addKeyword("GMMPCD");
        trie.addKeyword("GMMPD");
        trie.addKeyword("GMPCCD");
        trie.addKeyword("GMPCD");
        trie.addKeyword("GMPD");
        trie.addKeyword("GMPDCD");
        trie.addKeyword("GMPDD");
        trie.addKeyword("GMPJCD");
        trie.addKeyword("GPCCCCCCD");
        trie.addKeyword("GPCCCCD");
        trie.addKeyword("GPCCCCID");
        trie.addKeyword("GPCCCD");
        trie.addKeyword("GPCCD");
        trie.addKeyword("GPCCDCCD");
        trie.addKeyword("GPCCDD");
        trie.addKeyword("GPCCDDD");
        trie.addKeyword("GPCD");
        trie.addKeyword("GPCDCCD");
        trie.addKeyword("GPCDCD");
        trie.addKeyword("GPCDD");
        trie.addKeyword("GPCFDCCD");
        trie.addKeyword("GPCFDD");
        trie.addKeyword("GPCGD");
        trie.addKeyword("GPCICCD");
        trie.addKeyword("GPCID");
        trie.addKeyword("GPCIJD");
        trie.addKeyword("GPCJCCCD");
        trie.addKeyword("GPCJCCD");
        trie.addKeyword("GPCJCD");
        trie.addKeyword("GPCPID");
        trie.addKeyword("GPCWDWCD");
        trie.addKeyword("GPD");
        trie.addKeyword("GPDCCD");
        trie.addKeyword("GPDCD");
        trie.addKeyword("GPDD");
        trie.addKeyword("GPFCCD");
        trie.addKeyword("GPFCD");
        trie.addKeyword("GPFD");
        trie.addKeyword("GPFFCD");
        trie.addKeyword("GPGCCCD");
        trie.addKeyword("GPGD");
        trie.addKeyword("GPGJCJCCCCD");
        trie.addKeyword("GPGPJD");
        trie.addKeyword("GPICCCCD");
        trie.addKeyword("GPICCCD");
        trie.addKeyword("GPICCD");
        trie.addKeyword("GPICD");
        trie.addKeyword("GPID");
        trie.addKeyword("GPIDCD");
        trie.addKeyword("GPIDD");
        trie.addKeyword("GPJCCCCCD");
        trie.addKeyword("GPJCCCD");
        trie.addKeyword("GPJCCD");
        trie.addKeyword("GPJCD");
        trie.addKeyword("GPJCDD");
        trie.addKeyword("GPJCJCCD");
        trie.addKeyword("GPJD");
        trie.addKeyword("GPJDCCD");
        trie.addKeyword("GPJDCD");
        trie.addKeyword("GPJDD");
        trie.addKeyword("GPJFICD");
        trie.addKeyword("GPJFID");
        trie.addKeyword("GPJGD");
        trie.addKeyword("GPJJCCD");
        trie.addKeyword("GPJJCD");
        trie.addKeyword("GPJLCD");
        trie.addKeyword("GPJWDWD");
        trie.addKeyword("GPLCWCWCWD");
        trie.addKeyword("GPLD");
        trie.addKeyword("GPLJCCD");
        trie.addKeyword("GPMJCGD");
        trie.addKeyword("GPMMD");
        trie.addKeyword("GPMPCCD");
        trie.addKeyword("GPPCCCCD");
        trie.addKeyword("GPPCCCD");
        trie.addKeyword("GPPCCD");
        trie.addKeyword("GPPCD");
        trie.addKeyword("GPPCDCCD");
        trie.addKeyword("GPPCDD");
        trie.addKeyword("GPPCLD");
        trie.addKeyword("GPPD");
        trie.addKeyword("GPPDCD");
        trie.addKeyword("GPPDCDD");
        trie.addKeyword("GPPDD");
        trie.addKeyword("GPPGCD");
        trie.addKeyword("GPPICCD");
        trie.addKeyword("GPPID");
        trie.addKeyword("GPPJCD");
        trie.addKeyword("GPPJD");
        trie.addKeyword("GPPJDD");
        trie.addKeyword("GPPJJCCCCD");
        trie.addKeyword("GPPLD");
        trie.addKeyword("GPPPCCD");
        trie.addKeyword("GPPPCKCCD");
        trie.addKeyword("GPPPPCCD");
        trie.addKeyword("GWCPWD");
        trie.addKeyword("GWCWCCCD");
        trie.addKeyword("GWCWCD");
        trie.addKeyword("GWCWD");
        trie.addKeyword("GWCWPJCD");
        trie.addKeyword("GWD");
        trie.addKeyword("GWFCD");
        trie.addKeyword("GWGCCCD");
        trie.addKeyword("GWGCCD");
        trie.addKeyword("GWGCCWCD");
        trie.addKeyword("GWGCD");
        trie.addKeyword("GWGCWD");
        trie.addKeyword("GWGD");
        trie.addKeyword("GWGID");
        trie.addKeyword("GWGWCCCCD");
        trie.addKeyword("GWGWCCCD");
        trie.addKeyword("GWGWCD");
        trie.addKeyword("GWGWICD");
        trie.addKeyword("GWGWLCD");
        trie.addKeyword("GWICD");
        trie.addKeyword("GWICWD");
        trie.addKeyword("GWIWD");
        trie.addKeyword("GWJWD");
        trie.addKeyword("GWLJWCD");
        trie.addKeyword("GWPD");
        trie.addKeyword("GWPJD");
        trie.addKeyword("ICCCCCCD");
        trie.addKeyword("ICCCCCD");
        trie.addKeyword("ICCCCD");
        trie.addKeyword("ICCCCDD");
        trie.addKeyword("ICCCD");
        trie.addKeyword("ICCD");
        trie.addKeyword("ICCDCCD");
        trie.addKeyword("ICCDCD");
        trie.addKeyword("ICCDD");
        trie.addKeyword("ICCGCCD");
        trie.addKeyword("ICCGCIPD");
        trie.addKeyword("ICCGD");
        trie.addKeyword("ICCJD");
        trie.addKeyword("ICCPD");
        trie.addKeyword("ICCWDWCD");
        trie.addKeyword("ICD");
        trie.addKeyword("ICDD");
        trie.addKeyword("ICDID");
        trie.addKeyword("ICFD");
        trie.addKeyword("ICGCCCD");
        trie.addKeyword("ICGCD");
        trie.addKeyword("ICGFD");
        trie.addKeyword("ICGGCD");
        trie.addKeyword("ICGLCMD");
        trie.addKeyword("ICICD");
        trie.addKeyword("ICID");
        trie.addKeyword("ICIGD");
        trie.addKeyword("ICJCD");
        trie.addKeyword("ICJD");
        trie.addKeyword("ICJJD");
        trie.addKeyword("ICLJCD");
        trie.addKeyword("ICMCCCCD");
        trie.addKeyword("ICMD");
        trie.addKeyword("ICPCD");
        trie.addKeyword("ICPD");
        trie.addKeyword("ICPPD");
        trie.addKeyword("ICWGWCD");
        trie.addKeyword("ICWGWD");
        trie.addKeyword("ICWGWDCD");
        trie.addKeyword("ID");
        trie.addKeyword("IDCCCCD");
        trie.addKeyword("IDCCCD");
        trie.addKeyword("IDCCD");
        trie.addKeyword("IDCCGJID");
        trie.addKeyword("IDCCICD");
        trie.addKeyword("IDCCICDID");
        trie.addKeyword("IDCD");
        trie.addKeyword("IDCDCD");
        trie.addKeyword("IDCDD");
        trie.addKeyword("IDCFCD");
        trie.addKeyword("IDCGD");
        trie.addKeyword("IDCICD");
        trie.addKeyword("IDCID");
        trie.addKeyword("IDCJD");
        trie.addKeyword("IDCPCCCCCCD");
        trie.addKeyword("IDD");
        trie.addKeyword("IDGCCCD");
        trie.addKeyword("IDGCD");
        trie.addKeyword("IDID");
        trie.addKeyword("IDIDD");
        trie.addKeyword("IDJCD");
        trie.addKeyword("IDKCD");
        trie.addKeyword("IDPD");
        trie.addKeyword("IDWCWCCDD");
        trie.addKeyword("IFD");
        trie.addKeyword("IFWGWCD");
        trie.addKeyword("IGCCCD");
        trie.addKeyword("IGCCCDD");
        trie.addKeyword("IGCCD");
        trie.addKeyword("IGCD");
        trie.addKeyword("IGCDCD");
        trie.addKeyword("IGCDD");
        trie.addKeyword("IGCGCCD");
        trie.addKeyword("IGCGCD");
        trie.addKeyword("IGCID");
        trie.addKeyword("IGCJD");
        trie.addKeyword("IGCPD");
        trie.addKeyword("IGCWJWD");
        trie.addKeyword("IGD");
        trie.addKeyword("IGDD");
        trie.addKeyword("IGFCCD");
        trie.addKeyword("IGFCD");
        trie.addKeyword("IGFD");
        trie.addKeyword("IGGCD");
        trie.addKeyword("IGID");
        trie.addKeyword("IGJD");
        trie.addKeyword("IGLCD");
        trie.addKeyword("IGLD");
        trie.addKeyword("IGPCD");
        trie.addKeyword("IGPCDD");
        trie.addKeyword("IICCCD");
        trie.addKeyword("IICCD");
        trie.addKeyword("IICD");
        trie.addKeyword("IICGD");
        trie.addKeyword("IID");
        trie.addKeyword("IIGD");
        trie.addKeyword("IIGJCJCD");
        trie.addKeyword("IIIGCD");
        trie.addKeyword("IIPCD");
        trie.addKeyword("IJCCCCD");
        trie.addKeyword("IJCCCD");
        trie.addKeyword("IJCCD");
        trie.addKeyword("IJCD");
        trie.addKeyword("IJD");
        trie.addKeyword("IJDCCD");
        trie.addKeyword("IJGCD");
        trie.addKeyword("IJGD");
        trie.addKeyword("IJJCD");
        trie.addKeyword("IJJD");
        trie.addKeyword("IJJJCD");
        trie.addKeyword("IJPCDD");
        trie.addKeyword("IJWCFIWGD");
        trie.addKeyword("IJWCFWD");
        trie.addKeyword("IJWCPWGD");
        trie.addKeyword("IKCCCD");
        trie.addKeyword("ILCD");
        trie.addKeyword("ILD");
        trie.addKeyword("ILPCD");
        trie.addKeyword("ILPMD");
        trie.addKeyword("IMCCD");
        trie.addKeyword("IMCD");
        trie.addKeyword("IMD");
        trie.addKeyword("IMPD");
        trie.addKeyword("IPCCCD");
        trie.addKeyword("IPCCD");
        trie.addKeyword("IPCCID");
        trie.addKeyword("IPCCJD");
        trie.addKeyword("IPCD");
        trie.addKeyword("IPCID");
        trie.addKeyword("IPCJD");
        trie.addKeyword("IPCPD");
        trie.addKeyword("IPD");
        trie.addKeyword("IPFCD");
        trie.addKeyword("IPID");
        trie.addKeyword("IPIJD");
        trie.addKeyword("IPJCGD");
        trie.addKeyword("IPJD");
        trie.addKeyword("IPPCD");
        trie.addKeyword("JCCCCCCD");
        trie.addKeyword("JCCCCCD");
        trie.addKeyword("JCCCCD");
        trie.addKeyword("JCCCD");
        trie.addKeyword("JCCCJCD");
        trie.addKeyword("JCCD");
        trie.addKeyword("JCCID");
        trie.addKeyword("JCCJD");
        trie.addKeyword("JCCMCD");
        trie.addKeyword("JCD");
        trie.addKeyword("JCDCCD");
        trie.addKeyword("JCDCD");
        trie.addKeyword("JCDD");
        trie.addKeyword("JCDID");
        trie.addKeyword("JCFCD");
        trie.addKeyword("JCGCCCCD");
        trie.addKeyword("JCGCCCD");
        trie.addKeyword("JCGCCD");
        trie.addKeyword("JCGCD");
        trie.addKeyword("JCGD");
        trie.addKeyword("JCGJGD");
        trie.addKeyword("JCICCCD");
        trie.addKeyword("JCID");
        trie.addKeyword("JCIDD");
        trie.addKeyword("JCJCCCD");
        trie.addKeyword("JCJCCD");
        trie.addKeyword("JCJCD");
        trie.addKeyword("JCJD");
        trie.addKeyword("JCJDD");
        trie.addKeyword("JCJFD");
        trie.addKeyword("JCJJPCD");
        trie.addKeyword("JCJPID");
        trie.addKeyword("JCJWGWD");
        trie.addKeyword("JCLD");
        trie.addKeyword("JCMD");
        trie.addKeyword("JCMPD");
        trie.addKeyword("JCPJCID");
        trie.addKeyword("JCPJJCD");
        trie.addKeyword("JCPPCCCD");
        trie.addKeyword("JD");
        trie.addKeyword("JDCD");
        trie.addKeyword("JDCMD");
        trie.addKeyword("JDD");
        trie.addKeyword("JDGD");
        trie.addKeyword("JDID");
        trie.addKeyword("JDJD");
        trie.addKeyword("JDMD");
        trie.addKeyword("JFCD");
        trie.addKeyword("JFD");
        trie.addKeyword("JGCCCD");
        trie.addKeyword("JGCD");
        trie.addKeyword("JGD");
        trie.addKeyword("JGDCJD");
        trie.addKeyword("JGGD");
        trie.addKeyword("JGPD");
        trie.addKeyword("JICCCD");
        trie.addKeyword("JICD");
        trie.addKeyword("JID");
        trie.addKeyword("JIDD");
        trie.addKeyword("JIID");
        trie.addKeyword("JIJD");
        trie.addKeyword("JILD");
        trie.addKeyword("JJCCCD");
        trie.addKeyword("JJCCD");
        trie.addKeyword("JJCCPGD");
        trie.addKeyword("JJCD");
        trie.addKeyword("JJD");
        trie.addKeyword("JJDCJD");
        trie.addKeyword("JJDD");
        trie.addKeyword("JJGCCD");
        trie.addKeyword("JJGD");
        trie.addKeyword("JJICD");
        trie.addKeyword("JJID");
        trie.addKeyword("JJJCCCD");
        trie.addKeyword("JJJCD");
        trie.addKeyword("JJJCFCCCD");
        trie.addKeyword("JJJD");
        trie.addKeyword("JJJGD");
        trie.addKeyword("JJMCID");
        trie.addKeyword("JJPCD");
        trie.addKeyword("JJPD");
        trie.addKeyword("JJPPJLCD");
        trie.addKeyword("JJWFWCCJJD");
        trie.addKeyword("JJWGWCD");
        trie.addKeyword("JJWGWCDD");
        trie.addKeyword("JKCD");
        trie.addKeyword("JKD");
        trie.addKeyword("JLCCD");
        trie.addKeyword("JLCCDD");
        trie.addKeyword("JLCCJD");
        trie.addKeyword("JLCD");
        trie.addKeyword("JLCDD");
        trie.addKeyword("JLCMD");
        trie.addKeyword("JLCMDD");
        trie.addKeyword("JLD");
        trie.addKeyword("JLDD");
        trie.addKeyword("JLGCJD");
        trie.addKeyword("JLGJCCCJD");
        trie.addKeyword("JLJD");
        trie.addKeyword("JMCD");
        trie.addKeyword("JMD");
        trie.addKeyword("JMJD");
        trie.addKeyword("JMPD");
        trie.addKeyword("JPCCD");
        trie.addKeyword("JPCD");
        trie.addKeyword("JPCMD");
        trie.addKeyword("JPCMDPD");
        trie.addKeyword("JPD");
        trie.addKeyword("JPDCCCD");
        trie.addKeyword("JPDD");
        trie.addKeyword("JPDGCD");
        trie.addKeyword("JPFCCD");
        trie.addKeyword("JPFD");
        trie.addKeyword("JPICD");
        trie.addKeyword("JPID");
        trie.addKeyword("JPIID");
        trie.addKeyword("JPJD");
        trie.addKeyword("JPJJCCCFPCD");
        trie.addKeyword("JPMD");
        trie.addKeyword("JPMDCCD");
        trie.addKeyword("JPMDD");
        trie.addKeyword("JPPJD");
        trie.addKeyword("JPPJLCD");
        trie.addKeyword("KCCCCCD");
        trie.addKeyword("KCCCCD");
        trie.addKeyword("KCCCCDCD");
        trie.addKeyword("KCCCD");
        trie.addKeyword("KCCCDCD");
        trie.addKeyword("KCCCDD");
        trie.addKeyword("KCCCDDCCCD");
        trie.addKeyword("KCCCGD");
        trie.addKeyword("KCCD");
        trie.addKeyword("KCCDCCD");
        trie.addKeyword("KCCDCD");
        trie.addKeyword("KCCJD");
        trie.addKeyword("KCCJDID");
        trie.addKeyword("KCCPD");
        trie.addKeyword("KCD");
        trie.addKeyword("KCDCCCCD");
        trie.addKeyword("KCDCCD");
        trie.addKeyword("KCDCD");
        trie.addKeyword("KCDD");
        trie.addKeyword("KCDICD");
        trie.addKeyword("KCDJD");
        trie.addKeyword("KCGCCCD");
        trie.addKeyword("KCGCCCDD");
        trie.addKeyword("KCGCCD");
        trie.addKeyword("KCGCD");
        trie.addKeyword("KCGD");
        trie.addKeyword("KCGGGD");
        trie.addKeyword("KCICD");
        trie.addKeyword("KCID");
        trie.addKeyword("KCIDCD");
        trie.addKeyword("KCJCD");
        trie.addKeyword("KCJD");
        trie.addKeyword("KCKCD");
        trie.addKeyword("KCMD");
        trie.addKeyword("KCMDCD");
        trie.addKeyword("KCPD");
        trie.addKeyword("KCWGWD");
        trie.addKeyword("KD");
        trie.addKeyword("KDCCCD");
        trie.addKeyword("KDCD");
        trie.addKeyword("KDD");
        trie.addKeyword("KDICD");
        trie.addKeyword("KDLCCPD");
        trie.addKeyword("KFCD");
        trie.addKeyword("KFCDD");
        trie.addKeyword("KFD");
        trie.addKeyword("KFWFD");
        trie.addKeyword("KGCCCD");
        trie.addKeyword("KGCCD");
        trie.addKeyword("KGCD");
        trie.addKeyword("KGCDCCD");
        trie.addKeyword("KGDD");
        trie.addKeyword("KGGD");
        trie.addKeyword("KGJPD");
        trie.addKeyword("KICCD");
        trie.addKeyword("KICD");
        trie.addKeyword("KICDD");
        trie.addKeyword("KID");
        trie.addKeyword("KIDCCD");
        trie.addKeyword("KIDJCD");
        trie.addKeyword("KIGID");
        trie.addKeyword("KIMCD");
        trie.addKeyword("KIMD");
        trie.addKeyword("KIWGWD");
        trie.addKeyword("KJCCD");
        trie.addKeyword("KJCD");
        trie.addKeyword("KJD");
        trie.addKeyword("KJDD");
        trie.addKeyword("KJICCD");
        trie.addKeyword("KJJD");
        trie.addKeyword("KJJDCD");
        trie.addKeyword("KJJJD");
        trie.addKeyword("KJPD");
        trie.addKeyword("KLCCD");
        trie.addKeyword("KLD");
        trie.addKeyword("KMCCJCCD");
        trie.addKeyword("KMCD");
        trie.addKeyword("KMCDD");
        trie.addKeyword("KMD");
        trie.addKeyword("KMDCD");
        trie.addKeyword("KMDD");
        trie.addKeyword("KMMD");
        trie.addKeyword("KMMMD");
        trie.addKeyword("KPCCCD");
        trie.addKeyword("KPCCD");
        trie.addKeyword("KPCD");
        trie.addKeyword("KPD");
        trie.addKeyword("KPDD");
        trie.addKeyword("LCCCCD");
        trie.addKeyword("LCCCD");
        trie.addKeyword("LCCD");
        trie.addKeyword("LCCDD");
        trie.addKeyword("LCCDJCCD");
        trie.addKeyword("LCCGD");
        trie.addKeyword("LCCGID");
        trie.addKeyword("LCCID");
        trie.addKeyword("LCCPCD");
        trie.addKeyword("LCCWGWD");
        trie.addKeyword("LCD");
        trie.addKeyword("LCDCCD");
        trie.addKeyword("LCDCD");
        trie.addKeyword("LCDCDD");
        trie.addKeyword("LCDCDIGCD");
        trie.addKeyword("LCDD");
        trie.addKeyword("LCDFD");
        trie.addKeyword("LCDGDD");
        trie.addKeyword("LCDGID");
        trie.addKeyword("LCDID");
        trie.addKeyword("LCDLD");
        trie.addKeyword("LCDLDCD");
        trie.addKeyword("LCDLDD");
        trie.addKeyword("LCDMCDD");
        trie.addKeyword("LCDPD");
        trie.addKeyword("LCGD");
        trie.addKeyword("LCGDD");
        trie.addKeyword("LCICCWGWD");
        trie.addKeyword("LCID");
        trie.addKeyword("LCIGD");
        trie.addKeyword("LCJCD");
        trie.addKeyword("LCJD");
        trie.addKeyword("LCLD");
        trie.addKeyword("LCMCCD");
        trie.addKeyword("LCMCDD");
        trie.addKeyword("LCMCID");
        trie.addKeyword("LCMCMD");
        trie.addKeyword("LCMD");
        trie.addKeyword("LCMJCICD");
        trie.addKeyword("LCMJD");
        trie.addKeyword("LCPCJCD");
        trie.addKeyword("LCPD");
        trie.addKeyword("LCPMD");
        trie.addKeyword("LCPPCD");
        trie.addKeyword("LD");
        trie.addKeyword("LDCCD");
        trie.addKeyword("LDCD");
        trie.addKeyword("LDCLCD");
        trie.addKeyword("LDCLCDCD");
        trie.addKeyword("LDCPD");
        trie.addKeyword("LDD");
        trie.addKeyword("LDDD");
        trie.addKeyword("LDLCCCCD");
        trie.addKeyword("LFCD");
        trie.addKeyword("LFCFD");
        trie.addKeyword("LFD");
        trie.addKeyword("LFPPPCCD");
        trie.addKeyword("LGCD");
        trie.addKeyword("LGD");
        trie.addKeyword("LGGCCCD");
        trie.addKeyword("LGGCD");
        trie.addKeyword("LGJCD");
        trie.addKeyword("LGJLCD");
        trie.addKeyword("LGJLD");
        trie.addKeyword("LICCCD");
        trie.addKeyword("LICCD");
        trie.addKeyword("LICD");
        trie.addKeyword("LICLD");
        trie.addKeyword("LID");
        trie.addKeyword("LIGD");
        trie.addKeyword("LIPCCCD");
        trie.addKeyword("LIWGWCCCD");
        trie.addKeyword("LJCCCCD");
        trie.addKeyword("LJCCCCWGWD");
        trie.addKeyword("LJCCCD");
        trie.addKeyword("LJCCD");
        trie.addKeyword("LJCCDCCCD");
        trie.addKeyword("LJCCDCCD");
        trie.addKeyword("LJCCDCD");
        trie.addKeyword("LJCCDID");
        trie.addKeyword("LJCCDJCD");
        trie.addKeyword("LJCD");
        trie.addKeyword("LJCDD");
        trie.addKeyword("LJCGD");
        trie.addKeyword("LJCJJD");
        trie.addKeyword("LJCWCWJWCWJD");
        trie.addKeyword("LJD");
        trie.addKeyword("LJDCCD");
        trie.addKeyword("LJDCD");
        trie.addKeyword("LJDD");
        trie.addKeyword("LJDJPD");
        trie.addKeyword("LJDJPDD");
        trie.addKeyword("LJDJPDID");
        trie.addKeyword("LJDJPMDD");
        trie.addKeyword("LJFJJCLCD");
        trie.addKeyword("LJGD");
        trie.addKeyword("LJID");
        trie.addKeyword("LJJCD");
        trie.addKeyword("LJJD");
        trie.addKeyword("LJLD");
        trie.addKeyword("LJMD");
        trie.addKeyword("LJPCD");
        trie.addKeyword("LKCD");
        trie.addKeyword("LLCD");
        trie.addKeyword("LLD");
        trie.addKeyword("LLPD");
        trie.addKeyword("LMCCFCCD");
        trie.addKeyword("LMCD");
        trie.addKeyword("LMD");
        trie.addKeyword("LMID");
        trie.addKeyword("LPCCCCCD");
        trie.addKeyword("LPCCCD");
        trie.addKeyword("LPCCD");
        trie.addKeyword("LPCD");
        trie.addKeyword("LPCDD");
        trie.addKeyword("LPCFPPD");
        trie.addKeyword("LPCGCCCD");
        trie.addKeyword("LPCGCCD");
        trie.addKeyword("LPCGCCDCCD");
        trie.addKeyword("LPCGD");
        trie.addKeyword("LPCGDDPD");
        trie.addKeyword("LPD");
        trie.addKeyword("LPDD");
        trie.addKeyword("LPDDD");
        trie.addKeyword("LPICD");
        trie.addKeyword("LPID");
        trie.addKeyword("LPJD");
        trie.addKeyword("LPMDCCD");
        trie.addKeyword("LPPJD");
        trie.addKeyword("MCCCD");
        trie.addKeyword("MCCD");
        trie.addKeyword("MCCPD");
        trie.addKeyword("MCD");
        trie.addKeyword("MCDCCD");
        trie.addKeyword("MCDCCDCD");
        trie.addKeyword("MCDCCDD");
        trie.addKeyword("MCDCD");
        trie.addKeyword("MCDCGD");
        trie.addKeyword("MCDD");
        trie.addKeyword("MCDFD");
        trie.addKeyword("MCDFDD");
        trie.addKeyword("MCDLCD");
        trie.addKeyword("MCDPPD");
        trie.addKeyword("MCGCD");
        trie.addKeyword("MCICD");
        trie.addKeyword("MCID");
        trie.addKeyword("MCIDWGWD");
        trie.addKeyword("MCJD");
        trie.addKeyword("MCLD");
        trie.addKeyword("MCPD");
        trie.addKeyword("MD");
        trie.addKeyword("MDD");
        trie.addKeyword("MFD");
        trie.addKeyword("MGD");
        trie.addKeyword("MGJD");
        trie.addKeyword("MGJJD");
        trie.addKeyword("MICCD");
        trie.addKeyword("MICD");
        trie.addKeyword("MID");
        trie.addKeyword("MIDCCD");
        trie.addKeyword("MJCCD");
        trie.addKeyword("MJCD");
        trie.addKeyword("MJD");
        trie.addKeyword("MJDD");
        trie.addKeyword("MLCD");
        trie.addKeyword("MLD");
        trie.addKeyword("MLGD");
        trie.addKeyword("MLGGD");
        trie.addKeyword("MMCCD");
        trie.addKeyword("MMCD");
        trie.addKeyword("MMD");
        trie.addKeyword("MMMD");
        trie.addKeyword("MMPD");
        trie.addKeyword("MPCCD");
        trie.addKeyword("MPCD");
        trie.addKeyword("MPD");
        trie.addKeyword("MPDCD");
        trie.addKeyword("MPJPD");
        trie.addKeyword("MPPD");
        trie.addKeyword("PCCCCCCD");
        trie.addKeyword("PCCCCCD");
        trie.addKeyword("PCCCCD");
        trie.addKeyword("PCCCD");
        trie.addKeyword("PCCCDD");
        trie.addKeyword("PCCD");
        trie.addKeyword("PCCDD");
        trie.addKeyword("PCCGJGD");
        trie.addKeyword("PCCID");
        trie.addKeyword("PCCIDD");
        trie.addKeyword("PCD");
        trie.addKeyword("PCDCD");
        trie.addKeyword("PCDCJCD");
        trie.addKeyword("PCDD");
        trie.addKeyword("PCDFCCCD");
        trie.addKeyword("PCDID");
        trie.addKeyword("PCGCCD");
        trie.addKeyword("PCGCD");
        trie.addKeyword("PCGD");
        trie.addKeyword("PCID");
        trie.addKeyword("PCJCD");
        trie.addKeyword("PCJGD");
        trie.addKeyword("PCPCCD");
        trie.addKeyword("PCPD");
        trie.addKeyword("PD");
        trie.addKeyword("PDCCD");
        trie.addKeyword("PDD");
        trie.addKeyword("PDDD");
        trie.addKeyword("PFCCD");
        trie.addKeyword("PFCDD");
        trie.addKeyword("PFCJCD");
        trie.addKeyword("PFD");
        trie.addKeyword("PFFCD");
        trie.addKeyword("PFPCD");
        trie.addKeyword("PGCD");
        trie.addKeyword("PGCJD");
        trie.addKeyword("PGD");
        trie.addKeyword("PGDCICD");
        trie.addKeyword("PGJD");
        trie.addKeyword("PICCD");
        trie.addKeyword("PICD");
        trie.addKeyword("PICDD");
        trie.addKeyword("PID");
        trie.addKeyword("PIFD");
        trie.addKeyword("PIJCCD");
        trie.addKeyword("PIJD");
        trie.addKeyword("PJCCCDD");
        trie.addKeyword("PJCCD");
        trie.addKeyword("PJCD");
        trie.addKeyword("PJD");
        trie.addKeyword("PJDCD");
        trie.addKeyword("PJDD");
        trie.addKeyword("PJFD");
        trie.addKeyword("PJGD");
        trie.addKeyword("PJICCCPCD");
        trie.addKeyword("PJID");
        trie.addKeyword("PJJD");
        trie.addKeyword("PJJDD");
        trie.addKeyword("PJJPD");
        trie.addKeyword("PJLPCD");
        trie.addKeyword("PJPCD");
        trie.addKeyword("PJPD");
        trie.addKeyword("PLD");
        trie.addKeyword("PLPCD");
        trie.addKeyword("PMJCD");
        trie.addKeyword("PPCCCDCD");
        trie.addKeyword("PPCD");
        trie.addKeyword("PPCJCCD");
        trie.addKeyword("PPD");
        trie.addKeyword("PPDCD");
        trie.addKeyword("PPFCCD");
        trie.addKeyword("PPFCD");
        trie.addKeyword("PPGCID");
        trie.addKeyword("PPGD");
        trie.addKeyword("PPGJCCD");
        trie.addKeyword("PPICCD");
        trie.addKeyword("PPIGD");
        trie.addKeyword("PPJCD");
        trie.addKeyword("PPJD");
        trie.addKeyword("PPJJD");
        trie.addKeyword("PPMD");
        trie.addKeyword("PPPCPD");
        trie.addKeyword("PPPD");
        trie.addKeyword("PPPWGWCCD");
        trie.addKeyword("CCCCDID");
        trie.addKeyword("CCCDFGD");
        trie.addKeyword("CCCDGCD");
        trie.addKeyword("CCCDGDD");
        trie.addKeyword("CCCDWD");
        trie.addKeyword("CCCGCCD");
        trie.addKeyword("CCCGCD");
        trie.addKeyword("CCCWCWD");
        trie.addKeyword("CCCWGWCCD");
        trie.addKeyword("CCCWGWCCDWD");
        trie.addKeyword("CCCWGWD");
        trie.addKeyword("CCDDGCD");
        trie.addKeyword("CCDPCCD");
        trie.addKeyword("CCDWD");
        trie.addKeyword("CCFGCCCCCD");
        trie.addKeyword("CCFGFCCCD");
        trie.addKeyword("CCFPCD");
        trie.addKeyword("CCGDD");
        trie.addKeyword("CCGGCCD");
        trie.addKeyword("CCIDGD");
        trie.addKeyword("CCKD");
        trie.addKeyword("CCMIDGCD");
        trie.addKeyword("CCWD");
        trie.addKeyword("CCWGWCCCD");
        trie.addKeyword("CCWGWCD");
        trie.addKeyword("CCWGWDD");
        trie.addKeyword("CDWGWDGD");
        trie.addKeyword("CFCCGWD");
        trie.addKeyword("CFCD");
        trie.addKeyword("CFCWGWD");
        trie.addKeyword("CFGFGFGFGJID");
        trie.addKeyword("CFJD");
        trie.addKeyword("CFWGWCCDGCD");
        trie.addKeyword("CFWGWCJCD");
        trie.addKeyword("CGCCCCD");
        trie.addKeyword("CGCCID");
        trie.addKeyword("CGCCJCCCD");
        trie.addKeyword("CGCDCCD");
        trie.addKeyword("CGCFCCD");
        trie.addKeyword("CGCGCD");
        trie.addKeyword("CGCID");
        trie.addKeyword("CGFCCD");
        trie.addKeyword("CGFCD");
        trie.addKeyword("CGFDID");
        trie.addKeyword("CGGCICD");
        trie.addKeyword("CGGJPD");
        trie.addKeyword("CGICDGCD");
        trie.addKeyword("CGICDID");
        trie.addKeyword("CGIID");
        trie.addKeyword("CGJCCCD");
        trie.addKeyword("CGJCCD");
        trie.addKeyword("CGJCD");
        trie.addKeyword("CGJCDGD");
        trie.addKeyword("CGJCDWD");
        trie.addKeyword("CGJCJCD");
        trie.addKeyword("CGJDD");
        trie.addKeyword("CGJDDCCD");
        trie.addKeyword("CGJGCD");
        trie.addKeyword("CGJID");
        trie.addKeyword("CGLCCD");
        trie.addKeyword("CGPCCD");
        trie.addKeyword("CGPCD");
        trie.addKeyword("CGPD");
        trie.addKeyword("CGPFCCD");
        trie.addKeyword("CGPICD");
        trie.addKeyword("CGPID");
        trie.addKeyword("CGPJCDD");
        trie.addKeyword("CGPJJJCD");
        trie.addKeyword("CICCDGD");
        trie.addKeyword("CICFJGD");
        trie.addKeyword("CICGFID");
        trie.addKeyword("CIDCD");
        trie.addKeyword("CIDGD");
        trie.addKeyword("CIFID");
        trie.addKeyword("CIGCCD");
        trie.addKeyword("CIGMCD");
        trie.addKeyword("CIICCD");
        trie.addKeyword("CIICD");
        trie.addKeyword("CIJCWGWCD");
        trie.addKeyword("CIJD");
        trie.addKeyword("CIJWD");
        trie.addKeyword("CIPCCD");
        trie.addKeyword("CJCCDFD");
        trie.addKeyword("CJCGD");
        trie.addKeyword("CJCID");
        trie.addKeyword("CJCWCCCD");
        trie.addKeyword("CJCWGWD");
        trie.addKeyword("CJGCCCD");
        trie.addKeyword("CJICD");
        trie.addKeyword("CJIDD");
        trie.addKeyword("CJJCD");
        trie.addKeyword("CJWGCD");
        trie.addKeyword("CJWGWID");
        trie.addKeyword("CPCCDGJD");
        trie.addKeyword("CPCDCCD");
        trie.addKeyword("CPDFCD");
        trie.addKeyword("CPGID");
        trie.addKeyword("CPICD");
        trie.addKeyword("CPIWGWD");
        trie.addKeyword("CPJGD");
        trie.addKeyword("CPPCD");
        trie.addKeyword("CPWGWDGD");
        trie.addKeyword("D");
        trie.addKeyword("FCCCCCCCD");
        trie.addKeyword("FCCCCGD");
        trie.addKeyword("FCCCDGD");
        trie.addKeyword("FCCCWGWD");
        trie.addKeyword("FCCDD");
        trie.addKeyword("FCCDFCGD");
        trie.addKeyword("FCCDGD");
        trie.addKeyword("FCCDIPD");
        trie.addKeyword("FCCDWGWD");
        trie.addKeyword("FCCPCD");
        trie.addKeyword("FCCWGWDD");
        trie.addKeyword("FCDGD");
        trie.addKeyword("FCDWD");
        trie.addKeyword("FCDWGD");
        trie.addKeyword("FCFWGWD");
        trie.addKeyword("FCICCD");
        trie.addKeyword("FCICDGD");
        trie.addKeyword("FCIWGWDD");
        trie.addKeyword("FCPCD");
        trie.addKeyword("FCPCPD");
        trie.addKeyword("FCPDGD");
        trie.addKeyword("FCPPGD");
        trie.addKeyword("FCWGWCD");
        trie.addKeyword("FCWGWDD");
        trie.addKeyword("FDDD");
        trie.addKeyword("FDGD");
        trie.addKeyword("FDGJCCD");
        trie.addKeyword("FDWGWD");
        trie.addKeyword("FFCCWGWD");
        trie.addKeyword("FFFFD");
        trie.addKeyword("FFFFFWWFD");
        trie.addKeyword("FFFFWWD");
        trie.addKeyword("FFFWD");
        trie.addKeyword("FFFWWD");
        trie.addKeyword("FFFWWFD");
        trie.addKeyword("FFWWD");
        trie.addKeyword("FGFPCCD");
        trie.addKeyword("FGJWGWD");
        trie.addKeyword("FICCCD");
        trie.addKeyword("FICDGD");
        trie.addKeyword("FICGWD");
        trie.addKeyword("FICJD");
        trie.addKeyword("FIICD");
        trie.addKeyword("FIWGWCDD");
        trie.addKeyword("FIWGWD");
        trie.addKeyword("FIWGWDD");
        trie.addKeyword("FJCCDD");
        trie.addKeyword("FJGPCD");
        trie.addKeyword("FJID");
        trie.addKeyword("FJJGD");
        trie.addKeyword("FMJD");
        trie.addKeyword("FPCCD");
        trie.addKeyword("FPCDD");
        trie.addKeyword("FPDD");
        trie.addKeyword("FPIDGD");
        trie.addKeyword("FPWCWD");
        trie.addKeyword("FWFWFD");
        trie.addKeyword("FWGCD");
        trie.addKeyword("FWGWCCD");
        trie.addKeyword("FWGWCDGCD");
        trie.addKeyword("FWGWCDGD");
        trie.addKeyword("FWGWGD");
        trie.addKeyword("FWJD");
        trie.addKeyword("GCCCCCCDCD");
        trie.addKeyword("GCCCCCDGD");
        trie.addKeyword("GCCCCCID");
        trie.addKeyword("GCCCCCKFD");
        trie.addKeyword("GCCCCDCD");
        trie.addKeyword("GCCCCDGCD");
        trie.addKeyword("GCCCCDGCIJD");
        trie.addKeyword("GCCCCDGDGDDDD");
        trie.addKeyword("GCCCCDWFCCD");
        trie.addKeyword("GCCCCDWGD");
        trie.addKeyword("GCCCCFCCCCD");
        trie.addKeyword("GCCCCID");
        trie.addKeyword("GCCCDCPD");
        trie.addKeyword("GCCCDDGCD");
        trie.addKeyword("GCCCDDGD");
        trie.addKeyword("GCCCDFCD");
        trie.addKeyword("GCCCDGD");
        trie.addKeyword("GCCCDGID");
        trie.addKeyword("GCCCDICD");
        trie.addKeyword("GCCCDMD");
        trie.addKeyword("GCCCDWGCDWFCCD");
        trie.addKeyword("GCCCDWGD");
        trie.addKeyword("GCCCDWGWD");
        trie.addKeyword("GCCCDWID");
        trie.addKeyword("GCCCGPD");
        trie.addKeyword("GCCCIJD");
        trie.addKeyword("GCCCJCCD");
        trie.addKeyword("GCCCJJCD");
        trie.addKeyword("GCCCMCD");
        trie.addKeyword("GCCCWD");
        trie.addKeyword("GCCDCCMD");
        trie.addKeyword("GCCDDWD");
        trie.addKeyword("GCCDFCCD");
        trie.addKeyword("GCCDGCD");
        trie.addKeyword("GCCDGCGD");
        trie.addKeyword("GCCDGDGCD");
        trie.addKeyword("GCCDGJD");
        trie.addKeyword("GCCDPPCD");
        trie.addKeyword("GCCDWD");
        trie.addKeyword("GCCFCCD");
        trie.addKeyword("GCCFID");
        trie.addKeyword("GCCFJCD");
        trie.addKeyword("GCCFWCWCD");
        trie.addKeyword("GCCGDCD");
        trie.addKeyword("GCCGFD");
        trie.addKeyword("GCCGFICD");
        trie.addKeyword("GCCGID");
        trie.addKeyword("GCCGIID");
        trie.addKeyword("GCCICCD");
        trie.addKeyword("GCCICDCD");
        trie.addKeyword("GCCICWDD");
        trie.addKeyword("GCCIDWDCD");
        trie.addKeyword("GCCIID");
        trie.addKeyword("GCCIJD");
        trie.addKeyword("GCCJCDD");
        trie.addKeyword("GCCJCGCD");
        trie.addKeyword("GCCJDD");
        trie.addKeyword("GCCJIDCD");
        trie.addKeyword("GCCKDGD");
        trie.addKeyword("GCCMJCD");
        trie.addKeyword("GCCMJJCD");
        trie.addKeyword("GCCWD");
        trie.addKeyword("GCDCCCDGD");
        trie.addKeyword("GCDCWDWD");
        trie.addKeyword("GCDDDD");
        trie.addKeyword("GCDDJCD");
        trie.addKeyword("GCDFCD");
        trie.addKeyword("GCDFID");
        trie.addKeyword("GCDFJD");
        trie.addKeyword("GCDGCGD");
        trie.addKeyword("GCDGGGCD");
        trie.addKeyword("GCDGIID");
        trie.addKeyword("GCDIID");
        trie.addKeyword("GCDKD");
        trie.addKeyword("GCDMDFD");
        trie.addKeyword("GCDPGD");
        trie.addKeyword("GCDWD");
        trie.addKeyword("GCDWDWD");
        trie.addKeyword("GCFCCCD");
        trie.addKeyword("GCFCCCDGD");
        trie.addKeyword("GCFCDICD");
        trie.addKeyword("GCFCDWGD");
        trie.addKeyword("GCFCIFD");
        trie.addKeyword("GCFCJD");
        trie.addKeyword("GCFDDCID");
        trie.addKeyword("GCFFJD");
        trie.addKeyword("GCFGJPCD");
        trie.addKeyword("GCFICD");
        trie.addKeyword("GCFIDFD");
        trie.addKeyword("GCFJD");
        trie.addKeyword("GCFJDD");
        trie.addKeyword("GCFJPD");
        trie.addKeyword("GCFPCCCD");
        trie.addKeyword("GCFPDD");
        trie.addKeyword("GCFPID");
        trie.addKeyword("GCGCCCCD");
        trie.addKeyword("GCGCCCID");
        trie.addKeyword("GCGCCCIDD");
        trie.addKeyword("GCGCCDD");
        trie.addKeyword("GCGCCDFD");
        trie.addKeyword("GCGCCID");
        trie.addKeyword("GCGCCJCD");
        trie.addKeyword("GCGCCPD");
        trie.addKeyword("GCGCDCCCD");
        trie.addKeyword("GCGCDCD");
        trie.addKeyword("GCGCDCID");
        trie.addKeyword("GCGCDD");
        trie.addKeyword("GCGCFCCD");
        trie.addKeyword("GCGCFCD");
        trie.addKeyword("GCGCFGCD");
        trie.addKeyword("GCGCGCCD");
        trie.addKeyword("GCGCGCD");
        trie.addKeyword("GCGCGCPCCD");
        trie.addKeyword("GCGCGD");
        trie.addKeyword("GCGCGID");
        trie.addKeyword("GCGCGPD");
        trie.addKeyword("GCGCICCCD");
        trie.addKeyword("GCGCICDDFCCCD");
        trie.addKeyword("GCGCIDD");
        trie.addKeyword("GCGCIID");
        trie.addKeyword("GCGCJCCD");
        trie.addKeyword("GCGCJD");
        trie.addKeyword("GCGCJGWD");
        trie.addKeyword("GCGCJJD");
        trie.addKeyword("GCGCLCCD");
        trie.addKeyword("GCGCPCCD");
        trie.addKeyword("GCGCPCCID");
        trie.addKeyword("GCGCPCD");
        trie.addKeyword("GCGCPCJCCD");
        trie.addKeyword("GCGDCCICCD");
        trie.addKeyword("GCGDCD");
        trie.addKeyword("GCGDIMD");
        trie.addKeyword("GCGFCCD");
        trie.addKeyword("GCGFCD");
        trie.addKeyword("GCGFCJD");
        trie.addKeyword("GCGFCMJD");
        trie.addKeyword("GCGFD");
        trie.addKeyword("GCGFDD");
        trie.addKeyword("GCGFFCD");
        trie.addKeyword("GCGFFD");
        trie.addKeyword("GCGFID");
        trie.addKeyword("GCGFIDD");
        trie.addKeyword("GCGFJD");
        trie.addKeyword("GCGGCCD");
        trie.addKeyword("GCGGGJCD");
        trie.addKeyword("GCGGJCID");
        trie.addKeyword("GCGGJCJD");
        trie.addKeyword("GCGICCCD");
        trie.addKeyword("GCGICCD");
        trie.addKeyword("GCGICCJD");
        trie.addKeyword("GCGICDMD");
        trie.addKeyword("GCGICICCD");
        trie.addKeyword("GCGICJCDD");
        trie.addKeyword("GCGICJD");
        trie.addKeyword("GCGICJJD");
        trie.addKeyword("GCGIDCGD");
        trie.addKeyword("GCGIDD");
        trie.addKeyword("GCGIDGD");
        trie.addKeyword("GCGIGCCD");
        trie.addKeyword("GCGIICD");
        trie.addKeyword("GCGIID");
        trie.addKeyword("GCGIMCCD");
        trie.addKeyword("GCGIMJD");
        trie.addKeyword("GCGIPCCD");
        trie.addKeyword("GCGIPD");
        trie.addKeyword("GCGJCCCCDD");
        trie.addKeyword("GCGJCCCD");
        trie.addKeyword("GCGJCCDD");
        trie.addKeyword("GCGJCD");
        trie.addKeyword("GCGJCID");
        trie.addKeyword("GCGJD");
        trie.addKeyword("GCGJDD");
        trie.addKeyword("GCGJGICD");
        trie.addKeyword("GCGJICD");
        trie.addKeyword("GCGJID");
        trie.addKeyword("GCGJIFCD");
        trie.addKeyword("GCGJJCD");
        trie.addKeyword("GCGJPCCD");
        trie.addKeyword("GCGJPCD");
        trie.addKeyword("GCGKCD");
        trie.addKeyword("GCGKD");
        trie.addKeyword("GCGLCDCCD");
        trie.addKeyword("GCGLCJD");
        trie.addKeyword("GCGLGCCD");
        trie.addKeyword("GCGLGPCCID");
        trie.addKeyword("GCGLIPJD");
        trie.addKeyword("GCGLJJID");
        trie.addKeyword("GCGMCD");
        trie.addKeyword("GCGMD");
        trie.addKeyword("GCGPCCCCCD");
        trie.addKeyword("GCGPCCCD");
        trie.addKeyword("GCGPCD");
        trie.addKeyword("GCGPCFCCD");
        trie.addKeyword("GCGPCID");
        trie.addKeyword("GCGPCPD");
        trie.addKeyword("GCGPD");
        trie.addKeyword("GCGPFCD");
        trie.addKeyword("GCGPGCD");
        trie.addKeyword("GCGPIID");
        trie.addKeyword("GCGPJCCD");
        trie.addKeyword("GCGPJCD");
        trie.addKeyword("GCGPJD");
        trie.addKeyword("GCGPJGCD");
        trie.addKeyword("GCGPJID");
        trie.addKeyword("GCGPLICD");
        trie.addKeyword("GCGPLID");
        trie.addKeyword("GCGPPCCD");
        trie.addKeyword("GCGPPCD");
        trie.addKeyword("GCGPPD");
        trie.addKeyword("GCGPPID");
        trie.addKeyword("GCGPPJD");
        trie.addKeyword("GCGWPFCD");
        trie.addKeyword("GCICCCDD");
        trie.addKeyword("GCICCDFD");
        trie.addKeyword("GCICCJD");
        trie.addKeyword("GCICCWDWDCGD");
        trie.addKeyword("GCICDFCD");
        trie.addKeyword("GCICPD");
        trie.addKeyword("GCIDCD");
        trie.addKeyword("GCIDCGD");
        trie.addKeyword("GCIDDGD");
        trie.addKeyword("GCIDPCCD");
        trie.addKeyword("GCIICD");
        trie.addKeyword("GCIJCCD");
        trie.addKeyword("GCIJCCDMD");
        trie.addKeyword("GCIJCID");
        trie.addKeyword("GCIKD");
        trie.addKeyword("GCIPCCD");
        trie.addKeyword("GCIPCPD");
        trie.addKeyword("GCJCCCCCD");
        trie.addKeyword("GCJCCDCD");
        trie.addKeyword("GCJCCDGD");
        trie.addKeyword("GCJCCDMD");
        trie.addKeyword("GCJCCICD");
        trie.addKeyword("GCJCDD");
        trie.addKeyword("GCJCICD");
        trie.addKeyword("GCJCKDD");
        trie.addKeyword("GCJDCDCD");
        trie.addKeyword("GCJDDCD");
        trie.addKeyword("GCJGCD");
        trie.addKeyword("GCJICCCD");
        trie.addKeyword("GCJICGD");
        trie.addKeyword("GCJIDCD");
        trie.addKeyword("GCJIDD");
        trie.addKeyword("GCJJCDD");
        trie.addKeyword("GCJJCJCD");
        trie.addKeyword("GCJJDD");
        trie.addKeyword("GCJMCID");
        trie.addKeyword("GCJPCCCD");
        trie.addKeyword("GCJPCCD");
        trie.addKeyword("GCJPCD");
        trie.addKeyword("GCJPCDMD");
        trie.addKeyword("GCJPID");
        trie.addKeyword("GCJPJD");
        trie.addKeyword("GCJWCPWD");
        trie.addKeyword("GCKCCCD");
        trie.addKeyword("GCKCD");
        trie.addKeyword("GCKDGD");
        trie.addKeyword("GCKGD");
        trie.addKeyword("GCKICD");
        trie.addKeyword("GCKJCCD");
        trie.addKeyword("GCKPD");
        trie.addKeyword("GCLCID");
        trie.addKeyword("GCLGIJCD");
        trie.addKeyword("GCLID");
        trie.addKeyword("GCMCCDFD");
        trie.addKeyword("GCMCCKGD");
        trie.addKeyword("GCMCJCCD");
        trie.addKeyword("GCMCPD");
        trie.addKeyword("GCMDCGCD");
        trie.addKeyword("GCMFCDGD");
        trie.addKeyword("GCMID");
        trie.addKeyword("GCMJCD");
        trie.addKeyword("GCMJCDD");
        trie.addKeyword("GCMJCID");
        trie.addKeyword("GCMJID");
        trie.addKeyword("GCMJPCCCCD");
        trie.addKeyword("GCMKD");
        trie.addKeyword("GCMKGD");
        trie.addKeyword("GCMPCCD");
        trie.addKeyword("GCMPJD");
        trie.addKeyword("GCMPPCCD");
        trie.addKeyword("GCPCCCMD");
        trie.addKeyword("GCPCCDCD");
        trie.addKeyword("GCPCCDMD");
        trie.addKeyword("GCPCCDWD");
        trie.addKeyword("GCPCCWGCWD");
        trie.addKeyword("GCPCDCD");
        trie.addKeyword("GCPCDGD");
        trie.addKeyword("GCPCDWD");
        trie.addKeyword("GCPCICDWGD");
        trie.addKeyword("GCPCIICFD");
        trie.addKeyword("GCPCJCFD");
        trie.addKeyword("GCPCJD");
        trie.addKeyword("GCPDGD");
        trie.addKeyword("GCPGGCD");
        trie.addKeyword("GCPICCCDGD");
        trie.addKeyword("GCPICCD");
        trie.addKeyword("GCPICD");
        trie.addKeyword("GCPICID");
        trie.addKeyword("GCPID");
        trie.addKeyword("GCPIJCCD");
        trie.addKeyword("GCPJCDD");
        trie.addKeyword("GCPJPDD");
        trie.addKeyword("GCPKD");
        trie.addKeyword("GCPMCCD");
        trie.addKeyword("GCPMJCD");
        trie.addKeyword("GCPPCD");
        trie.addKeyword("GCPPID");
        trie.addKeyword("GCPPWCWID");
        trie.addKeyword("GCPWCWCD");
        trie.addKeyword("GCPWDWDCCD");
        trie.addKeyword("GCWDWDCCD");
        trie.addKeyword("GCWGWCCD");
        trie.addKeyword("GCWGWD");
        trie.addKeyword("GCWGWJD");
        trie.addKeyword("GCWJCCD");
        trie.addKeyword("GDCCCCFCD");
        trie.addKeyword("GDCCCFCPD");
        trie.addKeyword("GDCCPCCD");
        trie.addKeyword("GDCDGCD");
        trie.addKeyword("GDCDJD");
        trie.addKeyword("GDCKGCD");
        trie.addKeyword("GDDGCD");
        trie.addKeyword("GDDGD");
        trie.addKeyword("GDDMD");
        trie.addKeyword("GDICCCD");
        trie.addKeyword("GDIPD");
        trie.addKeyword("GDJCICD");
        trie.addKeyword("GDLCCD");
        trie.addKeyword("GFCCCCCCD");
        trie.addKeyword("GFCCCCFD");
        trie.addKeyword("GFCCCDD");
        trie.addKeyword("GFCCCDDD");
        trie.addKeyword("GFCCCDFCD");
        trie.addKeyword("GFCCCDFDD");
        trie.addKeyword("GFCCCDGCD");
        trie.addKeyword("GFCCCDGD");
        trie.addKeyword("GFCCCDID");
        trie.addKeyword("GFCCDCCD");
        trie.addKeyword("GFCCDCD");
        trie.addKeyword("GFCCDCFD");
        trie.addKeyword("GFCCDDD");
        trie.addKeyword("GFCCDFCD");
        trie.addKeyword("GFCCDFDMD");
        trie.addKeyword("GFCCDFFCD");
        trie.addKeyword("GFCCDFFD");
        trie.addKeyword("GFCCDFGD");
        trie.addKeyword("GFCCDGCCD");
        trie.addKeyword("GFCCDGCD");
        trie.addKeyword("GFCCDGD");
        trie.addKeyword("GFCCDGGID");
        trie.addKeyword("GFCCDGICDJICD");
        trie.addKeyword("GFCCDID");
        trie.addKeyword("GFCCDLD");
        trie.addKeyword("GFCCDMD");
        trie.addKeyword("GFCCDWCD");
        trie.addKeyword("GFCCDWD");
        trie.addKeyword("GFCCDWFDD");
        trie.addKeyword("GFCCDWGCD");
        trie.addKeyword("GFCCDWGD");
        trie.addKeyword("GFCCID");
        trie.addKeyword("GFCCJD");
        trie.addKeyword("GFCCPCD");
        trie.addKeyword("GFCDDCCCD");
        trie.addKeyword("GFCDFCCD");
        trie.addKeyword("GFCDFCD");
        trie.addKeyword("GFCDGCD");
        trie.addKeyword("GFCDGD");
        trie.addKeyword("GFCDGDD");
        trie.addKeyword("GFCDGFCD");
        trie.addKeyword("GFCDGGCD");
        trie.addKeyword("GFCDGGD");
        trie.addKeyword("GFCDGPD");
        trie.addKeyword("GFCDID");
        trie.addKeyword("GFCDMIDMD");
        trie.addKeyword("GFCDWCD");
        trie.addKeyword("GFCDWD");
        trie.addKeyword("GFCDWGD");
        trie.addKeyword("GFCFCD");
        trie.addKeyword("GFCGCD");
        trie.addKeyword("GFCGD");
        trie.addKeyword("GFCICD");
        trie.addKeyword("GFCIDCGD");
        trie.addKeyword("GFCIDWD");
        trie.addKeyword("GFCJCCCD");
        trie.addKeyword("GFCJCCD");
        trie.addKeyword("GFCJCCDD");
        trie.addKeyword("GFCJCJD");
        trie.addKeyword("GFCJDD");
        trie.addKeyword("GFCJID");
        trie.addKeyword("GFCKD");
        trie.addKeyword("GFCLCD");
        trie.addKeyword("GFCMCCD");
        trie.addKeyword("GFCMJCDWD");
        trie.addKeyword("GFCPDGD");
        trie.addKeyword("GFCPPCD");
        trie.addKeyword("GFCWCD");
        trie.addKeyword("GFCWCWCD");
        trie.addKeyword("GFCWFWFCCD");
        trie.addKeyword("GFCWGWD");
        trie.addKeyword("GFDCCD");
        trie.addKeyword("GFDCDCDD");
        trie.addKeyword("GFDCDD");
        trie.addKeyword("GFDCDGD");
        trie.addKeyword("GFDCID");
        trie.addKeyword("GFDDCCD");
        trie.addKeyword("GFDDCGD");
        trie.addKeyword("GFDDD");
        trie.addKeyword("GFDDGD");
        trie.addKeyword("GFDDPD");
        trie.addKeyword("GFDGCD");
        trie.addKeyword("GFDGD");
        trie.addKeyword("GFDICD");
        trie.addKeyword("GFDICPCD");
        trie.addKeyword("GFDID");
        trie.addKeyword("GFDJPCD");
        trie.addKeyword("GFDWD");
        trie.addKeyword("GFDWDWD");
        trie.addKeyword("GFFCCCD");
        trie.addKeyword("GFFCJD");
        trie.addKeyword("GFFDD");
        trie.addKeyword("GFFJJDGD");
        trie.addKeyword("GFFPDGD");
        trie.addKeyword("GFGCCCDD");
        trie.addKeyword("GFGCCD");
        trie.addKeyword("GFGCCDGPD");
        trie.addKeyword("GFGFICD");
        trie.addKeyword("GFGMPD");
        trie.addKeyword("GFICCDCD");
        trie.addKeyword("GFICCDD");
        trie.addKeyword("GFICDCD");
        trie.addKeyword("GFICDCJD");
        trie.addKeyword("GFICDD");
        trie.addKeyword("GFICDGD");
        trie.addKeyword("GFICJD");
        trie.addKeyword("GFICKD");
        trie.addKeyword("GFIDD");
        trie.addKeyword("GFIDFGD");
        trie.addKeyword("GFIDGCD");
        trie.addKeyword("GFIDGD");
        trie.addKeyword("GFIDPCPCD");
        trie.addKeyword("GFIGD");
        trie.addKeyword("GFIID");
        trie.addKeyword("GFIIDFCD");
        trie.addKeyword("GFIIGD");
        trie.addKeyword("GFIJCCD");
        trie.addKeyword("GFIJD");
        trie.addKeyword("GFJCCCCD");
        trie.addKeyword("GFJCCDD");
        trie.addKeyword("GFJCDD");
        trie.addKeyword("GFJCDGD");
        trie.addKeyword("GFJCDWD");
        trie.addKeyword("GFJCJD");
        trie.addKeyword("GFJDD");
        trie.addKeyword("GFJDGCD");
        trie.addKeyword("GFJDGFCD");
        trie.addKeyword("GFJDWD");
        trie.addKeyword("GFJDWFICGD");
        trie.addKeyword("GFJFD");
        trie.addKeyword("GFJICD");
        trie.addKeyword("GFJICDGD");
        trie.addKeyword("GFJID");
        trie.addKeyword("GFJJCD");
        trie.addKeyword("GFJJDWGD");
        trie.addKeyword("GFKD");
        trie.addKeyword("GFKDGD");
        trie.addKeyword("GFLCD");
        trie.addKeyword("GFMJCD");
        trie.addKeyword("GFPCCCD");
        trie.addKeyword("GFPCCD");
        trie.addKeyword("GFPCDCD");
        trie.addKeyword("GFPCDD");
        trie.addKeyword("GFPCJD");
        trie.addKeyword("GFPDCD");
        trie.addKeyword("GFPDD");
        trie.addKeyword("GFPDID");
        trie.addKeyword("GFPICD");
        trie.addKeyword("GFPIJD");
        trie.addKeyword("GFPJIDD");
        trie.addKeyword("GFPKD");
        trie.addKeyword("GFPPCCD");
        trie.addKeyword("GFPPCD");
        trie.addKeyword("GFWCWID");
        trie.addKeyword("GFWDWD");
        trie.addKeyword("GFWJD");
        trie.addKeyword("GGCCCCCCD");
        trie.addKeyword("GGCCCCJCD");
        trie.addKeyword("GGCCCDD");
        trie.addKeyword("GGCCCDDD");
        trie.addKeyword("GGCCCDGD");
        trie.addKeyword("GGCCCDWGCD");
        trie.addKeyword("GGCCDCDGD");
        trie.addKeyword("GGCCDFGCD");
        trie.addKeyword("GGCCDGD");
        trie.addKeyword("GGCCDGDCD");
        trie.addKeyword("GGCCDID");
        trie.addKeyword("GGCCDMCD");
        trie.addKeyword("GGCCDWGD");
        trie.addKeyword("GGCCFCD");
        trie.addKeyword("GGCCFD");
        trie.addKeyword("GGCCGCCD");
        trie.addKeyword("GGCCICDD");
        trie.addKeyword("GGCCID");
        trie.addKeyword("GGCCJCCDD");
        trie.addKeyword("GGCCLCD");
        trie.addKeyword("GGCCPCD");
        trie.addKeyword("GGCCPJD");
        trie.addKeyword("GGCDCCDGD");
        trie.addKeyword("GGCDCDD");
        trie.addKeyword("GGCDCDGD");
        trie.addKeyword("GGCDCGD");
        trie.addKeyword("GGCDDCCD");
        trie.addKeyword("GGCDGD");
        trie.addKeyword("GGCDGPGCD");
        trie.addKeyword("GGCDID");
        trie.addKeyword("GGCDMD");
        trie.addKeyword("GGCFCCD");
        trie.addKeyword("GGCFCD");
        trie.addKeyword("GGCFID");
        trie.addKeyword("GGCGCCCCD");
        trie.addKeyword("GGCGCCD");
        trie.addKeyword("GGCGCGCCD");
        trie.addKeyword("GGCGCGCD");
        trie.addKeyword("GGCGCGFCD");
        trie.addKeyword("GGCGDGCD");
        trie.addKeyword("GGCGFD");
        trie.addKeyword("GGCGFID");
        trie.addKeyword("GGCGGCD");
        trie.addKeyword("GGCGGGD");
        trie.addKeyword("GGCGGJD");
        trie.addKeyword("GGCGICCD");
        trie.addKeyword("GGCGIICD");
        trie.addKeyword("GGCGILICD");
        trie.addKeyword("GGCGJID");
        trie.addKeyword("GGCGJIJCD");
        trie.addKeyword("GGCGPCCD");
        trie.addKeyword("GGCGPCD");
        trie.addKeyword("GGCGPJCCD");
        trie.addKeyword("GGCGPJCD");
        trie.addKeyword("GGCGPJD");
        trie.addKeyword("GGCGPPD");
        trie.addKeyword("GGCICCD");
        trie.addKeyword("GGCICCID");
        trie.addKeyword("GGCICD");
        trie.addKeyword("GGCIDD");
        trie.addKeyword("GGCIICD");
        trie.addKeyword("GGCIIJD");
        trie.addKeyword("GGCIPCICCD");
        trie.addKeyword("GGCIPD");
        trie.addKeyword("GGCJCDD");
        trie.addKeyword("GGCJCJD");
        trie.addKeyword("GGCJDD");
        trie.addKeyword("GGCJID");
        trie.addKeyword("GGCKLCD");
        trie.addKeyword("GGCLCCD");
        trie.addKeyword("GGCMCIJD");
        trie.addKeyword("GGCMID");
        trie.addKeyword("GGCPCCCD");
        trie.addKeyword("GGCPCCJCCCWD");
        trie.addKeyword("GGCPCDD");
        trie.addKeyword("GGCPDD");
        trie.addKeyword("GGCPGGCID");
        trie.addKeyword("GGCPICD");
        trie.addKeyword("GGCPICDD");
        trie.addKeyword("GGCPID");
        trie.addKeyword("GGCPJCD");
        trie.addKeyword("GGCPPCCD");
        trie.addKeyword("GGCPPD");
        trie.addKeyword("GGCWDWCCDGCD");
        trie.addKeyword("GGCWGD");
        trie.addKeyword("GGDCDCCD");
        trie.addKeyword("GGDCJD");
        trie.addKeyword("GGDDFD");
        trie.addKeyword("GGDGCCGCD");
        trie.addKeyword("GGDGCDGD");
        trie.addKeyword("GGDLGD");
        trie.addKeyword("GGFCCCCD");
        trie.addKeyword("GGFCDID");
        trie.addKeyword("GGFCFCDD");
        trie.addKeyword("GGFCID");
        trie.addKeyword("GGFCJD");
        trie.addKeyword("GGFCMCCD");
        trie.addKeyword("GGFDCD");
        trie.addKeyword("GGFDDD");
        trie.addKeyword("GGFICD");
        trie.addKeyword("GGFICDD");
        trie.addKeyword("GGFID");
        trie.addKeyword("GGFJCD");
        trie.addKeyword("GGFJID");
        trie.addKeyword("GGFJMD");
        trie.addKeyword("GGFKID");
        trie.addKeyword("GGFMJDD");
        trie.addKeyword("GGFPCD");
        trie.addKeyword("GGFPD");
        trie.addKeyword("GGFWID");
        trie.addKeyword("GGGCCCDGD");
        trie.addKeyword("GGGCCCICD");
        trie.addKeyword("GGGCCDGD");
        trie.addKeyword("GGGCCID");
        trie.addKeyword("GGGCGGD");
        trie.addKeyword("GGGCJCD");
        trie.addKeyword("GGGCPD");
        trie.addKeyword("GGGCPFCPCD");
        trie.addKeyword("GGGCPJD");
        trie.addKeyword("GGGFCCD");
        trie.addKeyword("GGGFCCID");
        trie.addKeyword("GGGFCD");
        trie.addKeyword("GGGFCJD");
        trie.addKeyword("GGGFID");
        trie.addKeyword("GGGGPJD");
        trie.addKeyword("GGGICCD");
        trie.addKeyword("GGGICJD");
        trie.addKeyword("GGGIDGID");
        trie.addKeyword("GGGIICD");
        trie.addKeyword("GGGJCCD");
        trie.addKeyword("GGGJGID");
        trie.addKeyword("GGGKCD");
        trie.addKeyword("GGGKDJD");
        trie.addKeyword("GGGLJCD");
        trie.addKeyword("GGGMCD");
        trie.addKeyword("GGGPCD");
        trie.addKeyword("GGGPFIDWD");
        trie.addKeyword("GGGPIICD");
        trie.addKeyword("GGGPIPD");
        trie.addKeyword("GGGPPID");
        trie.addKeyword("GGICCGCD");
        trie.addKeyword("GGICCID");
        trie.addKeyword("GGICDD");
        trie.addKeyword("GGICFID");
        trie.addKeyword("GGICJCD");
        trie.addKeyword("GGICJDD");
        trie.addKeyword("GGICPCCID");
        trie.addKeyword("GGICPD");
        trie.addKeyword("GGIDID");
        trie.addKeyword("GGIDWGD");
        trie.addKeyword("GGIFCCD");
        trie.addKeyword("GGIFCD");
        trie.addKeyword("GGIFCJD");
        trie.addKeyword("GGIFICD");
        trie.addKeyword("GGIFID");
        trie.addKeyword("GGIFIDDD");
        trie.addKeyword("GGIFJD");
        trie.addKeyword("GGIFMID");
        trie.addKeyword("GGIGPFD");
        trie.addKeyword("GGIICCD");
        trie.addKeyword("GGIJCD");
        trie.addKeyword("GGIJCID");
        trie.addKeyword("GGIJDD");
        trie.addKeyword("GGIJICD");
        trie.addKeyword("GGIPCCD");
        trie.addKeyword("GGIPDCCD");
        trie.addKeyword("GGIPICD");
        trie.addKeyword("GGIPMICD");
        trie.addKeyword("GGJCCCCCD");
        trie.addKeyword("GGJCCCCD");
        trie.addKeyword("GGJCCICD");
        trie.addKeyword("GGJCDD");
        trie.addKeyword("GGJCGCD");
        trie.addKeyword("GGJCICCD");
        trie.addKeyword("GGJCICD");
        trie.addKeyword("GGJGCD");
        trie.addKeyword("GGJGCICD");
        trie.addKeyword("GGJGCLCGCD");
        trie.addKeyword("GGJICCD");
        trie.addKeyword("GGJICJD");
        trie.addKeyword("GGJICPCCD");
        trie.addKeyword("GGJID");
        trie.addKeyword("GGJIID");
        trie.addKeyword("GGJJCD");
        trie.addKeyword("GGJJCDD");
        trie.addKeyword("GGJJCKD");
        trie.addKeyword("GGJJID");
        trie.addKeyword("GGJMID");
        trie.addKeyword("GGJPCCCCD");
        trie.addKeyword("GGJPCCD");
        trie.addKeyword("GGJPCD");
        trie.addKeyword("GGJPCJCD");
        trie.addKeyword("GGJPCJPJCD");
        trie.addKeyword("GGJPID");
        trie.addKeyword("GGJPJD");
        trie.addKeyword("GGKCCCD");
        trie.addKeyword("GGKCD");
        trie.addKeyword("GGKDD");
        trie.addKeyword("GGLCCD");
        trie.addKeyword("GGLCCPJD");
        trie.addKeyword("GGLFCCCD");
        trie.addKeyword("GGLGCJD");
        trie.addKeyword("GGLGFID");
        trie.addKeyword("GGLGPCD");
        trie.addKeyword("GGLJCCD");
        trie.addKeyword("GGLJCID");
        trie.addKeyword("GGMFJD");
        trie.addKeyword("GGMJCDGD");
        trie.addKeyword("GGMPJD");
        trie.addKeyword("GGPCCDD");
        trie.addKeyword("GGPCDD");
        trie.addKeyword("GGPCICD");
        trie.addKeyword("GGPCID");
        trie.addKeyword("GGPFCCD");
        trie.addKeyword("GGPFCD");
        trie.addKeyword("GGPFCID");
        trie.addKeyword("GGPFJD");
        trie.addKeyword("GGPGCD");
        trie.addKeyword("GGPGID");
        trie.addKeyword("GGPICFCD");
        trie.addKeyword("GGPID");
        trie.addKeyword("GGPIDD");
        trie.addKeyword("GGPIID");
        trie.addKeyword("GGPJCCCD");
        trie.addKeyword("GGPJCCD");
        trie.addKeyword("GGPJCCID");
        trie.addKeyword("GGPJCJMD");
        trie.addKeyword("GGPJID");
        trie.addKeyword("GGPJKCCD");
        trie.addKeyword("GGPJPCD");
        trie.addKeyword("GGPPCID");
        trie.addKeyword("GGPPDD");
        trie.addKeyword("GGPPFCCD");
        trie.addKeyword("GGPPICD");
        trie.addKeyword("GGPPJCD");
        trie.addKeyword("GGWCJD");
        trie.addKeyword("GGWGWID");
        trie.addKeyword("GGWIWCCD");
        trie.addKeyword("GICCCCCCCD");
        trie.addKeyword("GICCCDGD");
        trie.addKeyword("GICCDDD");
        trie.addKeyword("GICCDGCD");
        trie.addKeyword("GICCDGD");
        trie.addKeyword("GICCDWD");
        trie.addKeyword("GICCDWGD");
        trie.addKeyword("GICCFCCD");
        trie.addKeyword("GICCICCD");
        trie.addKeyword("GICCICD");
        trie.addKeyword("GICCID");
        trie.addKeyword("GICCJCCD");
        trie.addKeyword("GICDCCCD");
        trie.addKeyword("GICDDWGD");
        trie.addKeyword("GICDGD");
        trie.addKeyword("GICDGJCD");
        trie.addKeyword("GICDID");
        trie.addKeyword("GICDWD");
        trie.addKeyword("GICFD");
        trie.addKeyword("GICFID");
        trie.addKeyword("GICGCD");
        trie.addKeyword("GICICCCCCCCCPD");
        trie.addKeyword("GICICDDGD");
        trie.addKeyword("GICICDFD");
        trie.addKeyword("GICIDGD");
        trie.addKeyword("GICIFD");
        trie.addKeyword("GICIIFID");
        trie.addKeyword("GICJDD");
        trie.addKeyword("GICJDGD");
        trie.addKeyword("GICJJD");
        trie.addKeyword("GICKD");
        trie.addKeyword("GICPCD");
        trie.addKeyword("GICPID");
        trie.addKeyword("GICPIDD");
        trie.addKeyword("GICWCWCWD");
        trie.addKeyword("GIDCDD");
        trie.addKeyword("GIDDCD");
        trie.addKeyword("GIDDGD");
        trie.addKeyword("GIDDWGD");
        trie.addKeyword("GIDFCD");
        trie.addKeyword("GIDGDCD");
        trie.addKeyword("GIDJJD");
        trie.addKeyword("GIFCCCD");
        trie.addKeyword("GIFCD");
        trie.addKeyword("GIFCJD");
        trie.addKeyword("GIFFFWFWD");
        trie.addKeyword("GIFGD");
        trie.addKeyword("GIFICCCD");
        trie.addKeyword("GIFID");
        trie.addKeyword("GIFIDCD");
        trie.addKeyword("GIFJD");
        trie.addKeyword("GIFPD");
        trie.addKeyword("GIFPDCD");
        trie.addKeyword("GIGCCDMD");
        trie.addKeyword("GIGGCD");
        trie.addKeyword("GIGJD");
        trie.addKeyword("GIGMD");
        trie.addKeyword("GIICCCD");
        trie.addKeyword("GIICCDD");
        trie.addKeyword("GIICCDGD");
        trie.addKeyword("GIICCDMCD");
        trie.addKeyword("GIICDD");
        trie.addKeyword("GIICID");
        trie.addKeyword("GIIDFCD");
        trie.addKeyword("GIIDGD");
        trie.addKeyword("GIIDJCD");
        trie.addKeyword("GIIFICD");
        trie.addKeyword("GIIICCD");
        trie.addKeyword("GIIJD");
        trie.addKeyword("GIIPCD");
        trie.addKeyword("GIIPD");
        trie.addKeyword("GIJCCDD");
        trie.addKeyword("GIJCCICD");
        trie.addKeyword("GIJCCJD");
        trie.addKeyword("GIJCDCD");
        trie.addKeyword("GIJCDGD");
        trie.addKeyword("GIJCDWCFD");
        trie.addKeyword("GIJDCD");
        trie.addKeyword("GIJICCD");
        trie.addKeyword("GIJICD");
        trie.addKeyword("GIJICDGD");
        trie.addKeyword("GIJIDD");
        trie.addKeyword("GIJJD");
        trie.addKeyword("GIJJICJD");
        trie.addKeyword("GIJPCD");
        trie.addKeyword("GIJPID");
        trie.addKeyword("GILGCD");
        trie.addKeyword("GIMCID");
        trie.addKeyword("GIMCPD");
        trie.addKeyword("GIPCCCCCD");
        trie.addKeyword("GIPCCCDGD");
        trie.addKeyword("GIPCCDD");
        trie.addKeyword("GIPDCCCCD");
        trie.addKeyword("GIPDGD");
        trie.addKeyword("GIPDWCCD");
        trie.addKeyword("GIPFD");
        trie.addKeyword("GIPID");
        trie.addKeyword("GIPJCDD");
        trie.addKeyword("GIPJD");
        trie.addKeyword("GIWGFWDGD");
        trie.addKeyword("GIWGWDD");
        trie.addKeyword("GJCCCCCDCD");
        trie.addKeyword("GJCCCCCDD");
        trie.addKeyword("GJCCCCDD");
        trie.addKeyword("GJCCCDCD");
        trie.addKeyword("GJCCCDGCD");
        trie.addKeyword("GJCCCDGD");
        trie.addKeyword("GJCCCDLD");
        trie.addKeyword("GJCCCDWD");
        trie.addKeyword("GJCCCPD");
        trie.addKeyword("GJCCDFDD");
        trie.addKeyword("GJCCID");
        trie.addKeyword("GJCCPD");
        trie.addKeyword("GJCCWKWCD");
        trie.addKeyword("GJCDMCCD");
        trie.addKeyword("GJCICCD");
        trie.addKeyword("GJCIWGWCCD");
        trie.addKeyword("GJCJCDID");
        trie.addKeyword("GJCKD");
        trie.addKeyword("GJCLCCCD");
        trie.addKeyword("GJCMIGD");
        trie.addKeyword("GJCMWD");
        trie.addKeyword("GJCPDCCD");
        trie.addKeyword("GJDCDCD");
        trie.addKeyword("GJFCCCD");
        trie.addKeyword("GJFCCDWGCGD");
        trie.addKeyword("GJFCDCD");
        trie.addKeyword("GJFCDD");
        trie.addKeyword("GJFCDWFCD");
        trie.addKeyword("GJFID");
        trie.addKeyword("GJGCCCCD");
        trie.addKeyword("GJGCCCD");
        trie.addKeyword("GJGCCD");
        trie.addKeyword("GJGCCDD");
        trie.addKeyword("GJGCCDID");
        trie.addKeyword("GJGCMJD");
        trie.addKeyword("GJGFJCD");
        trie.addKeyword("GJGJCD");
        trie.addKeyword("GJGJCJCD");
        trie.addKeyword("GJGJCKDGD");
        trie.addKeyword("GJGMCCD");
        trie.addKeyword("GJGPCCCD");
        trie.addKeyword("GJGPD");
        trie.addKeyword("GJICCCCD");
        trie.addKeyword("GJICCDCD");
        trie.addKeyword("GJICDD");
        trie.addKeyword("GJICJD");
        trie.addKeyword("GJIDD");
        trie.addKeyword("GJIDWCCCWD");
        trie.addKeyword("GJIICD");
        trie.addKeyword("GJIIID");
        trie.addKeyword("GJIJCCD");
        trie.addKeyword("GJIJCD");
        trie.addKeyword("GJIJD");
        trie.addKeyword("GJIPD");
        trie.addKeyword("GJJCCDGD");
        trie.addKeyword("GJJCDCCD");
        trie.addKeyword("GJJCDCD");
        trie.addKeyword("GJJCDD");
        trie.addKeyword("GJJCID");
        trie.addKeyword("GJJCPD");
        trie.addKeyword("GJJDDCCD");
        trie.addKeyword("GJJGCCCCD");
        trie.addKeyword("GJJICCCCD");
        trie.addKeyword("GJJICCDCD");
        trie.addKeyword("GJJICD");
        trie.addKeyword("GJJID");
        trie.addKeyword("GJJIPD");
        trie.addKeyword("GJJPD");
        trie.addKeyword("GJKJCD");
        trie.addKeyword("GJKPD");
        trie.addKeyword("GJMCCCCD");
        trie.addKeyword("GJMCCCD");
        trie.addKeyword("GJMCD");
        trie.addKeyword("GJMICD");
        trie.addKeyword("GJMJCCCCD");
        trie.addKeyword("GJMJCD");
        trie.addKeyword("GJMPCDD");
        trie.addKeyword("GJPCCCDGD");
        trie.addKeyword("GJPCCDD");
        trie.addKeyword("GJPCCDGD");
        trie.addKeyword("GJPCCDID");
        trie.addKeyword("GJPCID");
        trie.addKeyword("GJPDCCD");
        trie.addKeyword("GJPDDGD");
        trie.addKeyword("GJPDGD");
        trie.addKeyword("GJPID");
        trie.addKeyword("GJPIDID");
        trie.addKeyword("GJPJCD");
        trie.addKeyword("GJPJMJCD");
        trie.addKeyword("GJPPCCD");
        trie.addKeyword("GJWGWCD");
        trie.addKeyword("GKCCCCD");
        trie.addKeyword("GKCCDCD");
        trie.addKeyword("GKCCDD");
        trie.addKeyword("GKCCDWD");
        trie.addKeyword("GKCDDICD");
        trie.addKeyword("GKCID");
        trie.addKeyword("GKCJDDWD");
        trie.addKeyword("GKCWWD");
        trie.addKeyword("GKDCCD");
        trie.addKeyword("GKDID");
        trie.addKeyword("GKGDGCDD");
        trie.addKeyword("GKGPDD");
        trie.addKeyword("GKICD");
        trie.addKeyword("GKJCCDGCD");
        trie.addKeyword("GKJCCID");
        trie.addKeyword("GKJCD");
        trie.addKeyword("GKJD");
        trie.addKeyword("GKJID");
        trie.addKeyword("GKJIPCD");
        trie.addKeyword("GKPCDFJD");
        trie.addKeyword("GKPCJD");
        trie.addKeyword("GKWD");
        trie.addKeyword("GLCCCCCID");
        trie.addKeyword("GLCCCDD");
        trie.addKeyword("GLCDCGCD");
        trie.addKeyword("GLCICD");
        trie.addKeyword("GLCID");
        trie.addKeyword("GLCJID");
        trie.addKeyword("GLCMCICD");
        trie.addKeyword("GLCPCCDGD");
        trie.addKeyword("GLCWGWDGCD");
        trie.addKeyword("GLFCCD");
        trie.addKeyword("GLFD");
        trie.addKeyword("GLFJJCD");
        trie.addKeyword("GLFKCCCD");
        trie.addKeyword("GLGCCD");
        trie.addKeyword("GLGCDDFCD");
        trie.addKeyword("GLGJCCD");
        trie.addKeyword("GLICCCCD");
        trie.addKeyword("GLICCCD");
        trie.addKeyword("GLICCDD");
        trie.addKeyword("GLIFD");
        trie.addKeyword("GLIID");
        trie.addKeyword("GLIJD");
        trie.addKeyword("GLIWDWD");
        trie.addKeyword("GLJCCPCJD");
        trie.addKeyword("GLJCDD");
        trie.addKeyword("GLJCID");
        trie.addKeyword("GLJDCD");
        trie.addKeyword("GLJGCCD");
        trie.addKeyword("GLJGCDGD");
        trie.addKeyword("GLKCIID");
        trie.addKeyword("GLMCCDD");
        trie.addKeyword("GLMCD");
        trie.addKeyword("GLPCCCCD");
        trie.addKeyword("GLPCCDD");
        trie.addKeyword("GLPCCDDFD");
        trie.addKeyword("GLPICD");
        trie.addKeyword("GLPID");
        trie.addKeyword("GLPJCD");
        trie.addKeyword("GLPPCCDD");
        trie.addKeyword("GLPWIWD");
        trie.addKeyword("GMCCCDD");
        trie.addKeyword("GMCCDCCCD");
        trie.addKeyword("GMCCDCMD");
        trie.addKeyword("GMCCDMD");
        trie.addKeyword("GMCCDWD");
        trie.addKeyword("GMCID");
        trie.addKeyword("GMCIID");
        trie.addKeyword("GMCKCD");
        trie.addKeyword("GMDPDID");
        trie.addKeyword("GMFCCD");
        trie.addKeyword("GMFCD");
        trie.addKeyword("GMFCDCDGD");
        trie.addKeyword("GMFICD");
        trie.addKeyword("GMGCD");
        trie.addKeyword("GMGCDCD");
        trie.addKeyword("GMICID");
        trie.addKeyword("GMIID");
        trie.addKeyword("GMJCCCD");
        trie.addKeyword("GMMCDGDD");
        trie.addKeyword("GMMICCD");
        trie.addKeyword("GMPCCCD");
        trie.addKeyword("GMPDGCD");
        trie.addKeyword("GMPFD");
        trie.addKeyword("GMPICD");
        trie.addKeyword("GMPID");
        trie.addKeyword("GMPMCCCD");
        trie.addKeyword("GPCCCCCD");
        trie.addKeyword("GPCCCCDGD");
        trie.addKeyword("GPCCCDGD");
        trie.addKeyword("GPCCCDLD");
        trie.addKeyword("GPCCCID");
        trie.addKeyword("GPCCCPD");
        trie.addKeyword("GPCCDGD");
        trie.addKeyword("GPCCDWD");
        trie.addKeyword("GPCCGD");
        trie.addKeyword("GPCCICD");
        trie.addKeyword("GPCCID");
        trie.addKeyword("GPCCJD");
        trie.addKeyword("GPCCWCWCD");
        trie.addKeyword("GPCDCJD");
        trie.addKeyword("GPCDDCD");
        trie.addKeyword("GPCDGFCD");
        trie.addKeyword("GPCDIID");
        trie.addKeyword("GPCFCCCDGD");
        trie.addKeyword("GPCFD");
        trie.addKeyword("GPCGCD");
        trie.addKeyword("GPCICD");
        trie.addKeyword("GPCIDD");
        trie.addKeyword("GPCIDWCWD");
        trie.addKeyword("GPCIID");
        trie.addKeyword("GPCIJCD");
        trie.addKeyword("GPCIPD");
        trie.addKeyword("GPCJD");
        trie.addKeyword("GPCKD");
        trie.addKeyword("GPCPCD");
        trie.addKeyword("GPCPCDD");
        trie.addKeyword("GPCPD");
        trie.addKeyword("GPCWWD");
        trie.addKeyword("GPFCCDWD");
        trie.addKeyword("GPFCCWD");
        trie.addKeyword("GPFCDD");
        trie.addKeyword("GPFCWFWD");
        trie.addKeyword("GPFDD");
        trie.addKeyword("GPFICD");
        trie.addKeyword("GPFIGGPCD");
        trie.addKeyword("GPFJCD");
        trie.addKeyword("GPFJD");
        trie.addKeyword("GPFJDCD");
        trie.addKeyword("GPFPCDCD");
        trie.addKeyword("GPFPD");
        trie.addKeyword("GPGCCCCD");
        trie.addKeyword("GPGCCD");
        trie.addKeyword("GPGCD");
        trie.addKeyword("GPGCDWGD");
        trie.addKeyword("GPGCGCD");
        trie.addKeyword("GPGCIICD");
        trie.addKeyword("GPGCPCCD");
        trie.addKeyword("GPGFFCD");
        trie.addKeyword("GPGICCD");
        trie.addKeyword("GPGICD");
        trie.addKeyword("GPGID");
        trie.addKeyword("GPGJCD");
        trie.addKeyword("GPGJD");
        trie.addKeyword("GPGPCGD");
        trie.addKeyword("GPGPDD");
        trie.addKeyword("GPGPGJCCD");
        trie.addKeyword("GPGPICD");
        trie.addKeyword("GPICCCCDGD");
        trie.addKeyword("GPICDD");
        trie.addKeyword("GPICDGD");
        trie.addKeyword("GPICICD");
        trie.addKeyword("GPIDFGD");
        trie.addKeyword("GPIICD");
        trie.addKeyword("GPIICDGD");
        trie.addKeyword("GPIID");
        trie.addKeyword("GPIJCCD");
        trie.addKeyword("GPIJCD");
        trie.addKeyword("GPIJCDD");
        trie.addKeyword("GPIPCCCD");
        trie.addKeyword("GPIPCCD");
        trie.addKeyword("GPJCCCCD");
        trie.addKeyword("GPJCCDD");
        trie.addKeyword("GPJCDCPD");
        trie.addKeyword("GPJCDFD");
        trie.addKeyword("GPJCDGCD");
        trie.addKeyword("GPJCDGD");
        trie.addKeyword("GPJCID");
        trie.addKeyword("GPJCIDD");
        trie.addKeyword("GPJCJCD");
        trie.addKeyword("GPJCPCCD");
        trie.addKeyword("GPJFCCD");
        trie.addKeyword("GPJFIDD");
        trie.addKeyword("GPJICD");
        trie.addKeyword("GPJID");
        trie.addKeyword("GPJPCD");
        trie.addKeyword("GPJPD");
        trie.addKeyword("GPKD");
        trie.addKeyword("GPLCCCCD");
        trie.addKeyword("GPLCCD");
        trie.addKeyword("GPLCD");
        trie.addKeyword("GPLICD");
        trie.addKeyword("GPLID");
        trie.addKeyword("GPMCCCD");
        trie.addKeyword("GPMCCD");
        trie.addKeyword("GPMCD");
        trie.addKeyword("GPMD");
        trie.addKeyword("GPMDJCD");
        trie.addKeyword("GPPCCDD");
        trie.addKeyword("GPPCCDWD");
        trie.addKeyword("GPPCDWCCCD");
        trie.addKeyword("GPPDDD");
        trie.addKeyword("GPPFD");
        trie.addKeyword("GPPGCCCD");
        trie.addKeyword("GPPGD");
        trie.addKeyword("GPPGDGD");
        trie.addKeyword("GPPICD");
        trie.addKeyword("GPPIID");
        trie.addKeyword("GPPIJD");
        trie.addKeyword("GPPJCCD");
        trie.addKeyword("GPPJCDFCD");
        trie.addKeyword("GPPJDCD");
        trie.addKeyword("GPPMJCD");
        trie.addKeyword("GPPPCD");
        trie.addKeyword("GPPPICD");
        trie.addKeyword("GPWCCD");
        trie.addKeyword("GPWGWCDGD");
        trie.addKeyword("GWCCCCD");
        trie.addKeyword("GWCWJD");
        trie.addKeyword("GWGPPD");
        trie.addKeyword("GWGWCCD");
        trie.addKeyword("GWICCD");
        trie.addKeyword("GWJD");
        trie.addKeyword("GWPCPWD");
        trie.addKeyword("ICCCDFPCCFGCCD");
        trie.addKeyword("ICCCDGD");
        trie.addKeyword("ICCCDGJD");
        trie.addKeyword("ICCCID");
        trie.addKeyword("ICCCWGWD");
        trie.addKeyword("ICCCWGWDGD");
        trie.addKeyword("ICCFJCWGFJCCD");
        trie.addKeyword("ICCICCD");
        trie.addKeyword("ICCWGWD");
        trie.addKeyword("ICDCCCCD");
        trie.addKeyword("ICDCDCD");
        trie.addKeyword("ICDGD");
        trie.addKeyword("ICDWGD");
        trie.addKeyword("ICFCD");
        trie.addKeyword("ICFCJCD");
        trie.addKeyword("ICFDID");
        trie.addKeyword("ICGD");
        trie.addKeyword("ICGGD");
        trie.addKeyword("ICICCD");
        trie.addKeyword("ICIDWID");
        trie.addKeyword("ICIWD");
        trie.addKeyword("ICJCCD");
        trie.addKeyword("ICJWGWCCD");
        trie.addKeyword("ICWGWDD");
        trie.addKeyword("IDDGCD");
        trie.addKeyword("IDGD");
        trie.addKeyword("IFCD");
        trie.addKeyword("IFCICCDGD");
        trie.addKeyword("IFGD");
        trie.addKeyword("IFICCD");
        trie.addKeyword("IFIDWGD");
        trie.addKeyword("IFKD");
        trie.addKeyword("IGCCCCDCCD");
        trie.addKeyword("IGFGJCGDD");
        trie.addKeyword("IGGDFCD");
        trie.addKeyword("IGGPCGCD");
        trie.addKeyword("IGICCD");
        trie.addKeyword("IIGCD");
        trie.addKeyword("IIICD");
        trie.addKeyword("IIID");
        trie.addKeyword("IIJD");
        trie.addKeyword("IIWGWCD");
        trie.addKeyword("IIWGWD");
        trie.addKeyword("IJCCDGD");
        trie.addKeyword("IJCCWGWD");
        trie.addKeyword("IJCDCCD");
        trie.addKeyword("IJCDD");
        trie.addKeyword("IJDD");
        trie.addKeyword("IJGCCD");
        trie.addKeyword("IJPCCD");
        trie.addKeyword("IJPCD");
        trie.addKeyword("IKCD");
        trie.addKeyword("IMCCCCD");
        trie.addKeyword("IPCCCCD");
        trie.addKeyword("IPCGD");
        trie.addKeyword("IPFD");
        trie.addKeyword("IPJCD");
        trie.addKeyword("IPPD");
        trie.addKeyword("IPPDCD");
        trie.addKeyword("IPPJCD");
        trie.addKeyword("IPWGWCCD");
        trie.addKeyword("IPWGWCD");
        trie.addKeyword("IWGMFCCDGD");
        trie.addKeyword("IWGWCCD");
        trie.addKeyword("IWGWCD");
        trie.addKeyword("IWGWD");
        trie.addKeyword("IWGWID");
        trie.addKeyword("JCCCWFWD");
        trie.addKeyword("JCCGD");
        trie.addKeyword("JCCPD");
        trie.addKeyword("JCCWGWD");
        trie.addKeyword("JCDCWMWMWCCCD");
        trie.addKeyword("JCDDWD");
        trie.addKeyword("JCGDWCPWD");
        trie.addKeyword("JCIDGD");
        trie.addKeyword("JCIWGWD");
        trie.addKeyword("JCJGCD");
        trie.addKeyword("JCPCD");
        trie.addKeyword("JCWGWCDWD");
        trie.addKeyword("JDGCCD");
        trie.addKeyword("JDWGWCD");
        trie.addKeyword("JFCCD");
        trie.addKeyword("JFCCWGWDD");
        trie.addKeyword("JFID");
        trie.addKeyword("JFJCCD");
        trie.addKeyword("JGCCD");
        trie.addKeyword("JGCCGCD");
        trie.addKeyword("JGCDFCD");
        trie.addKeyword("JGCFCCCD");
        trie.addKeyword("JGFD");
        trie.addKeyword("JGICD");
        trie.addKeyword("JGID");
        trie.addKeyword("JGJDCD");
        trie.addKeyword("JGMCCD");
        trie.addKeyword("JGPCCD");
        trie.addKeyword("JICCD");
        trie.addKeyword("JIGPCD");
        trie.addKeyword("JIICD");
        trie.addKeyword("JIPCD");
        trie.addKeyword("JJCCCDGD");
        trie.addKeyword("JJCCJD");
        trie.addKeyword("JJCGD");
        trie.addKeyword("JJCID");
        trie.addKeyword("JJCWGWCCDFGCD");
        trie.addKeyword("JJCWGWD");
        trie.addKeyword("JJLWGWCD");
        trie.addKeyword("JJPJJD");
        trie.addKeyword("JJPPCD");
        trie.addKeyword("JPCCCCWGWD");
        trie.addKeyword("JPCCCD");
        trie.addKeyword("JPIWGWID");
        trie.addKeyword("JPJJD");
        trie.addKeyword("JPWWD");
        trie.addKeyword("JWWFWCD");
        trie.addKeyword("KCCCCDD");
        trie.addKeyword("KCCDGD");
        trie.addKeyword("KCDGCD");
        trie.addKeyword("KCDGD");
        trie.addKeyword("KCFCD");
        trie.addKeyword("KCICCD");
        trie.addKeyword("KCJCCCDGD");
        trie.addKeyword("KFCCD");
        trie.addKeyword("KGCDCCCD");
        trie.addKeyword("KGCDD");
        trie.addKeyword("KGCDGD");
        trie.addKeyword("KGCGCD");
        trie.addKeyword("KGGCDID");
        trie.addKeyword("KIDJCCD");
        trie.addKeyword("KIICD");
        trie.addKeyword("KJGCD");
        trie.addKeyword("KLPCCD");
        trie.addKeyword("KPFCCD");
        trie.addKeyword("KPGCD");
        trie.addKeyword("KPICD");
        trie.addKeyword("KPKICD");
        trie.addKeyword("LCCCDGCD");
        trie.addKeyword("LCGFCD");
        trie.addKeyword("LCWGWCFDD");
        trie.addKeyword("LCWGWICD");
        trie.addKeyword("LFCCD");
        trie.addKeyword("LFCWGWCD");
        trie.addKeyword("LFJD");
        trie.addKeyword("LGCCCD");
        trie.addKeyword("LGCCD");
        trie.addKeyword("LGCICD");
        trie.addKeyword("LGCPJCD");
        trie.addKeyword("LGFCCD");
        trie.addKeyword("LGFCD");
        trie.addKeyword("LGFD");
        trie.addKeyword("LGFICD");
        trie.addKeyword("LGFID");
        trie.addKeyword("LGFJD");
        trie.addKeyword("LGFPD");
        trie.addKeyword("LGICCDGCD");
        trie.addKeyword("LGICD");
        trie.addKeyword("LGID");
        trie.addKeyword("LGIICD");
        trie.addKeyword("LGJCCD");
        trie.addKeyword("LGJCID");
        trie.addKeyword("LGLIDD");
        trie.addKeyword("LGPCCD");
        trie.addKeyword("LGPCD");
        trie.addKeyword("LGPDDWD");
        trie.addKeyword("LGPJPD");
        trie.addKeyword("LIJD");
        trie.addKeyword("LIWGWD");
        trie.addKeyword("LJFCCD");
        trie.addKeyword("LJFGCD");
        trie.addKeyword("LKGPD");
        trie.addKeyword("LKPJCCD");
        trie.addKeyword("LMPJIPCCD");
        trie.addKeyword("LPCGDGD");
        trie.addKeyword("LPPWCCD");
        trie.addKeyword("MCCID");
        trie.addKeyword("MCCWGWD");
        trie.addKeyword("MCJCCD");
        trie.addKeyword("MCWD");
        trie.addKeyword("MJCWGWD");
        trie.addKeyword("MPCFCD");
        trie.addKeyword("MPCGD");
        trie.addKeyword("PCCGGCCCCD");
        trie.addKeyword("PCCKD");
        trie.addKeyword("PCDDDCCD");
        trie.addKeyword("PCJD");
        trie.addKeyword("PCJJDD");
        trie.addKeyword("PCLGCCD");
        trie.addKeyword("PCWGWCD");
        trie.addKeyword("PCWGWID");
        trie.addKeyword("PCWGWPDWD");
        trie.addKeyword("PFCCCWGWD");
        trie.addKeyword("PFCCJICCD");
        trie.addKeyword("PFCD");
        trie.addKeyword("PFCPCDCD");
        trie.addKeyword("PFCWGWCD");
        trie.addKeyword("PFID");
        trie.addKeyword("PFPID");
        trie.addKeyword("PGCCD");
        trie.addKeyword("PGCCDGD");
        trie.addKeyword("PGCID");
        trie.addKeyword("PGCJCJD");
        trie.addKeyword("PGFCD");
        trie.addKeyword("PGJCCD");
        trie.addKeyword("PGJICD");
        trie.addKeyword("PGPCCCJD");
        trie.addKeyword("PGPCCD");
        trie.addKeyword("PGPD");
        trie.addKeyword("PGPID");
        trie.addKeyword("PIGFCD");
        trie.addKeyword("PIWGWCCD");
        trie.addKeyword("PJCCCD");
        trie.addKeyword("PJCDD");
        trie.addKeyword("PJCWGWDID");
        trie.addKeyword("PJDFFD");
        trie.addKeyword("PLDWGWCDCGD");
        trie.addKeyword("PPCCCDD");
        trie.addKeyword("PPCCD");
        trie.addKeyword("PPCCDGD");
        trie.addKeyword("PPCCGWD");
        trie.addKeyword("PPCCWGWD");
        trie.addKeyword("PPCID");
        trie.addKeyword("PPCPWCCCWCDD");
        trie.addKeyword("PPCWGWD");
        trie.addKeyword("PPDD");
        trie.addKeyword("PPFWGWCD");
        trie.addKeyword("PPICD");
        trie.addKeyword("PPIDD");
        trie.addKeyword("PPLWGWCCD");
        trie.addKeyword("PPWGWCD");
        trie.addKeyword("PPWGWD");
        trie.addKeyword("PWCCCD");
        trie.addKeyword("PWCWCD");
        trie.addKeyword("PWFWCD");
        trie.addKeyword("PWWJWGWD");
        trie.addKeyword("WCCCD");
        trie.addKeyword("WCJWD");
        trie.addKeyword("WFFPCWJD");
        trie.addKeyword("WFPWPWCCD");
        trie.addKeyword("WFWD");
        trie.addKeyword("WGCJDWFCCCD");
        trie.addKeyword("WJCCD");
        trie.addKeyword("WPWJD");
        trie.addKeyword("WWIWWCWD");
    }
}

