/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class SimpleDictionary<V> {
    BinTrie<V> trie = new BinTrie();

    public boolean load(String path) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                Map.Entry<String, V> entry = this.onGenerateEntry(line);
                if (entry == null) continue;
                this.trie.put(entry.getKey(), entry.getValue());
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
            return false;
        }
        return true;
    }

    public V get(String key) {
        return this.trie.get(key);
    }

    protected abstract Map.Entry<String, V> onGenerateEntry(String var1);

    public void combine(SimpleDictionary<V> other) {
        if (other.trie == null) {
            Predefine.logger.warning("\u6709\u4e2a\u8bcd\u5178\u8fd8\u6ca1\u52a0\u8f7d");
            return;
        }
        for (Map.Entry<String, V> entry : other.trie.entrySet()) {
            if (this.trie.containsKey(entry.getKey())) continue;
            this.trie.put(entry.getKey(), entry.getValue());
        }
    }

    public Set<Map.Entry<String, V>> entrySet() {
        return this.trie.entrySet();
    }

    public Set<String> keySet() {
        TreeSet<String> keySet = new TreeSet<String>();
        for (Map.Entry<String, V> entry : this.entrySet()) {
            keySet.add(entry.getKey());
        }
        return keySet;
    }

    public int remove(Filter filter) {
        int size = this.trie.size();
        for (Map.Entry<String, V> entry : this.entrySet()) {
            if (!filter.remove(entry)) continue;
            this.trie.remove(entry.getKey());
        }
        return size - this.trie.size();
    }

    public void add(String key, V value) {
        this.trie.put(key, value);
    }

    public int size() {
        return this.trie.size();
    }

    public static interface Filter<V> {
        public boolean remove(Map.Entry<String, V> var1);
    }
}

