/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.taintanalysis.TaintLocation;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;

public class InjectionSink {
    private final Detector detector;
    private final String bugType;
    private final int originalPriority;
    private final ClassContext classContext;
    private final Method method;
    private final InstructionHandle instructionHandle;
    private final String sinkMethod;
    private static final int UNKNOWN_SINK_PRIORITY = Integer.MAX_VALUE;
    private int sinkPriority = Integer.MAX_VALUE;
    private final List<SourceLineAnnotation> lines = new LinkedList<SourceLineAnnotation>();
    private final List<TaintLocation> unknownSources = new LinkedList<TaintLocation>();

    public InjectionSink(Detector detector, String bugType, int originalPriority, ClassContext classContext, Method method, InstructionHandle instructionHandle, String sinkMethod) {
        Objects.requireNonNull(detector, "detector");
        Objects.requireNonNull(bugType, "bugType");
        Objects.requireNonNull(classContext, "classContext");
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(instructionHandle, "instructionHandle");
        this.detector = detector;
        this.bugType = bugType;
        this.originalPriority = originalPriority;
        this.classContext = classContext;
        this.method = method;
        this.instructionHandle = instructionHandle;
        this.sinkMethod = sinkMethod == null ? "unknown" : sinkMethod;
    }

    public boolean updateSinkPriority(int priority) {
        if (priority < this.sinkPriority) {
            this.sinkPriority = priority;
            return true;
        }
        return false;
    }

    public void addLine(SourceLineAnnotation line) {
        Objects.requireNonNull(line, "line");
        this.lines.add(line);
    }

    public void addLines(Collection<TaintLocation> locations) {
        Objects.requireNonNull(this.detector, "locations");
        for (TaintLocation location : locations) {
            this.lines.add(SourceLineAnnotation.fromVisitedInstruction((MethodDescriptor)location.getMethodDescriptor(), (int)location.getPosition()));
        }
    }

    public void addUnknownSources(Collection<TaintLocation> sources) {
        for (TaintLocation source : sources) {
            this.unknownSources.add(source);
        }
    }

    public BugInstance generateBugInstance(boolean taintedInsideMethod) {
        BugInstance bug = new BugInstance(this.detector, this.bugType, this.originalPriority);
        bug.addClassAndMethod(this.classContext.getJavaClass(), this.method);
        bug.addSourceLine(SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.classContext, (Method)this.method, (InstructionHandle)this.instructionHandle));
        this.addMessage(bug, "Sink method", this.sinkMethod);
        for (TaintLocation source : this.unknownSources) {
            this.addMessage(bug, "Unknown source", source.getTaintSource());
        }
        this.addMessage(bug, "Sink method", this.sinkMethod);
        if (this.sinkPriority != Integer.MAX_VALUE) {
            if (this.sinkPriority < this.originalPriority) {
                bug.setPriority(this.sinkPriority);
                this.addMessage(bug, "Method usage", "with tainted arguments detected");
            } else if (this.sinkPriority > this.originalPriority) {
                bug.setPriority(3);
                this.addMessage(bug, "Method usage", "detected only with safe arguments");
            }
        } else if (!taintedInsideMethod) {
            this.addMessage(bug, "Method usage", "not detected");
        }
        Collections.sort(this.lines);
        SourceLineAnnotation annotation = null;
        Iterator<SourceLineAnnotation> it = this.lines.iterator();
        while (it.hasNext()) {
            SourceLineAnnotation prev = annotation;
            annotation = it.next();
            if (prev == null || !prev.getClassName().equals(annotation.getClassName()) || prev.getStartLine() != annotation.getStartLine()) continue;
            it.remove();
        }
        for (SourceLineAnnotation sourceLine : this.lines) {
            bug.addSourceLine(sourceLine);
        }
        return bug;
    }

    private void addMessage(BugInstance bug, String role, String text) {
        StringAnnotation stringAnnotation = new StringAnnotation(text);
        stringAnnotation.setDescription(role);
        bug.add((BugAnnotation)stringAnnotation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InjectionSink)) {
            return false;
        }
        InjectionSink other = (InjectionSink)obj;
        return this.bugType.equals(other.bugType) && this.originalPriority == other.originalPriority && this.classContext.getClassDescriptor().equals((Object)other.classContext.getClassDescriptor()) && this.method.getName().equals(other.method.getName()) && this.method.getSignature().equals(other.method.getSignature()) && this.method.getReturnType().equals((Object)other.method.getReturnType()) && this.instructionHandle.getInstruction().getOpcode() == other.instructionHandle.getInstruction().getOpcode() && this.instructionHandle.getPosition() == other.instructionHandle.getPosition();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.bugType.hashCode();
        hash = 67 * hash + this.originalPriority;
        hash = 67 * hash + this.classContext.getClassDescriptor().hashCode();
        hash = 67 * hash + this.method.getName().hashCode();
        hash = 67 * hash + this.method.getSignature().hashCode();
        hash = 67 * hash + this.method.getReturnType().hashCode();
        hash = 67 * hash + this.instructionHandle.getInstruction().getOpcode();
        hash = 67 * hash + this.instructionHandle.getPosition();
        return hash;
    }
}

