/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.spring;

import com.h3xstream.findsecbugs.spring.SignatureParserWithGeneric;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SpringEntityLeakDetector
implements Detector {
    private static final String ENTITY_LEAK_TYPE = "ENTITY_LEAK";
    private static final String ENTITY_MASS_ASSIGNMENT_TYPE = "ENTITY_MASS_ASSIGNMENT";
    private static final List<String> REQUEST_MAPPING_ANNOTATION_TYPES = Arrays.asList("Lorg/springframework/web/bind/annotation/RequestMapping;", "Lorg/springframework/web/bind/annotation/GetMapping;", "Lorg/springframework/web/bind/annotation/PostMapping;", "Lorg/springframework/web/bind/annotation/PutMapping;", "Lorg/springframework/web/bind/annotation/DeleteMapping;", "Lorg/springframework/web/bind/annotation/PatchMapping;");
    private static final List<String> ENTITY_ANNOTATION_TYPES = Arrays.asList("Ljavax/persistence/Entity;", "Ljakarta/persistence/Entity;", "Ljavax/jdo/spi/PersistenceCapable;", "Lorg/springframework/data/mongodb/core/mapping/Document;");
    private BugReporter reporter;

    public SpringEntityLeakDetector(BugReporter bugReporter) {
        this.reporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methods;
        JavaClass clazz = classContext.getJavaClass();
        for (Method m : methods = clazz.getMethods()) {
            if (!this.hasRequestMapping(m)) continue;
            this.analyzeMethod(m, classContext);
        }
    }

    private boolean hasRequestMapping(Method m) {
        AnnotationEntry[] annotations = m.getAnnotationEntries();
        m.getReturnType();
        for (AnnotationEntry ae : annotations) {
            if (!REQUEST_MAPPING_ANNOTATION_TYPES.contains(ae.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    private List<String> getAnnotationList(JavaClass javaClass) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (AnnotationEntry annotationEntry : javaClass.getAnnotationEntries()) {
            annotations.add(annotationEntry.getAnnotationType());
        }
        try {
            for (AnnotationEntry annotationEntry : javaClass.getSuperClasses()) {
                annotations.addAll(this.getAnnotationList((JavaClass)annotationEntry));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return annotations;
    }

    private void analyzeMethod(Method m, ClassContext classContext) {
        JavaClass clazz = classContext.getJavaClass();
        String signature = m.getGenericSignature() == null ? m.getSignature() : m.getGenericSignature();
        SignatureParserWithGeneric sig = new SignatureParserWithGeneric(signature);
        for (JavaClass[] argument : sig.getArgumentsClasses()) {
            this.testClassesForEntityAnnotation(argument, ENTITY_MASS_ASSIGNMENT_TYPE, clazz, m);
        }
        this.testClassesForEntityAnnotation(sig.getReturnClasses(), ENTITY_LEAK_TYPE, clazz, m);
    }

    public void report() {
    }

    private void testClassesForEntityAnnotation(JavaClass[] javaClasses, String bugType, JavaClass reportedClass, Method reportedMethod) {
        block0: for (JavaClass j : javaClasses) {
            for (String annotation : this.getAnnotationList(j)) {
                if (!ENTITY_ANNOTATION_TYPES.contains(annotation)) continue;
                BugInstance bug = new BugInstance((Detector)this, bugType, 2);
                bug.addClassAndMethod(reportedClass, reportedMethod);
                this.reporter.reportBug(bug);
                continue block0;
            }
        }
    }
}

