/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis.extra;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;

public class JstlExpressionWhiteLister
extends BasicInjectionDetector
implements TaintFrameAdditionalVisitor {
    private static final Pattern TAG_FOR_HTML_CONTENT_PATTERN = Pattern.compile("\\$\\{e:forHtmlContent\\([a-zA-Z0-9\\._]+\\)\\}");
    private static final String CONTEXT_PATH_PATTERN = "${pageContext.request.contextPath}";
    private static final InvokeMatcherBuilder PROPRIETARY_EVALUATE = InstructionDSL.invokeInstruction().atClass("org/apache/jasper/runtime/PageContextImpl").atMethod("proprietaryEvaluate").withArgs("(Ljava/lang/String;Ljava/lang/Class;Ljavax/servlet/jsp/PageContext;Lorg/apache/jasper/runtime/ProtectedFunctionMapper;)Ljava/lang/Object;");

    public JstlExpressionWhiteLister(BugReporter bugReporter) {
        super(bugReporter);
        this.registerVisitor(this);
    }

    @Override
    public void visitInvoke(InvokeInstruction invoke, MethodGen methodGen, TaintFrame frameType, List<Taint> parameters, ConstantPoolGen cpg) throws DataflowAnalysisException {
        String expression;
        Taint defaultVal;
        if (PROPRIETARY_EVALUATE.matches((Instruction)invoke, cpg) && (defaultVal = parameters.get(3)).getConstantValue() != null && (TAG_FOR_HTML_CONTENT_PATTERN.matcher(expression = defaultVal.getConstantValue()).find() || CONTEXT_PATH_PATTERN.equals(expression))) {
            Taint value = (Taint)frameType.getTopValue();
            value.addTag(Taint.Tag.XSS_SAFE);
        }
    }

    @Override
    public void visitLoad(LoadInstruction load, MethodGen methodGen, TaintFrame frameType, int numProduced, ConstantPoolGen cpg) {
    }

    @Override
    public void visitField(FieldInstruction put, MethodGen methodGen, TaintFrame frameType, Taint taintFrame, int numProduced, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public void visitReturn(MethodGen methodGen, Taint returnValue, ConstantPoolGen cpg) throws Exception {
    }
}

