/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.file;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class SuspiciousCommandDetector
extends BasicInjectionDetector {
    private static final InvokeMatcherBuilder RUNTIME_EXEC = InstructionDSL.invokeInstruction().atClass("java.lang.Runtime").atMethod("exec").withArgs("(Ljava/lang/String;)Ljava/lang/Process;");
    private static final InvokeMatcherBuilder RUNTIME_EXEC_WITH_ENV = InstructionDSL.invokeInstruction().atClass("java.lang.Runtime").atMethod("exec").withArgs("(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Process;");

    public SuspiciousCommandDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        for (int i = 0; i < fact.getStackDepth(); ++i) {
            String commandExecuted;
            Taint valueTaint = (Taint)fact.getStackValue(i);
            if (valueTaint.getConstantValue() == null || !(commandExecuted = valueTaint.getConstantValue()).contains("chmod") || !commandExecuted.contains("777")) continue;
            return 2;
        }
        return 5;
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        if (RUNTIME_EXEC.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, "OVERLY_PERMISSIVE_FILE_PERMISSION");
        }
        if (RUNTIME_EXEC_WITH_ENV.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{1}, "OVERLY_PERMISSIVE_FILE_PERMISSION");
        }
        return InjectionPoint.NONE;
    }
}

