/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;

public abstract class FileSystemWrapper
extends FileSystem {
    protected abstract String getPrefix();

    public boolean canWrite(String string) {
        return IOUtils.canWrite(this.unwrap(string));
    }

    public boolean setReadOnly(String string) {
        return IOUtils.setReadOnly(this.unwrap(string));
    }

    public void copy(String string, String string2) {
        IOUtils.copy(this.unwrap(string), this.unwrap(string2));
    }

    public void createDirs(String string) {
        IOUtils.createDirs(this.unwrap(string));
    }

    public boolean createNewFile(String string) {
        return IOUtils.createNewFile(this.unwrap(string));
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        return this.wrap(IOUtils.createTempFile(this.unwrap(string), string2, bl, bl2));
    }

    public void delete(String string) {
        IOUtils.delete(this.unwrap(string));
    }

    public void deleteRecursive(String string, boolean bl) {
        IOUtils.deleteRecursive(this.unwrap(string), bl);
    }

    public boolean exists(String string) {
        return IOUtils.exists(this.unwrap(string));
    }

    public boolean fileStartsWith(String string, String string2) {
        return IOUtils.fileStartsWith(this.unwrap(string), this.unwrap(string2));
    }

    public String getFileName(String string) {
        return IOUtils.getFileName(this.unwrap(string));
    }

    public long getLastModified(String string) {
        return IOUtils.getLastModified(this.unwrap(string));
    }

    public String getParent(String string) {
        return this.wrap(IOUtils.getParent(this.unwrap(string)));
    }

    public boolean isAbsolute(String string) {
        return IOUtils.isAbsolute(this.unwrap(string));
    }

    public boolean isDirectory(String string) {
        return IOUtils.isDirectory(this.unwrap(string));
    }

    public boolean isReadOnly(String string) {
        return IOUtils.isReadOnly(this.unwrap(string));
    }

    public long length(String string) {
        return IOUtils.length(this.unwrap(string));
    }

    public String[] listFiles(String string) {
        String[] stringArray = IOUtils.listFiles(this.unwrap(string));
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.wrap(stringArray[i]);
        }
        return stringArray;
    }

    public String getCanonicalPath(String string) {
        return this.wrap(IOUtils.getCanonicalPath(this.unwrap(string)));
    }

    public InputStream openFileInputStream(String string) throws IOException {
        return IOUtils.openFileInputStream(this.unwrap(string));
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        return IOUtils.openFileObject(this.unwrap(string), string2);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) {
        return IOUtils.openFileOutputStream(this.unwrap(string), bl);
    }

    public void rename(String string, String string2) {
        IOUtils.rename(this.unwrap(string), this.unwrap(string2));
    }

    public boolean tryDelete(String string) {
        return IOUtils.tryDelete(this.unwrap(string));
    }

    protected boolean accepts(String string) {
        return string.startsWith(this.getPrefix());
    }

    private String wrap(String string) {
        return this.getPrefix() + string;
    }

    public String unwrap(String string) {
        String string2 = this.getPrefix();
        if (!string.startsWith(string2)) {
            DbException.throwInternalError(string + " doesn't start with " + string2);
        }
        return string.substring(string2.length());
    }
}

