/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class HashIndex
extends BaseIndex {
    protected final int indexColumn;
    private final RegularTable tableData;
    private ValueHashMap<Long> rows;

    public HashIndex(RegularTable regularTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(regularTable, n, string, indexColumnArray, indexType);
        this.indexColumn = indexColumnArray[0].column.getColumnId();
        this.tableData = regularTable;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance();
    }

    public void truncate(Session session) {
        this.reset();
    }

    public void add(Session session, Row row) {
        Value value = row.getValue(this.indexColumn);
        Long l = this.rows.get(value);
        if (l != null) {
            throw this.getDuplicateKeyException();
        }
        this.rows.put(value, row.getKey());
    }

    public void remove(Session session, Row row) {
        this.rows.remove(row.getValue(this.indexColumn));
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError();
        }
        Long l = this.rows.get(searchRow.getValue(this.indexColumn));
        Row row = l == null ? null : this.tableData.getRow(session, l.intValue());
        return new SingleRowCursor(row);
    }

    public long getRowCount(Session session) {
        return this.getRowCountApproximation();
    }

    public long getRowCountApproximation() {
        return this.rows.size();
    }

    public void close(Session session) {
    }

    public void remove(Session session) {
    }

    public double getCost(Session session, int[] nArray) {
        for (Column column : this.columns) {
            int n = column.getColumnId();
            int n2 = nArray[n];
            if ((n2 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    public void checkRename() {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("HASH");
    }
}

