/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.h2.message.DbException;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemDisk;
import org.h2.upgrade.DbUpgradeNonPageStoreToCurrent;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbUpgrade {
    private static boolean v1dot1ClassesPresent = Utils.isClassPresent("org.h2.upgrade.v1_1.Driver");
    private static Map<String, DbUpgradeNonPageStoreToCurrent> runningConversions = Collections.synchronizedMap(new Hashtable(1));

    public static boolean areV1dot1ClassesPresent() {
        return v1dot1ClassesPresent;
    }

    public static Connection connectWithOldVersion(String string, Properties properties) throws SQLException {
        try {
            Object object;
            Object object2;
            String string2 = (String)Utils.getStaticField("org.h2.upgrade.v1_1.engine.Constants.START_URL");
            string = StringUtils.replaceAll(string, "jdbc:h2:", string2);
            string = StringUtils.replaceAllIgnoreCase(string, ";IGNORE_UNKNOWN_SETTINGS=TRUE", "");
            string = StringUtils.replaceAllIgnoreCase(string, ";IGNORE_UNKNOWN_SETTINGS=FALSE", "");
            string = StringUtils.replaceAllIgnoreCase(string, ";PAGE_STORE=TRUE", "");
            string = string + ";IGNORE_UNKNOWN_SETTINGS=TRUE";
            Object object3 = Utils.newInstance("org.h2.upgrade.v1_1.engine.ConnectionInfo", string, properties);
            boolean bl = (Boolean)Utils.callMethod(object3, "isRemote", new Object[0]);
            boolean bl2 = (Boolean)Utils.callMethod(object3, "isPersistent", new Object[0]);
            String string3 = (String)Utils.callMethod(object3, "getName", new Object[0]);
            int n = string3.indexOf(58);
            while (n != -1 && (object2 = FileSystem.getInstance((String)(object = string3.substring(0, n + 1)))) != null && !(object2 instanceof FileSystemDisk)) {
                string3 = string3.substring(n + 1);
                n = string3.indexOf(58);
            }
            object = new File(string3 + ".data.db");
            if (!bl && bl2 && ((File)object).exists()) {
                Utils.callStaticMethod("org.h2.upgrade.v1_1.Driver.load", new Object[0]);
                object2 = DriverManager.getConnection(string, properties);
                return object2;
            }
            return null;
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public static synchronized void upgrade(String string, Properties properties) throws SQLException {
        if (v1dot1ClassesPresent) {
            DbUpgrade.upgradeFromNonPageStore(string, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeFromNonPageStore(String string, Properties properties) throws SQLException {
        if (runningConversions.containsKey(string)) {
            return;
        }
        try {
            DbUpgradeNonPageStoreToCurrent dbUpgradeNonPageStoreToCurrent = new DbUpgradeNonPageStoreToCurrent(string, properties);
            runningConversions.put(string, dbUpgradeNonPageStoreToCurrent);
            dbUpgradeNonPageStoreToCurrent.upgrade();
        }
        finally {
            runningConversions.remove(string);
        }
    }
}

