/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

class WebThread
extends WebApp
implements Runnable {
    protected OutputStream output;
    protected Socket socket;
    private Thread thread;
    private InputStream input;
    private String ifModifiedSince;

    WebThread(Socket socket, WebServer webServer) {
        super(webServer);
        this.socket = socket;
        this.thread = new Thread((Runnable)this, "H2 Console thread");
    }

    void start() {
        this.thread.start();
    }

    void join(int n) throws InterruptedException {
        this.thread.join(n);
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String string) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (string.length() == 0) {
            return "index.do";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop && this.process()) {
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException {
        boolean bl = false;
        String string = this.readHeaderLine();
        if (string.startsWith("GET ") || string.startsWith("POST ")) {
            byte[] byArray;
            String string2;
            String string3;
            int n = string.indexOf(47);
            int n2 = string.lastIndexOf(32);
            String string4 = n < 0 || n2 < n ? "" : string.substring(n + 1, n2).trim();
            this.trace(string + ": " + string4);
            string4 = this.getAllowedFile(string4);
            this.attributes = new Properties();
            int n3 = string4.indexOf("?");
            this.session = null;
            if (n3 >= 0) {
                string3 = string4.substring(n3 + 1);
                this.parseAttributes(string3);
                string2 = this.attributes.getProperty("jsessionid");
                string4 = string4.substring(0, n3);
                this.session = this.server.getSession(string2);
            }
            bl = this.parseHeader();
            string3 = this.socket.getInetAddress().getHostAddress();
            if ((string4 = this.processRequest(string4, string3)).length() == 0) {
                return true;
            }
            if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                byArray = null;
                string2 = "HTTP/1.1 304 Not Modified\r\n";
            } else {
                byArray = this.server.getFile(string4);
                if (byArray == null) {
                    string2 = "HTTP/1.0 404 Not Found\r\n";
                    byArray = StringUtils.utf8Encode("File not found: " + string4);
                } else {
                    if (this.session != null && string4.endsWith(".jsp")) {
                        Iterator iterator;
                        String string5 = StringUtils.utf8Decode(byArray);
                        if (SysProperties.CONSOLE_STREAM && (iterator = (Iterator)this.session.map.remove("chunks")) != null) {
                            string2 = "HTTP/1.1 200 OK\r\n";
                            string2 = string2 + "Content-Type: " + this.mimeType + "\r\n";
                            string2 = string2 + "Cache-Control: no-cache\r\n";
                            string2 = string2 + "Transfer-Encoding: chunked\r\n";
                            string2 = string2 + "\r\n";
                            this.trace(string2);
                            this.output.write(string2.getBytes());
                            while (iterator.hasNext()) {
                                String string6 = (String)iterator.next();
                                string6 = PageParser.parse(string6, this.session.map);
                                if (byArray.length == 0) continue;
                                byArray = StringUtils.utf8Encode(string6);
                                this.output.write(Integer.toHexString(byArray.length).getBytes());
                                this.output.write("\r\n".getBytes());
                                this.output.write(byArray);
                                this.output.write("\r\n".getBytes());
                                this.output.flush();
                            }
                            this.output.write("0\r\n\r\n".getBytes());
                            this.output.flush();
                            return bl;
                        }
                        string5 = PageParser.parse(string5, this.session.map);
                        byArray = StringUtils.utf8Encode(string5);
                    }
                    string2 = "HTTP/1.1 200 OK\r\n";
                    string2 = string2 + "Content-Type: " + this.mimeType + "\r\n";
                    if (!this.cache) {
                        string2 = string2 + "Cache-Control: no-cache\r\n";
                    } else {
                        string2 = string2 + "Cache-Control: max-age=10\r\n";
                        string2 = string2 + "Last-Modified: " + this.server.getStartDateTime() + "\r\n";
                    }
                    string2 = string2 + "Content-Length: " + byArray.length + "\r\n";
                }
            }
            string2 = string2 + "\r\n";
            this.trace(string2);
            this.output.write(string2.getBytes());
            if (byArray != null) {
                this.output.write(byArray);
            }
            this.output.flush();
        }
        return bl;
    }

    private String readHeaderLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 13 && this.input.read() == 10 || n == 10) {
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            stringBuilder.append((char)n);
        }
    }

    private void parseAttributes(String string) {
        int n;
        this.trace("data=" + string);
        while (string != null && (n = string.indexOf(61)) >= 0) {
            String string2;
            String string3 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(38)) >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
            }
            String string4 = StringUtils.urlDecode(string2);
            this.attributes.put(string3, string4);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        Object object;
        boolean bl = false;
        this.trace("parseHeader");
        int n = 0;
        this.ifModifiedSince = null;
        block0: while ((object = this.readHeaderLine()) != null) {
            Object object2;
            this.trace(" " + (String)object);
            String string = StringUtils.toLowerEnglish((String)object);
            if (string.startsWith("if-modified-since")) {
                this.ifModifiedSince = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                continue;
            }
            if (string.startsWith("connection")) {
                object2 = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                if (!"keep-alive".equals(object2)) continue;
                bl = true;
                continue;
            }
            if (string.startsWith("content-length")) {
                n = Integer.parseInt(((String)object).substring(((String)object).indexOf(58) + 1).trim());
                this.trace("len=" + n);
                continue;
            }
            if (string.startsWith("user-agent")) {
                boolean bl2 = string.indexOf("webkit/") >= 0;
                if (!bl2 || this.session == null) continue;
                this.session.put("frame-border", "1");
                this.session.put("frameset-border", "2");
                continue;
            }
            if (string.startsWith("accept-language")) {
                object2 = this.session == null ? null : this.session.locale;
                if (object2 != null) continue;
                String string2 = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("q=") || !this.server.supportsLanguage(string3)) continue;
                    int n2 = string3.indexOf(45);
                    if (n2 >= 0) {
                        String string4 = string3.substring(0, n2);
                        String string5 = string3.substring(n2 + 1);
                        object2 = new Locale(string4, string5);
                    } else {
                        object2 = new Locale(string3, "");
                    }
                    this.headerLanguage = ((Locale)object2).getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = object2;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (((String)object).trim().length() != 0) continue;
            break;
        }
        if (this.session != null && n > 0) {
            object = Utils.newBytes(n);
            for (int i = 0; i < n; i += this.input.read((byte[])object, i, n - i)) {
            }
            String string = new String((byte[])object);
            this.parseAttributes(string);
        }
        return bl;
    }

    protected String adminShutdown() {
        this.stopNow();
        return super.adminShutdown();
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(this.socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.server.traceError(unknownHostException);
            return false;
        }
    }

    private void trace(String string) {
        this.server.trace(string);
    }
}

