/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageStreamData
extends Page {
    private static final int DATA_START = 11;
    private final PageStore store;
    private int trunk;
    private int logKey;
    private Data data;
    private int remaining;

    private PageStreamData(PageStore pageStore, int n, int n2, int n3) {
        this.setPos(n);
        this.store = pageStore;
        this.trunk = n2;
        this.logKey = n3;
    }

    static PageStreamData read(PageStore pageStore, Data data, int n) {
        PageStreamData pageStreamData = new PageStreamData(pageStore, n, 0, 0);
        pageStreamData.data = data;
        pageStreamData.read();
        return pageStreamData;
    }

    static PageStreamData create(PageStore pageStore, int n, int n2, int n3) {
        return new PageStreamData(pageStore, n, n2, n3);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.trunk = this.data.readInt();
        this.logKey = this.data.readInt();
    }

    void initWrite() {
        this.data = this.store.createData();
        this.data.writeByte((byte)8);
        this.data.writeShortInt(0);
        this.data.writeInt(this.trunk);
        this.data.writeInt(this.logKey);
        this.remaining = this.store.getPageSize() - this.data.length();
    }

    int write(byte[] byArray, int n, int n2) {
        int n3 = Math.min(this.remaining, n2);
        this.data.write(byArray, n, n3);
        this.remaining -= n3;
        return n3;
    }

    public void write() {
        this.store.writePage(this.getPos(), this.data);
    }

    static int getCapacity(int n) {
        return n - 11;
    }

    void read(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data.getBytes(), n, byArray, n2, n3);
    }

    int getRemaining() {
        return this.remaining;
    }

    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    public void moveTo(Session session, int n) {
    }

    int getLogKey() {
        return this.logKey;
    }

    public String toString() {
        return "[" + this.getPos() + "] stream data key:" + this.logKey + " pos:" + this.data.length() + " remaining:" + this.remaining;
    }

    public boolean canRemove() {
        return true;
    }

    public int getReadStart() {
        return 11;
    }
}

