/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;

abstract class PageData
extends Page {
    static final int START_PARENT = 3;
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageDataIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int entryCount;
    protected long[] keys;
    protected boolean written;
    protected int memoryEstimated;

    PageData(PageDataIndex pageDataIndex, int n, Data data) {
        this.index = pageDataIndex;
        this.data = data;
        this.setPos(n);
        this.memoryEstimated = pageDataIndex.getMemoryPerPage();
    }

    abstract int getRowCount();

    abstract void setRowCountStored(int var1);

    int find(long l) {
        int n = 0;
        int n2 = this.entryCount;
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            long l2 = this.keys[n3];
            if (l2 == l) {
                return n3;
            }
            if (l2 > l) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    abstract int addRowTry(Row var1);

    abstract Cursor find(Session var1, long var2, long var4, boolean var6);

    long getKey(int n) {
        return this.keys[n];
    }

    abstract PageData split(int var1);

    void setPageId(int n) {
        int n2 = this.getPos();
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren(n2);
    }

    abstract long getLastKey();

    abstract PageDataLeaf getFirstLeaf();

    void setParentPageId(int n) {
        this.index.getPageStore().logUndo(this, this.data);
        this.parentPageId = n;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.data.setInt(3, this.parentPageId);
        }
    }

    abstract void remapChildren(int var1);

    abstract boolean remove(long var1);

    abstract void freeRecursive();

    abstract Row getRow(long var1);

    public int getMemory() {
        return this.memoryEstimated;
    }

    int getParentPageId() {
        return this.parentPageId;
    }

    public boolean canRemove() {
        return this.changeCount < this.index.getPageStore().getChangeCount();
    }
}

