/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.NonUniqueHashIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDelegateIndex;
import org.h2.index.ScanIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableData
extends Table {
    private Index scanIndex;
    private long rowCount;
    private volatile Session lockExclusive;
    private HashSet<Session> lockShared = New.hashSet();
    private Trace traceLock;
    private boolean globalTemporary;
    private final ArrayList<Index> indexes = New.arrayList();
    private long lastModificationId;
    private boolean containsLargeObject;
    private PageDataIndex mainIndex;
    private boolean waitForLock;

    public TableData(CreateTableData createTableData) {
        super(createTableData.schema, createTableData.id, createTableData.tableName, createTableData.persistIndexes, createTableData.persistData);
        Column[] columnArray = new Column[createTableData.columns.size()];
        createTableData.columns.toArray(columnArray);
        this.setColumns(columnArray);
        this.setTemporary(createTableData.temporary);
        if (createTableData.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(columnArray), IndexType.createScan(createTableData.persistData), createTableData.create, createTableData.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.scanIndex = new ScanIndex(this, createTableData.id, IndexColumn.wrap(columnArray), IndexType.createScan(createTableData.persistData));
        }
        this.indexes.add(this.scanIndex);
        for (Column column : columnArray) {
            if (!DataType.isLargeObject(column.getType())) continue;
            this.containsLargeObject = true;
            this.memoryPerRow = -1;
        }
        this.traceLock = this.database.getTrace("lock");
    }

    @Override
    public void close(Session session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
    }

    public Row getRow(Session session, long l) {
        return this.scanIndex.getRow(session, l);
    }

    @Override
    public void addRow(Session session, Row row) {
        int n = 0;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session.getId());
        }
        try {
            while (n < this.indexes.size()) {
                Index index = this.indexes.get(n);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
                ++n;
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (--n >= 0) {
                    Index index = this.indexes.get(n);
                    index.remove(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error("Could not undo operation", throwable);
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
    }

    private void checkRowCount(Session session, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && !(index instanceof PageDelegateIndex) && (l = index.getRowCount(session)) != this.rowCount + (long)n) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        Object object;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int n2 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session) != 0L ? -1 : this.getMainIndexColumn(indexType, indexColumnArray));
            if (n2 != -1) {
                this.mainIndex.setMainIndexColumn(n2);
                object = new PageDelegateIndex(this, n, string, indexType, this.mainIndex, bl, session);
            } else {
                object = new PageBtreeIndex(this, n, string, indexColumnArray, indexType, bl, session);
            }
        } else {
            object = indexType.isHash() && indexColumnArray.length <= 1 ? (indexType.isUnique() ? new HashIndex(this, n, string, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n, string, indexColumnArray, indexType)) : new TreeIndex(this, n, string, indexColumnArray, indexType);
        }
        if (this.database.isMultiVersion()) {
            object = new MultiVersionIndex((Index)object, this);
        }
        if (object.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                Index index = this.getScanIndex(session);
                long l2 = l = index.getRowCount(session);
                Cursor cursor = index.find(session, null, null);
                long l3 = 0L;
                int n3 = 10000;
                ArrayList<Row> arrayList = New.arrayList(n3);
                String string3 = this.getName() + ":" + object.getName();
                int n4 = MathUtils.convertLongToInt(l2);
                while (cursor.next()) {
                    this.database.setProgress(1, string3, MathUtils.convertLongToInt(l3++), n4);
                    Row row = cursor.get();
                    arrayList.add(row);
                    if (arrayList.size() >= n3) {
                        this.addRowsToIndex(session, arrayList, (Index)object);
                    }
                    --l;
                }
                this.addRowsToIndex(session, arrayList, (Index)object);
                if (SysProperties.CHECK && l != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (DbException dbException) {
                this.getSchema().freeUniqueName(string);
                try {
                    object.remove(session);
                }
                catch (DbException dbException2) {
                    this.trace.error("Could not remove index", dbException);
                    throw dbException2;
                }
                throw dbException;
            }
        }
        boolean bl2 = this.isTemporary();
        object.setTemporary(bl2);
        if (object.getCreateSQL() != null) {
            object.setComment(string2);
            if (bl2 && !this.isGlobalTemporary()) {
                session.addLocalTempTableIndex((Index)object);
            } else {
                this.database.addSchemaObject(session, (SchemaObject)object);
            }
        }
        this.indexes.add((Index)object);
        this.setModified();
        return object;
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.mainIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    private void addRowsToIndex(Session session, ArrayList<Row> arrayList, Index index) {
        final Index index2 = index;
        Collections.sort(arrayList, new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return index2.compareRows(row, row2);
            }
        });
        for (Row row : arrayList) {
            index.add(session, row);
        }
        arrayList.clear();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session, Row row) {
        int n;
        if (this.database.isMultiVersion()) {
            if (row.isDeleted()) {
                throw DbException.get(90131, this.getName());
            }
            n = row.getSessionId();
            int n2 = session.getId();
            if (n == 0) {
                row.setSessionId(n2);
            } else if (n != n2) {
                throw DbException.get(90131, this.getName());
            }
        }
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = this.indexes.get(n);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (++n < this.indexes.size()) {
                    Index index = this.indexes.get(n);
                    index.add(session, row);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error("Could not undo operation", throwable);
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        this.rowCount = 0L;
    }

    @Override
    boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusive == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusive == null) {
                return;
            }
        }
        if (this.lockExclusive == session) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            try {
                this.doLock(session, n, bl);
            }
            finally {
                session.setWaitForLock(null);
            }
        }
    }

    private void doLock(Session session, int n, boolean bl) {
        this.traceLock(session, bl, "requesting for");
        long l = System.currentTimeMillis() + (long)session.getLockTimeout();
        boolean bl2 = false;
        while (this.lockExclusive != session) {
            long l2;
            if (bl) {
                if (this.lockExclusive == null) {
                    if (this.lockShared.isEmpty()) {
                        this.traceLock(session, bl, "added for");
                        session.addLock(this);
                        this.lockExclusive = session;
                        return;
                    }
                    if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                        this.traceLock(session, bl, "add (upgraded) for ");
                        this.lockExclusive = session;
                        return;
                    }
                }
            } else if (this.lockExclusive == null) {
                if (n == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                    return;
                }
                if (!this.lockShared.contains(session)) {
                    this.traceLock(session, bl, "ok");
                    session.addLock(this);
                    this.lockShared.add(session);
                }
                return;
            }
            session.setWaitForLock(this);
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, this.getDeadlockDetails(arrayList));
                }
            } else {
                bl2 = true;
            }
            if ((l2 = System.currentTimeMillis()) >= l) {
                this.traceLock(session, bl, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, l - l2)) == 0L) {
                    l3 = 1L;
                }
                this.waitForLock = true;
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private String getDeadlockDetails(ArrayList<Session> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : arrayList) {
            Table table = session.getWaitForLock();
            stringBuilder.append("\nSession ").append(session.toString()).append(" is waiting to lock ").append(table.toString()).append(" while locking ");
            int n = 0;
            for (Table table2 : session.getLocks()) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof TableData)) continue;
                if (((TableData)table2).lockExclusive == session) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        Class<TableData> clazz = TableData.class;
        synchronized (TableData.class) {
            if (session2 == null) {
                session2 = session;
                set = New.hashSet();
            } else {
                if (session2 == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (set.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session);
            ArrayList<Session> arrayList = null;
            Object object = this.lockShared.iterator();
            while (object.hasNext()) {
                Table table;
                Session session3 = object.next();
                if (session3 == session || (table = session3.getWaitForLock()) == null || (arrayList = table.checkDeadlock(session3, session2, set)) == null) continue;
                arrayList.add(session);
                break;
            }
            if (arrayList == null && this.lockExclusive != null && (object = this.lockExclusive.getWaitForLock()) != null && (arrayList = ((Table)object).checkDeadlock(this.lockExclusive, session2, set)) != null) {
                arrayList.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayList;
        }
    }

    private void traceLock(Session session, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug(session.getId() + " " + (bl ? "exclusive write lock" : "shared read lock") + " " + string + " " + this.getName());
        }
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                statementBuilder.append("GLOBAL ");
            } else {
                statementBuilder.append("LOCAL ");
            }
            statementBuilder.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            statementBuilder.append("CACHED ");
        } else {
            statementBuilder.append("MEMORY ");
        }
        statementBuilder.append("TABLE ").append(this.getSQL());
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        statementBuilder.append("(\n    ");
        for (Column column : this.columns) {
            statementBuilder.appendExceptFirst(",\n    ");
            statementBuilder.append(column.getCreateSQL());
        }
        statementBuilder.append("\n)");
        if (!(this.isTemporary() || this.isPersistIndexes() || this.isPersistData())) {
            statementBuilder.append("\nNOT PERSISTENT");
        }
        return statementBuilder.toString();
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session) {
        if (this.database != null) {
            this.traceLock(session, this.lockExclusive == session, "unlock");
            if (this.lockExclusive == session) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(session);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1 && this.waitForLock) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public Row createRow(Value[] valueArray) {
        return new Row(valueArray, this.memoryPerRow);
    }

    public void setRowCount(long l) {
        this.rowCount = l;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> arrayList = this.getConstraints();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            ConstraintReferential constraintReferential;
            Constraint constraint = arrayList.get(i);
            if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

