/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.TableData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonUniqueHashCursor
implements Cursor {
    private final Session session;
    private final ArrayList<Long> positions;
    private final TableData tableData;
    private int index = -1;

    public NonUniqueHashCursor(Session session, TableData tableData, ArrayList<Long> arrayList) {
        this.session = session;
        this.tableData = tableData;
        this.positions = arrayList;
    }

    @Override
    public Row get() {
        if (this.index < 0 || this.index >= this.positions.size()) {
            return null;
        }
        return this.tableData.getRow(this.session, this.positions.get(this.index));
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        return this.positions != null && ++this.index < this.positions.size();
    }

    @Override
    public boolean previous() {
        return this.positions != null && --this.index >= 0;
    }
}

