/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.compress.CompressLZF;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.log.InDoubtTransaction;
import org.h2.log.LogSystem;
import org.h2.log.SessionState;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.store.Page;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageLog {
    public static final int NOOP = 0;
    public static final int UNDO = 1;
    public static final int COMMIT = 2;
    public static final int PREPARE_COMMIT = 3;
    public static final int ROLLBACK = 4;
    public static final int ADD = 5;
    public static final int REMOVE = 6;
    public static final int TRUNCATE = 7;
    public static final int CHECKPOINT = 8;
    public static final int FREE_LOG = 9;
    static final int RECOVERY_STAGE_UNDO = 0;
    static final int RECOVERY_STAGE_ALLOCATE = 1;
    static final int RECOVERY_STAGE_REDO = 2;
    private static final boolean COMPRESS_UNDO = true;
    private final PageStore store;
    private int pos;
    private Trace trace;
    private Data writeBuffer;
    private PageInputStream pageIn;
    private PageOutputStream pageOut;
    private DataReader in;
    private int firstTrunkPage;
    private int firstDataPage;
    private Data data;
    private int logKey;
    private int logSectionId;
    private int logPos;
    private int firstSectionId;
    private CompressLZF compress;
    private byte[] compressBuffer;
    private BitField undo = new BitField();
    private BitField undoAll = new BitField();
    private IntIntHashMap logSectionPageMap = new IntIntHashMap();
    private HashMap<Integer, SessionState> sessionStates = New.hashMap();
    private BitField usedLogPages;

    PageLog(PageStore pageStore) {
        this.store = pageStore;
        this.data = pageStore.createData();
        this.trace = pageStore.getTrace();
        this.compress = new CompressLZF();
        this.compressBuffer = new byte[pageStore.getPageSize() * 2];
    }

    void openForWriting(int n, boolean bl) throws SQLException {
        this.trace.debug("log openForWriting firstPage:" + n);
        this.firstTrunkPage = n;
        ++this.logKey;
        this.pageOut = new PageOutputStream(this.store, n, this.undoAll, this.logKey, bl);
        this.pageOut.reserve(1);
        this.store.setLogFirstPage(this.logKey, n, this.pageOut.getCurrentDataPageId());
        this.writeBuffer = this.store.createData();
    }

    void free() throws SQLException {
        if (this.pageOut != null) {
            this.pageOut.freeReserved();
        }
        PageStreamTrunk.Iterator iterator = new PageStreamTrunk.Iterator(this.store, this.firstTrunkPage);
        while (this.firstTrunkPage != 0 && this.firstTrunkPage < this.store.getPageCount()) {
            PageStreamTrunk pageStreamTrunk = iterator.next();
            if (pageStreamTrunk == null) {
                if (!iterator.canDelete()) break;
                this.store.free(this.firstTrunkPage, false);
                break;
            }
            pageStreamTrunk.free();
            this.firstTrunkPage = pageStreamTrunk.getNextTrunk();
        }
    }

    void openForReading(int n, int n2, int n3) {
        this.logKey = n;
        this.firstTrunkPage = n2;
        this.firstDataPage = n3;
    }

    void recover(int n) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log recover stage:" + n);
        }
        if (n == 1) {
            PageInputStream pageInputStream = new PageInputStream(this.store, this.logKey, this.firstTrunkPage, this.firstDataPage);
            this.usedLogPages = pageInputStream.allocateAllPages();
            pageInputStream.close();
            return;
        }
        this.pageIn = new PageInputStream(this.store, this.logKey, this.firstTrunkPage, this.firstDataPage);
        this.in = new DataReader(this.pageIn);
        int n2 = 0;
        Data data = this.store.createData();
        try {
            byte by;
            this.pos = 0;
            while ((by = this.in.read()) >= 0) {
                int n3;
                ++this.pos;
                if (by == 1) {
                    n3 = this.in.readVarInt();
                    int n4 = this.in.readVarInt();
                    if (n4 == 0) {
                        this.in.readFully(data.getBytes(), 0, this.store.getPageSize());
                    } else {
                        this.in.readFully(this.compressBuffer, 0, n4);
                        this.compress.expand(this.compressBuffer, 0, n4, data.getBytes(), 0, this.store.getPageSize());
                    }
                    if (n != 0 || this.undo.get(n3)) continue;
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log undo " + n3);
                    }
                    this.store.writePage(n3, data);
                    this.undo.set(n3);
                    this.undoAll.set(n3);
                    continue;
                }
                if (by == 5) {
                    n3 = this.in.readVarInt();
                    int n5 = this.in.readVarInt();
                    Row row = PageLog.readRow(this.in, data);
                    if (n == 0) {
                        this.store.allocateIfIndexRoot(this.pos, n5, row);
                        continue;
                    }
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n3, n2, this.pos)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo + table:" + n5 + " s:" + n3 + " " + row);
                        }
                        this.store.redo(this.pos, n5, row, true);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s:" + n3 + " + table:" + n5 + " " + row);
                    continue;
                }
                if (by == 6) {
                    n3 = this.in.readVarInt();
                    int n6 = this.in.readVarInt();
                    long l = this.in.readVarLong();
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n3, n2, this.pos)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo - table:" + n6 + " key:" + l);
                        }
                        this.store.redoDelete(this.pos, n6, l);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s:" + n3 + " - table:" + n6 + " key:" + l);
                    continue;
                }
                if (by == 7) {
                    n3 = this.in.readVarInt();
                    int n7 = this.in.readVarInt();
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n3, n2, this.pos)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo truncate table:" + n7);
                        }
                        this.store.redoTruncate(n7);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s:" + n3 + " truncate table:" + n7);
                    continue;
                }
                if (by == 3) {
                    n3 = this.in.readVarInt();
                    String string = this.in.readString();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log prepare commit " + n3 + " " + string + " pos:" + this.pos);
                    }
                    if (n != 0) continue;
                    int n8 = this.pageIn.getDataPage();
                    this.setPrepareCommit(n3, n8, string);
                    continue;
                }
                if (by == 4) {
                    n3 = this.in.readVarInt();
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log rollback " + n3 + " pos:" + this.pos);
                    continue;
                }
                if (by == 2) {
                    n3 = this.in.readVarInt();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log commit " + n3 + " pos:" + this.pos);
                    }
                    if (n != 0) continue;
                    this.setLastCommitForSession(n3, n2, this.pos);
                    continue;
                }
                if (by == 0) continue;
                if (by == 8) {
                    ++n2;
                    continue;
                }
                if (by == 9) {
                    n3 = this.in.readVarInt();
                    for (int i = 0; i < n3; ++i) {
                        int n9 = this.in.readVarInt();
                        if (n != 2 || this.usedLogPages.get(n9)) continue;
                        this.store.free(n9, false);
                    }
                    continue;
                }
                if (!this.trace.isDebugEnabled()) continue;
                this.trace.debug("log end");
                break;
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 90030) {
                this.trace.debug("log recovery stopped: " + sQLException.toString());
            }
            throw sQLException;
        }
        catch (EOFException eOFException) {
            this.trace.debug("log recovery stopped: " + eOFException.toString());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "recover");
        }
        this.undo = new BitField();
        if (n == 2) {
            this.usedLogPages = null;
        }
    }

    private void setPrepareCommit(int n, int n2, String string) {
        SessionState sessionState = this.getOrAddSessionState(n);
        InDoubtTransaction inDoubtTransaction = string == null ? null : new InDoubtTransaction(this.store, null, n, n2, string, 0);
        sessionState.inDoubtTransaction = inDoubtTransaction;
    }

    public static Row readRow(DataReader dataReader, Data data) throws IOException, SQLException {
        long l = dataReader.readVarLong();
        int n = dataReader.readVarInt();
        data.reset();
        data.checkCapacity(n);
        dataReader.readFully(data.getBytes(), 0, n);
        int n2 = data.readVarInt();
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            valueArray[i] = data.readValue();
        }
        Row row = new Row(valueArray, 0);
        row.setKey(l);
        return row;
    }

    void addUndo(int n, Data data) throws SQLException {
        try {
            if (this.undo.get(n)) {
                return;
            }
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log undo " + n);
            }
            if (SysProperties.CHECK && data == null) {
                Message.throwInternalError("Undo entry not written");
            }
            this.undo.set(n);
            this.undoAll.set(n);
            Data data2 = this.getBuffer();
            data2.writeByte((byte)1);
            data2.writeVarInt(n);
            int n2 = this.store.getPageSize();
            int n3 = this.compress.compress(data.getBytes(), n2, this.compressBuffer, 0);
            if (n3 < n2) {
                data2.writeVarInt(n3);
                data2.checkCapacity(n3);
                data2.write(this.compressBuffer, 0, n3);
            } else {
                data2.writeVarInt(0);
                data2.checkCapacity(n2);
                data2.write(data.getBytes(), 0, n2);
            }
            this.write(data2);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private void freeLogPages(IntArray intArray) throws SQLException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log frees " + intArray.get(0) + ".." + intArray.get(intArray.size() - 1));
            }
            Data data = this.getBuffer();
            data.writeByte((byte)9);
            data.writeVarInt(intArray.size());
            for (int i = 0; i < intArray.size(); ++i) {
                data.writeVarInt(intArray.get(i));
            }
            this.write(data);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private void write(Data data) throws IOException {
        this.pageOut.write(data.getBytes(), 0, data.length());
        data.reset();
    }

    void commit(int n) throws SQLException {
        try {
            LogSystem logSystem;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log commit s:" + n);
            }
            if ((logSystem = this.store.getDatabase().getLog()) == null) {
                return;
            }
            Data data = this.getBuffer();
            data.writeByte((byte)2);
            data.writeVarInt(n);
            this.write(data);
            if (logSystem.getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void prepareCommit(Session session, String string) throws SQLException {
        try {
            LogSystem logSystem;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log prepare commit s:" + session.getId() + " " + string);
            }
            if ((logSystem = this.store.getDatabase().getLog()) == null) {
                return;
            }
            int n = this.store.getPageSize();
            this.flushOut();
            this.pageOut.fillPage();
            Data data = this.getBuffer();
            data.writeByte((byte)3);
            data.writeVarInt(session.getId());
            data.writeString(string);
            if (data.length() >= PageStreamData.getCapacity(n)) {
                throw Message.getInvalidValueException(string, "transaction name (too long)");
            }
            this.write(data);
            this.flushOut();
            this.pageOut.fillPage();
            if (logSystem.getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void logAddOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log " + (bl ? "+" : "-") + " s:" + session.getId() + " table:" + n + " row:" + row);
            }
            session.addLogPos(this.logSectionId, this.logPos);
            row.setLastLog(this.logSectionId, this.logPos);
            ++this.logPos;
            this.data.reset();
            int n2 = row.getColumnCount();
            this.data.writeVarInt(n2);
            this.data.checkCapacity(row.getByteCount(this.data));
            for (int i = 0; i < n2; ++i) {
                this.data.writeValue(row.getValue(i));
            }
            Data data = this.getBuffer();
            data.writeByte((byte)(bl ? 5 : 6));
            data.writeVarInt(session.getId());
            data.writeVarInt(n);
            data.writeVarLong(row.getKey());
            if (bl) {
                data.writeVarInt(this.data.length());
                data.checkCapacity(this.data.length());
                data.write(this.data.getBytes(), 0, this.data.length());
            }
            this.write(data);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void logTruncate(Session session, int n) throws SQLException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log truncate s:" + session.getId() + " table:" + n);
            }
            session.addLogPos(this.logSectionId, this.logPos);
            ++this.logPos;
            Data data = this.getBuffer();
            data.writeByte((byte)7);
            data.writeVarInt(session.getId());
            data.writeVarInt(n);
            this.write(data);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void flush() throws SQLException {
        if (this.pageOut != null) {
            this.flushOut();
        }
    }

    void checkpoint() throws SQLException {
        try {
            Data data = this.getBuffer();
            data.writeByte((byte)8);
            this.write(data);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
        this.undo = new BitField();
        ++this.logSectionId;
        this.logPos = 0;
        this.flushOut();
        this.pageOut.fillPage();
        int n = this.pageOut.getCurrentDataPageId();
        this.logSectionPageMap.put(this.logSectionId, n);
    }

    int getLogSectionId() {
        return this.logSectionId;
    }

    long getLogPos() {
        return this.logPos;
    }

    void removeUntil(int n) throws SQLException {
        if (n == 0) {
            return;
        }
        int n2 = this.logSectionPageMap.get(n);
        this.firstTrunkPage = this.removeUntil(this.firstTrunkPage, n2);
        this.store.setLogFirstPage(this.logKey, this.firstTrunkPage, n2);
        while (this.firstSectionId < n) {
            if (this.firstSectionId > 0) {
                this.logSectionPageMap.remove(this.firstSectionId);
            }
            ++this.firstSectionId;
        }
    }

    private int removeUntil(int n, int n2) throws SQLException {
        this.trace.debug("log.removeUntil " + n2);
        while (true) {
            int n3;
            Page page = this.store.getPage(n);
            PageStreamTrunk pageStreamTrunk = (PageStreamTrunk)page;
            this.logKey = pageStreamTrunk.getLogKey();
            pageStreamTrunk.resetIndex();
            if (pageStreamTrunk.contains(n2)) {
                return pageStreamTrunk.getPos();
            }
            n = pageStreamTrunk.getNextTrunk();
            IntArray intArray = new IntArray();
            intArray.add(pageStreamTrunk.getPos());
            while ((n3 = pageStreamTrunk.getNextPageData()) != -1) {
                intArray.add(n3);
            }
            this.freeLogPages(intArray);
            this.pageOut.free(pageStreamTrunk);
        }
    }

    void close() {
        this.trace.debug("log close");
        if (this.pageOut != null) {
            this.pageOut.close();
            this.pageOut = null;
        }
        this.writeBuffer = null;
    }

    private boolean isSessionCommitted(int n, int n2, int n3) {
        SessionState sessionState = this.sessionStates.get(n);
        if (sessionState == null) {
            return false;
        }
        return sessionState.isCommitted(n2, n3);
    }

    private void setLastCommitForSession(int n, int n2, int n3) {
        SessionState sessionState = this.getOrAddSessionState(n);
        sessionState.lastCommitLog = n2;
        sessionState.lastCommitPos = n3;
        sessionState.inDoubtTransaction = null;
    }

    private SessionState getOrAddSessionState(int n) {
        Integer n2 = n;
        SessionState sessionState = this.sessionStates.get(n2);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.sessionStates.put(n2, sessionState);
            sessionState.sessionId = n;
        }
        return sessionState;
    }

    long getSize() {
        return this.pageOut == null ? 0L : this.pageOut.getSize();
    }

    ObjectArray<InDoubtTransaction> getInDoubtTransactions() {
        ObjectArray<InDoubtTransaction> objectArray = ObjectArray.newInstance();
        for (SessionState sessionState : this.sessionStates.values()) {
            InDoubtTransaction inDoubtTransaction = sessionState.inDoubtTransaction;
            if (inDoubtTransaction == null) continue;
            objectArray.add(inDoubtTransaction);
        }
        return objectArray;
    }

    void setInDoubtTransactionState(int n, int n2, boolean bl) throws SQLException {
        PageStreamData pageStreamData = (PageStreamData)this.store.getPage(n2);
        pageStreamData.initWrite();
        Data data = this.store.createData();
        data.writeByte((byte)(bl ? 2 : 4));
        data.writeVarInt(n);
        byte[] byArray = data.getBytes();
        pageStreamData.write(byArray, 0, byArray.length);
        byArray = new byte[pageStreamData.getRemaining()];
        pageStreamData.write(byArray, 0, byArray.length);
        pageStreamData.write(null);
    }

    void recoverEnd() {
        this.sessionStates = New.hashMap();
    }

    private void flushOut() throws SQLException {
        try {
            this.pageOut.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private Data getBuffer() {
        if (this.writeBuffer.length() == 0) {
            return this.writeBuffer;
        }
        return this.store.createData();
    }
}

