/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataCursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageDataLeaf
extends PageData {
    private int[] offsets;
    private Row[] rows;
    private SoftReference<Row> rowRef;
    private int firstOverflowPageId;
    private int start;
    private int overflowRowSize;
    private int columnCount;
    private int memorySize;

    private PageDataLeaf(PageDataIndex pageDataIndex, int n, Data data) {
        super(pageDataIndex, n, data);
    }

    static PageDataLeaf create(PageDataIndex pageDataIndex, int n, int n2) throws SQLException {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataLeaf, pageDataLeaf.data);
        pageDataLeaf.parentPageId = n2;
        pageDataLeaf.columnCount = pageDataIndex.getTable().getColumns().length;
        pageDataLeaf.writeHead();
        pageDataLeaf.start = pageDataLeaf.data.length();
        return pageDataLeaf;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n) throws SQLException {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n, data);
        pageDataLeaf.read();
        return pageDataLeaf;
    }

    private void read() throws SQLException {
        this.data.reset();
        int n = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + n2 + " type:" + n);
        }
        this.columnCount = this.data.readVarInt();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new long[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (n == 1) {
            if (this.entryCount != 1) {
                Message.throwInternalError("entries: " + this.entryCount);
            }
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readVarLong();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
    }

    private int getRowLength(Row row) throws SQLException {
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            n += this.data.getValueLen(row.getValue(i));
        }
        return n;
    }

    int addRowTry(Row row) throws SQLException {
        int n;
        int n2;
        this.index.getPageStore().logUndo(this, this.data);
        int n3 = this.getRowLength(row);
        int n4 = this.index.getPageStore().getPageSize();
        int n5 = this.entryCount == 0 ? n4 : this.offsets[this.entryCount - 1];
        int n6 = 2 + this.data.getVarLongLen(row.getKey());
        if (this.entryCount > 0 && n5 - n3 < this.start + n6) {
            int n7 = this.find(row.getKey());
            if (this.entryCount > 1) {
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                if (this.index.isSortedInsertMode()) {
                    return n7 < 2 ? 1 : (n7 > this.entryCount - 1 ? this.entryCount - 1 : n7);
                }
                int n8 = this.entryCount / 3;
                return n7 < n8 ? n8 : (n7 >= 2 * n8 ? 2 * n8 : n7);
            }
            return n7;
        }
        this.index.getPageStore().logUndo(this, this.data);
        int n9 = n5 - n3;
        int[] nArray = new int[this.entryCount + 1];
        long[] lArray = new long[this.entryCount + 1];
        Row[] rowArray = new Row[this.entryCount + 1];
        if (this.entryCount == 0) {
            n2 = 0;
        } else {
            this.readAllRows();
            n2 = this.find(row.getKey());
            if (n2 < this.keys.length && this.keys[n2] == row.getKey()) {
                throw this.index.getDuplicateKeyException();
            }
            System.arraycopy(this.offsets, 0, nArray, 0, n2);
            System.arraycopy(this.keys, 0, lArray, 0, n2);
            System.arraycopy(this.rows, 0, rowArray, 0, n2);
            if (n2 < this.entryCount) {
                for (n = n2; n < this.entryCount; ++n) {
                    nArray[n + 1] = this.offsets[n] - n3;
                }
                System.arraycopy(this.keys, n2, lArray, n2 + 1, this.entryCount - n2);
                System.arraycopy(this.rows, n2, rowArray, n2 + 1, this.entryCount - n2);
            }
        }
        this.written = false;
        n5 = n2 == 0 ? n4 : this.offsets[n2 - 1];
        n9 = n5 - n3;
        ++this.entryCount;
        this.start += n6;
        nArray[n2] = n9;
        lArray[n2] = row.getKey();
        rowArray[n2] = row;
        this.memorySize += row.getMemorySize();
        this.offsets = nArray;
        this.keys = lArray;
        this.rows = rowArray;
        this.index.getPageStore().update(this);
        if (n9 < this.start) {
            int n10;
            int n11;
            if (this.entryCount > 1) {
                Message.throwInternalError();
            }
            this.start += 4;
            n = n3 - (n4 - this.start);
            this.offsets[n2] = n9 = this.start;
            int n12 = this.getPos();
            int n13 = n4;
            this.firstOverflowPageId = n11 = this.index.getPageStore().allocatePage();
            this.overflowRowSize = n4 + n3;
            this.write();
            this.rowRef = new SoftReference<Row>(this.rows[0]);
            this.rows[0] = null;
            Data data = this.index.getPageStore().createData();
            data.checkCapacity(this.data.length());
            data.write(this.data.getBytes(), 0, this.data.length());
            this.data.truncate(this.index.getPageStore().getPageSize());
            do {
                int n14;
                int n15;
                if (n <= n4 - 9) {
                    n15 = 19;
                    n10 = n;
                    n14 = 0;
                } else {
                    n15 = 3;
                    n10 = n4 - 11;
                    n14 = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow pageDataOverflow = PageDataOverflow.create(this.index.getPageStore(), n11, n15, n12, n14, data, n13, n10);
                this.index.getPageStore().update(pageDataOverflow);
                n13 += n10;
                n12 = n11;
                n11 = n14;
            } while ((n -= n10) > 0);
        }
        return -1;
    }

    private void removeRow(int n) throws SQLException {
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.readAllRows();
        Row row = this.rows[n];
        if (row != null) {
            this.memorySize += row.getMemorySize();
        }
        --this.entryCount;
        if (this.entryCount < 0) {
            Message.throwInternalError();
        }
        this.firstOverflowPageId = 0;
        this.overflowRowSize = 0;
        this.rowRef = null;
        int n2 = 2 + this.data.getVarLongLen(this.keys[n]);
        int[] nArray = new int[this.entryCount];
        long[] lArray = new long[this.entryCount];
        Row[] rowArray = new Row[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.keys, 0, lArray, 0, n);
        System.arraycopy(this.rows, 0, rowArray, 0, n);
        int n3 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n4 = n3 - this.offsets[n];
        for (int i = n; i < this.entryCount; ++i) {
            nArray[i] = this.offsets[i + 1] + n4;
        }
        System.arraycopy(this.keys, n + 1, lArray, n, this.entryCount - n);
        System.arraycopy(this.rows, n + 1, rowArray, n, this.entryCount - n);
        this.start -= n2;
        this.offsets = nArray;
        this.keys = lArray;
        this.rows = rowArray;
    }

    Cursor find(Session session, long l, long l2, boolean bl) {
        int n = this.find(l);
        return new PageDataCursor(session, this, n, l2, bl);
    }

    Row getRowAt(int n) throws SQLException {
        Row row = this.rows[n];
        if (row == null) {
            if (this.firstOverflowPageId == 0) {
                this.data.setPos(this.offsets[n]);
                row = this.index.readRow(this.data, this.columnCount);
            } else {
                PageDataOverflow pageDataOverflow;
                if (this.rowRef != null && (row = this.rowRef.get()) != null) {
                    return row;
                }
                PageStore pageStore = this.index.getPageStore();
                Data data = pageStore.createData();
                int n2 = pageStore.getPageSize();
                int n3 = this.offsets[n];
                data.write(this.data.getBytes(), n3, n2 - n3);
                int n4 = this.firstOverflowPageId;
                while ((n4 = (pageDataOverflow = this.index.getPageOverflow(n4)).readInto(data)) != 0) {
                }
                this.overflowRowSize = n2 + data.length();
                data.setPos(0);
                row = this.index.readRow(data, this.columnCount);
            }
            row.setKey(this.keys[n]);
            if (this.firstOverflowPageId != 0) {
                this.rowRef = new SoftReference<Row>(row);
            } else {
                this.rows[n] = row;
                this.memorySize += row.getMemorySize();
            }
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n2, this.parentPageId);
        int n3 = n;
        while (n3 < this.entryCount) {
            int n4 = pageDataLeaf.addRowTry(this.getRowAt(n));
            if (n4 != -1) {
                Message.throwInternalError("split " + n4);
            }
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    long getLastKey() throws SQLException {
        if (this.entryCount == 0) {
            return 0L;
        }
        return this.getRowAt(this.entryCount - 1).getKey();
    }

    PageDataLeaf getNextPage() throws SQLException {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    PageDataLeaf getFirstLeaf() {
        return this;
    }

    protected void remapChildren(int n) throws SQLException {
        if (this.firstOverflowPageId == 0) {
            return;
        }
        PageDataOverflow pageDataOverflow = this.index.getPageOverflow(this.firstOverflowPageId);
        pageDataOverflow.setParentPageId(this.getPos());
        this.index.getPageStore().update(pageDataOverflow);
    }

    boolean remove(long l) throws SQLException {
        int n = this.find(l);
        if (this.keys[n] != l) {
            throw Message.getSQLException(90112, this.index.getSQL() + ": " + l);
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            this.freeChildren();
            return true;
        }
        this.removeRow(n);
        this.index.getPageStore().update(this);
        return false;
    }

    void freeChildren() throws SQLException {
        if (this.firstOverflowPageId != 0) {
            PageDataOverflow pageDataOverflow;
            PageStore pageStore = this.index.getPageStore();
            int n = this.firstOverflowPageId;
            do {
                pageDataOverflow = this.index.getPageOverflow(n);
                pageStore.free(n, false);
            } while ((n = pageDataOverflow.getNextOverflow()) != 0);
        }
    }

    Row getRow(long l) throws SQLException {
        int n = this.find(l);
        return this.getRowAt(n);
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n) {
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.write();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void readAllRows() throws SQLException {
        for (int i = 0; i < this.entryCount; ++i) {
            this.getRowAt(i);
        }
    }

    private void writeHead() {
        this.data.reset();
        int n = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            Message.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeVarInt(this.columnCount);
        this.data.writeShortInt(this.entryCount);
    }

    private void write() throws SQLException {
        int n;
        if (this.written) {
            return;
        }
        if (SysProperties.CHECK && this.firstOverflowPageId != 0 && this.rows[0] == null) {
            Message.throwInternalError(this.toString());
        }
        this.readAllRows();
        this.writeHead();
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
            this.data.checkCapacity(this.overflowRowSize);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeVarLong(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.setPos(this.offsets[n]);
            Row row = this.getRowAt(n);
            for (int i = 0; i < this.columnCount; ++i) {
                this.data.writeValue(row.getValue(i));
            }
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.firstOverflowPageId == 0 ? "" : " overflow:" + this.firstOverflowPageId) + " keys:" + Arrays.toString(this.keys) + " offsets:" + Arrays.toString(this.offsets);
    }

    public void moveTo(Session session, int n) throws SQLException {
        PageStore pageStore = this.index.getPageStore();
        pageStore.logUndo(this, this.data);
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n, this.parentPageId);
        this.readAllRows();
        pageDataLeaf.keys = this.keys;
        pageDataLeaf.overflowRowSize = this.overflowRowSize;
        pageDataLeaf.firstOverflowPageId = this.firstOverflowPageId;
        pageDataLeaf.rowRef = this.rowRef;
        pageDataLeaf.rows = this.rows;
        if (this.firstOverflowPageId != 0) {
            pageDataLeaf.rows[0] = this.getRowAt(0);
        }
        pageDataLeaf.entryCount = this.entryCount;
        pageDataLeaf.offsets = this.offsets;
        pageDataLeaf.start = this.start;
        pageDataLeaf.remapChildren(this.getPos());
        pageDataLeaf.write();
        pageDataLeaf.data.truncate(this.index.getPageStore().getPageSize());
        pageStore.update(pageDataLeaf);
        pageStore.free(this.getPos(), true);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageDataNode pageDataNode = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode.moveChild(this.getPos(), n);
        }
    }

    void setOverflow(int n) throws SQLException {
        this.index.getPageStore().logUndo(this, this.data);
        this.firstOverflowPageId = n;
        if (this.written) {
            this.writeHead();
            this.data.writeInt(this.firstOverflowPageId);
        }
        this.index.getPageStore().update(this);
    }

    public int getMemorySize() {
        return this.index.getMemorySizePerPage();
    }
}

