/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class AlterTableAlterColumn
extends SchemaCommand {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    public static final int DEFAULT = 2;
    public static final int CHANGE_TYPE = 3;
    public static final int ADD = 4;
    public static final int DROP = 5;
    public static final int SELECTIVITY = 6;
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private String addBefore;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setOldColumn(Column column) {
        this.oldColumn = column;
    }

    public void setAddBefore(String string) {
        this.addBefore = string;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.lock(this.session, true, true);
        Sequence sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
        switch (this.type) {
            case 0: {
                if (!this.oldColumn.getNullable()) break;
                this.checkNoNullValues();
                this.oldColumn.setNullable(false);
                database.update(this.session, this.table);
                break;
            }
            case 1: {
                if (this.oldColumn.getNullable()) break;
                this.checkNullable();
                this.oldColumn.setNullable(true);
                database.update(this.session, this.table);
                break;
            }
            case 2: {
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(sequence);
                database.update(this.session, this.table);
                break;
            }
            case 3: {
                this.checkNoViews();
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, null);
                this.oldColumn.setConvertNullToDefault(false);
                if (this.oldColumn.getNullable() && !this.newColumn.getNullable()) {
                    this.checkNoNullValues();
                } else if (!this.oldColumn.getNullable() && this.newColumn.getNullable()) {
                    this.checkNullable();
                }
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 4: {
                this.checkNoViews();
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 5: {
                this.checkNoViews();
                if (this.table.getColumns().length == 1) {
                    throw Message.getSQLException(90084, this.oldColumn.getSQL());
                }
                this.table.checkColumnIsNotReferenced(this.oldColumn);
                this.dropSingleColumnIndexes();
                this.copyData();
                break;
            }
            case 6: {
                int n = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(n);
                database.update(this.session, this.table);
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private void convertToIdentityIfRequired(Column column) {
        if (column.getAutoIncrement()) {
            column.setOriginalSQL("IDENTITY");
        }
    }

    private void removeSequence(Sequence sequence) throws SQLException {
        if (sequence != null) {
            this.table.removeSequence(this.session, sequence);
            sequence.setBelongsToTable(false);
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, sequence);
        }
    }

    private void checkNoViews() throws SQLException {
        ObjectArray objectArray = this.table.getChildren();
        for (int i = 0; i < objectArray.size(); ++i) {
            DbObject dbObject = (DbObject)objectArray.get(i);
            if (dbObject.getType() != 0) continue;
            throw Message.getSQLException(90122, new String[]{this.table.getName(), dbObject.getName()});
        }
    }

    private void copyData() throws SQLException {
        int n;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        Database database = this.session.getDatabase();
        String string2 = database.getTempTableName(this.session.getId());
        Column[] columnArray = this.table.getColumns();
        ObjectArray objectArray = new ObjectArray();
        for (n2 = 0; n2 < columnArray.length; ++n2) {
            object4 = columnArray[n2].getClone();
            objectArray.add(object4);
        }
        if (this.type == 5) {
            n2 = this.oldColumn.getColumnId();
            objectArray.remove(n2);
        } else if (this.type == 4) {
            n2 = this.addBefore == null ? columnArray.length : this.table.getColumn(this.addBefore).getColumnId();
            objectArray.add(n2, this.newColumn);
        } else if (this.type == 3) {
            n2 = this.oldColumn.getColumnId();
            objectArray.remove(n2);
            objectArray.add(n2, this.newColumn);
        }
        n2 = database.allocateObjectId(true, true);
        object4 = this.getSchema().createTable(string2, n2, objectArray, this.table.isPersistIndexes(), this.table.isPersistData(), false, -1, this.session);
        ((DbObjectBase)object4).setComment(this.table.getComment());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((TableData)object4).getCreateSQL());
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < objectArray.size(); ++i) {
            object3 = (Column)objectArray.get(i);
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            if (this.type == 4 && object3 == this.newColumn) {
                object2 = ((Column)object3).getDefaultExpression();
                stringBuffer2.append(object2 == null ? "NULL" : ((Expression)object2).getSQL());
                continue;
            }
            stringBuffer2.append(((Column)object3).getSQL());
        }
        stringBuffer.append(" AS SELECT ");
        if (stringBuffer2.length() == 0) {
            stringBuffer.append("*");
        } else {
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.table.getSQL());
        String string3 = stringBuffer.toString();
        this.execute(string3, true);
        object4 = (TableData)((SchemaObjectBase)object4).getSchema().getTableOrView(this.session, ((DbObjectBase)object4).getName());
        object3 = this.table.getChildren();
        object2 = new ObjectArray();
        for (int i = 0; i < ((ObjectArray)object3).size(); ++i) {
            ConstraintReferential constraintReferential;
            DbObject dbObject = (DbObject)((ObjectArray)object3).get(i);
            if (dbObject instanceof Sequence || dbObject instanceof Index && (object = (Index)dbObject).getIndexType().getBelongsToConstraint() || (object = dbObject.getCreateSQL()) == null) continue;
            if (dbObject.getType() == 0) {
                Message.throwInternalError();
            }
            string = Parser.quoteIdentifier(string2 + "_" + dbObject.getName());
            String string4 = null;
            if (dbObject instanceof ConstraintReferential && (constraintReferential = (ConstraintReferential)dbObject).getTable() != this.table) {
                string4 = constraintReferential.getCreateSQLForCopy(constraintReferential.getTable(), (Table)object4, string, false);
            }
            if (string4 == null) {
                string4 = dbObject.getCreateSQLForCopy((Table)object4, string);
            }
            if (string4 == null) continue;
            if (dbObject instanceof TriggerObject) {
                ((ObjectArray)object2).add(string4);
                continue;
            }
            this.execute(string4, true);
        }
        String string5 = this.table.getName();
        this.table.setModified();
        for (n = 0; n < columnArray.length; ++n) {
            object = columnArray[n].getSequence();
            if (object == null) continue;
            this.table.removeSequence(this.session, (Sequence)object);
            columnArray[n].setSequence(null);
        }
        for (n = 0; n < ((ObjectArray)object2).size(); ++n) {
            object = (String)((ObjectArray)object2).get(n);
            this.execute((String)object, true);
        }
        this.execute("DROP TABLE " + this.table.getSQL(), true);
        database.renameSchemaObject(this.session, (SchemaObject)object4, string5);
        object3 = ((Table)object4).getChildren();
        for (n = 0; n < ((ObjectArray)object3).size(); ++n) {
            object = (DbObject)((ObjectArray)object3).get(n);
            if (object instanceof Sequence || (string = object.getName()) == null || object.getCreateSQL() == null || !string.startsWith(string2 + "_")) continue;
            string = string.substring(string2.length() + 1);
            database.renameSchemaObject(this.session, (SchemaObject)object, string);
        }
    }

    private void execute(String string, boolean bl) throws SQLException {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl && this.session.getDatabase().isMultiVersion()) {
            this.session.commit(true);
        }
    }

    private void dropSingleColumnIndexes() throws SQLException {
        Database database = this.session.getDatabase();
        ObjectArray objectArray = this.table.getIndexes();
        for (int i = 0; i < objectArray.size(); ++i) {
            Index index = (Index)objectArray.get(i);
            if (index.getCreateSQL() == null) continue;
            boolean bl = false;
            Column[] columnArray = index.getColumns();
            for (int j = 0; j < columnArray.length; ++j) {
                if (columnArray[j] != this.oldColumn) continue;
                if (columnArray.length == 1) {
                    bl = true;
                    continue;
                }
                throw Message.getSQLException(90075, index.getSQL());
            }
            if (!bl) continue;
            database.removeSchemaObject(this.session, index);
            objectArray = this.table.getIndexes();
            i = -1;
        }
    }

    private void checkNullable() throws SQLException {
        ObjectArray objectArray = this.table.getIndexes();
        for (int i = 0; i < objectArray.size(); ++i) {
            IndexType indexType;
            Index index = (Index)objectArray.get(i);
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).getPrimaryKey() && !indexType.getHash()) continue;
            throw Message.getSQLException(90075, index.getSQL());
        }
    }

    private void checkNoNullValues() throws SQLException {
        String string = "SELECT COUNT(*) FROM " + this.table.getSQL() + " WHERE " + this.oldColumn.getSQL() + " IS NULL";
        Prepared prepared = this.session.prepare(string);
        LocalResult localResult = prepared.query(0);
        localResult.next();
        if (localResult.currentRow()[0].getInt() > 0) {
            throw Message.getSQLException(90081, this.oldColumn.getSQL());
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setSelectivity(Expression expression) {
        this.newSelectivity = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public void setNewColumn(Column column) {
        this.newColumn = column;
    }
}

