/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.h2.constant.SysProperties;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;

public class ObjectArray {
    private static final int CAPACITY_INIT = 4;
    private static final int CAPACITY_SHRINK = 256;
    private Object[] data;
    private int size;

    public ObjectArray() {
        this(4);
    }

    public ObjectArray(int n) {
        this.data = new Object[n > 1 ? n : 1];
    }

    public ObjectArray(Collection collection) {
        this.size = collection.size();
        this.data = new Object[this.size];
        Iterator iterator = collection.iterator();
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = iterator.next();
        }
    }

    private void throwException(int n) {
        throw new ArrayIndexOutOfBoundsException("i=" + n + " size=" + this.size);
    }

    public void add(Object object) {
        if (this.size >= this.data.length) {
            this.ensureCapacity(this.size);
        }
        this.data[this.size++] = object;
    }

    public Object get(int n) {
        if (SysProperties.CHECK && n >= this.size) {
            this.throwException(n);
        }
        return this.data[n];
    }

    public Object remove(int n) {
        if (SysProperties.CHECK && n >= this.size) {
            this.throwException(n);
        }
        Object object = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - n - 1);
        --this.size;
        this.data[this.size] = null;
        return object;
    }

    public void removeRange(int n, int n2) {
        if (SysProperties.CHECK && (n2 > this.size || n > n2)) {
            throw new ArrayIndexOutOfBoundsException("to=" + n2 + " from=" + n + " size=" + this.size);
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        for (int i = this.size + (n2 - n) - 1; i >= this.size; --i) {
            this.data[i] = null;
        }
    }

    public void setSize(int n) {
        this.ensureCapacity(n);
        this.size = n;
    }

    private void ensureCapacity(int n) {
        while (n >= this.data.length) {
            Object[] objectArray = new Object[Math.max(4, this.data.length * 2)];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public void trimToSize() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        this.data = objectArray;
    }

    public void add(int n, Object object) {
        if (SysProperties.CHECK && n > this.size) {
            this.throwException(n);
        }
        this.ensureCapacity(this.size);
        if (n == this.size) {
            this.add(object);
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
            this.data[n] = object;
            ++this.size;
        }
    }

    public void set(int n, Object object) {
        if (SysProperties.CHECK && n >= this.size) {
            this.throwException(n);
        }
        this.data[n] = object;
    }

    public int size() {
        return this.size;
    }

    public void toArray(Object[] objectArray) {
        ObjectUtils.arrayCopy(this.data, objectArray, this.size);
    }

    public void clear() {
        if (this.data.length > 256) {
            this.data = new Object[4];
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = null;
            }
        }
        this.size = 0;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void addAll(ObjectArray objectArray) {
        for (int i = 0; i < objectArray.size; ++i) {
            this.add(objectArray.data[i]);
        }
    }

    private void swap(int n, int n2) {
        Object object = this.data[n2];
        this.data[n2] = this.data[n];
        this.data[n] = object;
    }

    public void sort(Comparator comparator) {
        this.sort(comparator, 0, this.size - 1);
    }

    private void sort(Comparator comparator, int n, int n2) {
        Object object;
        int n3;
        int n4;
        while (n2 - n > 10) {
            n4 = RandomUtils.nextInt(n2 - n - 4) + n + 2;
            if (comparator.compare(this.get(n), this.get(n2)) > 0) {
                this.swap(n, n2);
            }
            if (comparator.compare(this.get(n4), this.get(n)) < 0) {
                this.swap(n, n4);
            } else if (comparator.compare(this.get(n4), this.get(n2)) > 0) {
                this.swap(n4, n2);
            }
            n3 = n2 - 1;
            this.swap(n4, n3);
            object = this.get(n3);
            n4 = n;
            while (true) {
                if (comparator.compare(this.get(++n4), object) < 0) {
                    continue;
                }
                while (comparator.compare(this.get(--n3), object) > 0) {
                }
                if (n4 >= n3) break;
                this.swap(n4, n3);
            }
            this.swap(n4, n2 - 1);
            this.sort(comparator, n, n4 - 1);
            n = n4 + 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            object = this.get(n4);
            for (n3 = n4 - 1; n3 >= n && comparator.compare(this.get(n3), object) > 0; --n3) {
                this.set(n3 + 1, this.get(n3));
            }
            this.set(n3 + 1, object);
        }
    }
}

