/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.index.BtreeIndex;
import org.h2.log.LogSystem;
import org.h2.message.TraceSystem;
import org.h2.table.Table;
import org.h2.util.FileUtils;
import org.h2.util.ObjectArray;

public class WriterThread
implements Runnable {
    private volatile WeakReference databaseRef;
    private int writeDelay;
    private long lastIndexFlush;
    private volatile boolean stop;
    private long oldLogFileDelete;
    private String oldLogFile;

    private WriterThread(Database database, int n) {
        this.databaseRef = new WeakReference<Database>(database);
        this.writeDelay = n;
    }

    public void setWriteDelay(int n) {
        LogSystem logSystem = this.getLog();
        this.writeDelay = n;
        if (n < SysProperties.MIN_WRITE_DELAY) {
            logSystem.setFlushOnEachCommit(true);
        } else {
            logSystem.setFlushOnEachCommit(false);
        }
    }

    public static WriterThread create(Database database, int n) {
        WriterThread writerThread = new WriterThread(database, n);
        Thread thread = new Thread(writerThread);
        thread.setName("H2 Log Writer " + database.getShortName());
        thread.setDaemon(true);
        thread.start();
        return writerThread;
    }

    private LogSystem getLog() {
        Database database = (Database)this.databaseRef.get();
        if (database == null) {
            return null;
        }
        LogSystem logSystem = database.getLog();
        return logSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIndexes(Database database) {
        long l = System.currentTimeMillis();
        if (this.lastIndexFlush + 0L > l) {
            return;
        }
        Database database2 = database;
        synchronized (database2) {
            ObjectArray objectArray = database.getAllSchemaObjects(1);
            for (int i = 0; i < objectArray.size(); ++i) {
                Table table;
                BtreeIndex btreeIndex;
                DbObject dbObject = (DbObject)objectArray.get(i);
                if (!(dbObject instanceof BtreeIndex) || (btreeIndex = (BtreeIndex)dbObject).getLastChange() == 0L || (table = btreeIndex.getTable()).isLockedExclusively() || btreeIndex.getLastChange() + 0L > l) continue;
                try {
                    btreeIndex.flush(database.getSystemSession());
                    continue;
                }
                catch (SQLException sQLException) {
                    database.getTrace("database").error("flush index " + btreeIndex.getName(), sQLException);
                }
            }
        }
        this.lastIndexFlush = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            block14: {
                Object object;
                block13: {
                    object = this;
                    synchronized (object) {
                        long l;
                        if (this.oldLogFile != null && (l = System.currentTimeMillis()) > this.oldLogFileDelete) {
                            FileUtils.tryDelete(this.oldLogFile);
                            if (!FileUtils.exists(this.oldLogFile)) {
                                this.oldLogFile = null;
                            }
                        }
                    }
                    object = (Database)this.databaseRef.get();
                    if (object == null) break;
                    try {
                        ((Database)object).checkpointIfRequired();
                    }
                    catch (SQLException sQLException) {
                        TraceSystem traceSystem = ((Database)object).getTraceSystem();
                        if (traceSystem == null) break block13;
                        traceSystem.getTrace("log").error("reconnectCheckpoint", sQLException);
                    }
                }
                LogSystem logSystem = ((Database)object).getLog();
                if (logSystem == null) break;
                try {
                    logSystem.flush();
                }
                catch (SQLException sQLException) {
                    TraceSystem traceSystem = ((Database)object).getTraceSystem();
                    if (traceSystem == null) break block14;
                    traceSystem.getTrace("log").error("flush", sQLException);
                }
            }
            int n = this.writeDelay;
            if (n < SysProperties.MIN_WRITE_DELAY) {
                n = SysProperties.MIN_WRITE_DELAY;
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.databaseRef = null;
    }

    public void stopThread() throws SQLException {
        this.stop = true;
        this.deleteLogFileLater(null);
    }

    public synchronized void deleteLogFileLater(String string) throws SQLException {
        int n;
        if (this.oldLogFile != null) {
            FileUtils.delete(this.oldLogFile);
        }
        if ((n = SysProperties.getLogFileDeleteDelay()) == 0 && string != null) {
            FileUtils.delete(string);
        } else {
            this.oldLogFile = string;
            if (string != null) {
                this.oldLogFileDelete = System.currentTimeMillis() + (long)n;
            }
        }
    }
}

